/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CodegenFactory;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.MultifileClassCodegenImpl;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegenImpl;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J.\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J,\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/codegen/DefaultCodegenFactory;", "Lorg/jetbrains/kotlin/codegen/CodegenFactory;", "()V", "createMultifileClassCodegen", "Lorg/jetbrains/kotlin/codegen/MultifileClassCodegenImpl;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "createPackageCodegen", "Lorg/jetbrains/kotlin/codegen/PackageCodegenImpl;", "generateModule", "", "errorHandler", "Lorg/jetbrains/kotlin/codegen/CompilationErrorHandler;", "generateMultifileClass", "multifileClassFqName", "handler", "generatePackage", "packageFqName", "jetFiles", "backend"})
public final class DefaultCodegenFactory
implements CodegenFactory {
    public static final DefaultCodegenFactory INSTANCE;

    @Override
    public void generateModule(@NotNull GenerationState state, @NotNull Collection<? extends KtFile> files2, @NotNull CompilationErrorHandler errorHandler2) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)errorHandler2, (String)"errorHandler");
        MultiMap filesInPackages = new MultiMap();
        MultiMap filesInMultifileClasses = new MultiMap();
        for (KtFile ktFile2 : files2) {
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(ktFile2);
            if (fileClassInfo.getWithJvmMultifileClass()) {
                filesInMultifileClasses.putValue((Object)fileClassInfo.getFacadeClassFqName(), (Object)ktFile2);
                continue;
            }
            filesInPackages.putValue((Object)ktFile2.getPackageFqName(), (Object)ktFile2);
        }
        HashSet hashSet = new HashSet(state.getObsoleteMultifileClasses());
        Set set2 = filesInMultifileClasses.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"filesInMultifileClasses.keySet()");
        for (FqName multifileClassFqName : SetsKt.plus((Set)set2, (Iterable)hashSet)) {
            CodegenFactory.Companion.doCheckCancelled(state);
            FqName fqName2 = multifileClassFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"multifileClassFqName");
            Collection collection = filesInMultifileClasses.get((Object)multifileClassFqName);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"filesInMultifileClasses.get(multifileClassFqName)");
            this.generateMultifileClass(state, fqName2, collection, errorHandler2);
        }
        HashSet packagesWithObsoleteParts = new HashSet(state.getPackagesWithObsoleteParts());
        Set set3 = packagesWithObsoleteParts;
        Set set4 = filesInPackages.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set4, (String)"filesInPackages.keySet()");
        for (FqName packageFqName : SetsKt.plus((Set)set3, (Iterable)set4)) {
            CodegenFactory.Companion.doCheckCancelled(state);
            FqName fqName3 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"packageFqName");
            Collection collection = filesInPackages.get((Object)packageFqName);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"filesInPackages.get(packageFqName)");
            this.generatePackage(state, fqName3, collection, errorHandler2);
        }
    }

    @Override
    @NotNull
    public PackageCodegenImpl createPackageCodegen(@NotNull GenerationState state, @NotNull Collection<? extends KtFile> files2, @NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return new PackageCodegenImpl(state, files2, fqName2);
    }

    @Override
    @NotNull
    public MultifileClassCodegenImpl createMultifileClassCodegen(@NotNull GenerationState state, @NotNull Collection<? extends KtFile> files2, @NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return new MultifileClassCodegenImpl(state, files2, fqName2);
    }

    private final void generateMultifileClass(GenerationState state, FqName multifileClassFqName, Collection<? extends KtFile> files2, CompilationErrorHandler handler2) {
        MultifileClassCodegen multifileClassCodegen = state.getFactory().forMultifileClass(multifileClassFqName, files2);
        Intrinsics.checkExpressionValueIsNotNull((Object)multifileClassCodegen, (String)"state.factory.forMultifi\u2026tifileClassFqName, files)");
        MultifileClassCodegen codegen2 = multifileClassCodegen;
        codegen2.generate(handler2);
    }

    public final void generatePackage(@NotNull GenerationState state, @NotNull FqName packageFqName, @NotNull Collection<? extends KtFile> jetFiles, @NotNull CompilationErrorHandler errorHandler2) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull(jetFiles, (String)"jetFiles");
        Intrinsics.checkParameterIsNotNull((Object)errorHandler2, (String)"errorHandler");
        PackageCodegen packageCodegen = state.getFactory().forPackage(packageFqName, jetFiles);
        Intrinsics.checkExpressionValueIsNotNull((Object)packageCodegen, (String)"state.factory.forPackage(packageFqName, jetFiles)");
        PackageCodegen codegen2 = packageCodegen;
        codegen2.generate(errorHandler2);
    }

    private DefaultCodegenFactory() {
    }

    static {
        DefaultCodegenFactory defaultCodegenFactory;
        INSTANCE = defaultCodegenFactory = new DefaultCodegenFactory();
    }
}

