/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.SpecialBridgeMethodsKt;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0002J(\u0010\u0015\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\tJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\tH\u0002J \u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\f\u0010\u001f\u001a\u00020\u0007*\u00020\tH\u0002R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods;", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "SPECIAL_METHODS_WITH_DEFAULTS_MAP", "", "Lorg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods$SpecialMethodDescription;", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "constFalse", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "bridge", "constMinusOne", "", "constNull", "", "findSpecialWithOverride", "Lkotlin/Pair;", "irFunction", "getSecondArg", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetValueImpl;", "makeDescription", "classFqName", "", "funName", "arity", "toDescription", "SpecialMethodDescription", "ir.backend.common"})
public final class SpecialBridgeMethods {
    private final Map<SpecialMethodDescription, Function1<IrSimpleFunction, IrExpression>> SPECIAL_METHODS_WITH_DEFAULTS_MAP;
    @NotNull
    private final CommonBackendContext context;

    private final SpecialMethodDescription makeDescription(String classFqName, String funName, int arity) {
        FqName fqName2 = new FqName(classFqName);
        Name name2 = Name.identifier(funName);
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(funName)");
        return new SpecialMethodDescription(fqName2, name2, arity);
    }

    private final SpecialMethodDescription toDescription(@NotNull IrSimpleFunction $this$toDescription) {
        return new SpecialMethodDescription(IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass($this$toDescription)), $this$toDescription.getName(), $this$toDescription.getValueParameters().size());
    }

    private final IrConstImpl<Boolean> constFalse(IrSimpleFunction bridge) {
        return new IrConstImpl<Boolean>(-1, -1, this.context.getIrBuiltIns().getBooleanType(), IrConstKind.Boolean.INSTANCE, false);
    }

    private final IrConstImpl constNull(IrSimpleFunction bridge) {
        return new IrConstImpl<Object>(-1, -1, this.context.getIrBuiltIns().getAnyNType(), IrConstKind.Null.INSTANCE, null);
    }

    private final IrConstImpl<Integer> constMinusOne(IrSimpleFunction bridge) {
        return new IrConstImpl<Integer>(-1, -1, this.context.getIrBuiltIns().getIntType(), IrConstKind.Int.INSTANCE, -1);
    }

    private final IrGetValueImpl getSecondArg(IrSimpleFunction bridge) {
        return new IrGetValueImpl(-1, -1, bridge.getValueParameters().get(1).getSymbol(), null, 8, null);
    }

    @Nullable
    public final Pair<IrSimpleFunction, Function1<IrSimpleFunction, IrExpression>> findSpecialWithOverride(@NotNull IrSimpleFunction irFunction) {
        Intrinsics.checkParameterIsNotNull((Object)irFunction, (String)"irFunction");
        Sequence<IrSimpleFunction> $this$forEach$iv = SpecialBridgeMethodsKt.allOverridden(irFunction);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrSimpleFunction overridden = (IrSimpleFunction)element$iv;
            boolean bl = false;
            SpecialMethodDescription description2 = this.toDescription(overridden);
            Function1<IrSimpleFunction, IrExpression> function1 = this.SPECIAL_METHODS_WITH_DEFAULTS_MAP.get(description2);
            if (function1 == null) continue;
            Function1<IrSimpleFunction, IrExpression> function12 = function1;
            boolean bl2 = false;
            boolean bl3 = false;
            Function1<IrSimpleFunction, IrExpression> it = function12;
            boolean bl4 = false;
            return new Pair((Object)overridden, it);
        }
        return null;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public SpecialBridgeMethods(@NotNull CommonBackendContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
        this.SPECIAL_METHODS_WITH_DEFAULTS_MAP = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)this.makeDescription("kotlin.collections.Collection", "contains", 1), (Object)new Function1<IrSimpleFunction, IrConstImpl<Boolean>>(this){

            @NotNull
            public final IrConstImpl<Boolean> invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return SpecialBridgeMethods.access$constFalse((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constFalse";
            }

            public final String getSignature() {
                return "constFalse(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }), TuplesKt.to((Object)this.makeDescription("kotlin.collections.MutableCollection", "remove", 1), (Object)new Function1<IrSimpleFunction, IrConstImpl<Boolean>>(this){

            @NotNull
            public final IrConstImpl<Boolean> invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return SpecialBridgeMethods.access$constFalse((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constFalse";
            }

            public final String getSignature() {
                return "constFalse(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }), TuplesKt.to((Object)this.makeDescription("kotlin.collections.Map", "containsKey", 1), (Object)new Function1<IrSimpleFunction, IrConstImpl<Boolean>>(this){

            @NotNull
            public final IrConstImpl<Boolean> invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return SpecialBridgeMethods.access$constFalse((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constFalse";
            }

            public final String getSignature() {
                return "constFalse(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }), TuplesKt.to((Object)this.makeDescription("kotlin.collections.Map", "containsValue", 1), (Object)new Function1<IrSimpleFunction, IrConstImpl<Boolean>>(this){

            @NotNull
            public final IrConstImpl<Boolean> invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return SpecialBridgeMethods.access$constFalse((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constFalse";
            }

            public final String getSignature() {
                return "constFalse(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }), TuplesKt.to((Object)this.makeDescription("kotlin.collections.MutableMap", "remove", 2), (Object)new Function1<IrSimpleFunction, IrConstImpl<Boolean>>(this){

            @NotNull
            public final IrConstImpl<Boolean> invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return SpecialBridgeMethods.access$constFalse((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constFalse";
            }

            public final String getSignature() {
                return "constFalse(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }), TuplesKt.to((Object)this.makeDescription("kotlin.collections.Map", "getOrDefault", 1), (Object)new Function1<IrSimpleFunction, IrGetValueImpl>(this){

            @NotNull
            public final IrGetValueImpl invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return SpecialBridgeMethods.access$getSecondArg((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "getSecondArg";
            }

            public final String getSignature() {
                return "getSecondArg(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetValueImpl;";
            }
        }), TuplesKt.to((Object)this.makeDescription("kotlin.collections.Map", "get", 1), (Object)new Function1<IrSimpleFunction, IrConstImpl>(this){

            @NotNull
            public final IrConstImpl invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return SpecialBridgeMethods.access$constNull((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constNull";
            }

            public final String getSignature() {
                return "constNull(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }), TuplesKt.to((Object)this.makeDescription("kotlin.collections.MutableMap", "remove", 1), (Object)new Function1<IrSimpleFunction, IrConstImpl>(this){

            @NotNull
            public final IrConstImpl invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return SpecialBridgeMethods.access$constNull((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constNull";
            }

            public final String getSignature() {
                return "constNull(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }), TuplesKt.to((Object)this.makeDescription("kotlin.collections.List", "indexOf", 1), (Object)new Function1<IrSimpleFunction, IrConstImpl<Integer>>(this){

            @NotNull
            public final IrConstImpl<Integer> invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return SpecialBridgeMethods.access$constMinusOne((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constMinusOne";
            }

            public final String getSignature() {
                return "constMinusOne(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        }), TuplesKt.to((Object)this.makeDescription("kotlin.collections.List", "lastIndexOf", 1), (Object)new Function1<IrSimpleFunction, IrConstImpl<Integer>>(this){

            @NotNull
            public final IrConstImpl<Integer> invoke(@NotNull IrSimpleFunction p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return SpecialBridgeMethods.access$constMinusOne((SpecialBridgeMethods)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpecialBridgeMethods.class);
            }

            public final String getName() {
                return "constMinusOne";
            }

            public final String getSignature() {
                return "constMinusOne(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }
        })});
    }

    public static final /* synthetic */ IrConstImpl access$constFalse(SpecialBridgeMethods $this, IrSimpleFunction bridge) {
        return $this.constFalse(bridge);
    }

    public static final /* synthetic */ IrGetValueImpl access$getSecondArg(SpecialBridgeMethods $this, IrSimpleFunction bridge) {
        return $this.getSecondArg(bridge);
    }

    public static final /* synthetic */ IrConstImpl access$constNull(SpecialBridgeMethods $this, IrSimpleFunction bridge) {
        return $this.constNull(bridge);
    }

    public static final /* synthetic */ IrConstImpl access$constMinusOne(SpecialBridgeMethods $this, IrSimpleFunction bridge) {
        return $this.constMinusOne(bridge);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods$SpecialMethodDescription;", "", "kotlinFqClassName", "Lorg/jetbrains/kotlin/name/FqName;", "name", "Lorg/jetbrains/kotlin/name/Name;", "arity", "", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;I)V", "getArity", "()I", "getKotlinFqClassName", "()Lorg/jetbrains/kotlin/name/FqName;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "ir.backend.common"})
    private static final class SpecialMethodDescription {
        @Nullable
        private final FqName kotlinFqClassName;
        @NotNull
        private final Name name;
        private final int arity;

        @Nullable
        public final FqName getKotlinFqClassName() {
            return this.kotlinFqClassName;
        }

        @NotNull
        public final Name getName() {
            return this.name;
        }

        public final int getArity() {
            return this.arity;
        }

        public SpecialMethodDescription(@Nullable FqName kotlinFqClassName, @NotNull Name name2, int arity) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            this.kotlinFqClassName = kotlinFqClassName;
            this.name = name2;
            this.arity = arity;
        }

        @Nullable
        public final FqName component1() {
            return this.kotlinFqClassName;
        }

        @NotNull
        public final Name component2() {
            return this.name;
        }

        public final int component3() {
            return this.arity;
        }

        @NotNull
        public final SpecialMethodDescription copy(@Nullable FqName kotlinFqClassName, @NotNull Name name2, int arity) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            return new SpecialMethodDescription(kotlinFqClassName, name2, arity);
        }

        public static /* synthetic */ SpecialMethodDescription copy$default(SpecialMethodDescription specialMethodDescription, FqName fqName2, Name name2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                fqName2 = specialMethodDescription.kotlinFqClassName;
            }
            if ((n2 & 2) != 0) {
                name2 = specialMethodDescription.name;
            }
            if ((n2 & 4) != 0) {
                n = specialMethodDescription.arity;
            }
            return specialMethodDescription.copy(fqName2, name2, n);
        }

        @NotNull
        public String toString() {
            return "SpecialMethodDescription(kotlinFqClassName=" + this.kotlinFqClassName + ", name=" + this.name + ", arity=" + this.arity + ")";
        }

        public int hashCode() {
            FqName fqName2 = this.kotlinFqClassName;
            Name name2 = this.name;
            return ((fqName2 != null ? ((Object)fqName2).hashCode() : 0) * 31 + (name2 != null ? ((Object)name2).hashCode() : 0)) * 31 + Integer.hashCode(this.arity);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SpecialMethodDescription)) break block3;
                    SpecialMethodDescription specialMethodDescription = (SpecialMethodDescription)object;
                    if (!Intrinsics.areEqual((Object)this.kotlinFqClassName, (Object)specialMethodDescription.kotlinFqClassName) || !Intrinsics.areEqual((Object)this.name, (Object)specialMethodDescription.name) || !(this.arity == specialMethodDescription.arity)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

