/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.parcel;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.android.parcel.IgnoredOnParcel;
import kotlinx.android.parcel.TypeParceler;
import kotlinx.android.parcel.WriteWith;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.parcel.ParcelableAnnotationChecker;
import org.jetbrains.kotlin.android.parcel.ParcelableResolveExtensionKt;
import org.jetbrains.kotlin.android.synthetic.diagnostic.DefaultErrorMessagesAndroid;
import org.jetbrains.kotlin.android.synthetic.diagnostic.ErrorsAndroid;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J,\u0010\u0013\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J,\u0010\u0014\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/android/parcel/ParcelableAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkIfTheContainingClassIsParcelize", "containingClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "checkIgnoredOnParcelUsage", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "checkTypeParcelerUsage", "checkWriteWithUsage", "Companion", "android-extensions-compiler"})
public final class ParcelableAnnotationChecker
implements CallChecker {
    @NotNull
    private static final FqName TYPE_PARCELER_FQNAME;
    @NotNull
    private static final FqName WRITE_WITH_FQNAME;
    @NotNull
    private static final FqName IGNORED_ON_PARCEL_FQNAME;
    public static final Companion Companion;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        if (!(obj instanceof ClassConstructorDescriptor)) {
            obj = null;
        }
        ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)obj;
        if (classConstructorDescriptor == null) {
            return;
        }
        ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
        ClassDescriptor classDescriptor2 = constructorDescriptor.getConstructedClass();
        boolean bl = false;
        boolean bl2 = false;
        ClassDescriptor it = classDescriptor2;
        boolean bl3 = false;
        ClassDescriptor classDescriptor3 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor3, (String)"it");
        ClassDescriptor classDescriptor4 = classDescriptor3.getKind() == ClassKind.ANNOTATION_CLASS ? classDescriptor2 : null;
        if (classDescriptor4 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor4, (String)"constructorDescriptor.co\u2026OTATION_CLASS } ?: return");
        ClassDescriptor annotationClass = classDescriptor4;
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        KtElement ktElement = call2.getCallElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"resolvedCall.call.callElement");
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)ktElement;
        boolean $i$f$getNonStrictParentOfType = false;
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtAnnotationEntry.class, (boolean)false);
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)annotationEntry2;
        boolean $i$f$getStrictParentOfType = false;
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtModifierListOwner.class, (boolean)true);
        if (ktModifierListOwner == null) {
            return;
        }
        KtModifierListOwner annotationOwner = ktModifierListOwner;
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(annotationClass), (Object)TYPE_PARCELER_FQNAME)) {
            this.checkTypeParcelerUsage(resolvedCall2, annotationEntry2, context2, annotationOwner);
        }
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(annotationClass), (Object)WRITE_WITH_FQNAME)) {
            this.checkWriteWithUsage(resolvedCall2, annotationEntry2, context2, annotationOwner);
        }
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(annotationClass), (Object)IGNORED_ON_PARCEL_FQNAME)) {
            this.checkIgnoredOnParcelUsage(annotationEntry2, context2, annotationOwner);
        }
    }

    private final void checkIgnoredOnParcelUsage(KtAnnotationEntry annotationEntry2, CallCheckerContext context2, KtModifierListOwner element3) {
        if (element3 instanceof KtParameter && PsiTreeUtil.getParentOfType((PsiElement)element3, KtDeclaration.class) instanceof KtPrimaryConstructor) {
            DiagnosticUtilsKt.reportFromPlugin(context2.getTrace(), (Diagnostic)ErrorsAndroid.INAPPLICABLE_IGNORED_ON_PARCEL_CONSTRUCTOR_PROPERTY.on((PsiElement)annotationEntry2), DefaultErrorMessagesAndroid.INSTANCE);
        } else if (!(element3 instanceof KtProperty) || !(PsiTreeUtil.getParentOfType((PsiElement)element3, KtDeclaration.class) instanceof KtClass)) {
            DiagnosticUtilsKt.reportFromPlugin(context2.getTrace(), (Diagnostic)ErrorsAndroid.INAPPLICABLE_IGNORED_ON_PARCEL.on((PsiElement)annotationEntry2), DefaultErrorMessagesAndroid.INSTANCE);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeParcelerUsage(ResolvedCall<?> resolvedCall2, KtAnnotationEntry annotationEntry2, CallCheckerContext context2, KtModifierListOwner element3) {
        int duplicatingAnnotationCount;
        int n;
        void $this$mapNotNullTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        DeclarationDescriptor declarationDescriptor = context2.getTrace().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element3);
        if (declarationDescriptor == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"context.trace[BindingCon\u2026IPTOR, element] ?: return");
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        Collection<KotlinType> collection = resolvedCall2.getTypeArguments().values();
        boolean bl = false;
        boolean bl2 = false;
        Iterable<KotlinType> it2 = collection;
        boolean bl3 = false;
        Collection<KotlinType> collection2 = it2.size() == 2 ? collection : null;
        if (collection2 == null || (collection2 = (KotlinType)CollectionsKt.first((Iterable)collection2)) == null) {
            return;
        }
        Collection<KotlinType> thisMappedType = collection2;
        Iterable $this$filter$iv = descriptor2.getAnnotations();
        boolean $i$f$filter = false;
        it2 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AnnotationDescriptor)element$iv$iv;
            boolean bl4 = false;
            if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)TYPE_PARCELER_FQNAME)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            KotlinType kotlinType2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl5 = false;
            AnnotationDescriptor it3 = (AnnotationDescriptor)element$iv$iv;
            boolean bl6 = false;
            List<TypeProjection> list2 = it3.getType().getArguments();
            boolean bl7 = false;
            boolean bl8 = false;
            List<TypeProjection> args = list2;
            boolean bl9 = false;
            List<TypeProjection> list3 = args.size() == 2 ? list2 : null;
            if ((list3 != null && (list3 = (TypeProjection)CollectionsKt.first(list3)) != null ? list3.getType() : null) == null) continue;
            kotlinType2 = kotlinType2;
            boolean bl10 = false;
            boolean bl11 = false;
            KotlinType it$iv$iv = kotlinType2;
            boolean bl12 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$count$iv = (List)destination$iv$iv;
        boolean $i$f$count22 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                KotlinType it4 = (KotlinType)element$iv;
                boolean bl13 = false;
                if (!Intrinsics.areEqual((Object)it4, (Object)thisMappedType)) continue;
                int n2 = ++count$iv;
                bl13 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = duplicatingAnnotationCount = count$iv;
        }
        if (duplicatingAnnotationCount > 1) {
            List<KtTypeProjection> list4 = annotationEntry2.getTypeArguments();
            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"annotationEntry.typeArguments");
            KtTypeProjection ktTypeProjection = (KtTypeProjection)CollectionsKt.firstOrNull(list4);
            KtElementImplStub reportElement = ktTypeProjection != null ? (KtElementImplStub)ktTypeProjection : (KtElementImplStub)annotationEntry2;
            DiagnosticUtilsKt.reportFromPlugin(context2.getTrace(), (Diagnostic)ErrorsAndroid.DUPLICATING_TYPE_PARCELERS.on((PsiElement)reportElement), DefaultErrorMessagesAndroid.INSTANCE);
            return;
        }
        KtModifierListOwner $i$f$count22 = element3;
        KtClassOrObject containingClass = $i$f$count22 instanceof KtClassOrObject ? (KtClassOrObject)element3 : ($i$f$count22 instanceof KtParameter ? KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)element3) : null);
        this.checkIfTheContainingClassIsParcelize(containingClass, annotationEntry2, context2);
        if (element3 instanceof KtParameter) {
            PsiElement $this$getStrictParentOfType$iv = element3;
            boolean $i$f$getStrictParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtDeclaration.class, (boolean)true) instanceof KtPrimaryConstructor) {
                ClassDescriptor containingClassDescriptor = (ClassDescriptor)context2.getTrace().get(BindingContext.CLASS, containingClass);
                AnnotationDescriptor thisAnnotationDescriptor = (AnnotationDescriptor)context2.getTrace().get(BindingContext.ANNOTATION, annotationEntry2);
                if (containingClass != null && containingClassDescriptor != null && thisAnnotationDescriptor != null) {
                    boolean bl14;
                    block16: {
                        Iterable $this$any$iv = containingClassDescriptor.getAnnotations();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl14 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (AnnotationDescriptor)element$iv;
                                boolean bl15 = false;
                                if (!Intrinsics.areEqual((Object)it.getType(), (Object)thisAnnotationDescriptor.getType())) continue;
                                bl14 = true;
                                break block16;
                            }
                            bl14 = false;
                        }
                    }
                    if (bl14) {
                        KtElement ktElement;
                        KtTypeReference ktTypeReference = annotationEntry2.getTypeReference();
                        KtTypeElement ktTypeElement = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
                        if (!(ktTypeElement instanceof KtUserType)) {
                            ktTypeElement = null;
                        }
                        KtElement reportElement = (ktElement = (KtUserType)ktTypeElement) != null && (ktElement = ktElement.getReferenceExpression()) != null ? (KtElement)ktElement : (KtElement)annotationEntry2;
                        DiagnosticUtilsKt.reportFromPlugin(context2.getTrace(), (Diagnostic)ErrorsAndroid.REDUNDANT_TYPE_PARCELER.on((PsiElement)reportElement, containingClass), DefaultErrorMessagesAndroid.INSTANCE);
                    }
                }
            }
        }
    }

    private final void checkWriteWithUsage(ResolvedCall<?> resolvedCall2, KtAnnotationEntry annotationEntry2, CallCheckerContext context2, KtModifierListOwner element3) {
        Object v6;
        Function0 $fun$reportElement$1;
        KotlinType actualType;
        block11: {
            KtModifierListOwner ktModifierListOwner = element3;
            if (!(ktModifierListOwner instanceof KtTypeReference)) {
                ktModifierListOwner = null;
            }
            if ((KtTypeReference)ktModifierListOwner == null) {
                return;
            }
            KotlinType kotlinType2 = (KotlinType)context2.getTrace().get(BindingContext.TYPE, element3);
            if (kotlinType2 == null || (kotlinType2 = TypeUtilsKt.replaceAnnotations(kotlinType2, Annotations.Companion.getEMPTY())) == null) {
                return;
            }
            actualType = kotlinType2;
            KotlinType kotlinType3 = (KotlinType)CollectionsKt.singleOrNull((Iterable)resolvedCall2.getTypeArguments().values());
            if (kotlinType3 == null) {
                return;
            }
            KotlinType parcelerType = kotlinType3;
            ClassifierDescriptor classifierDescriptor = parcelerType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor2 == null) {
                return;
            }
            ClassDescriptor parcelerClass = classDescriptor2;
            PsiElement $this$getStrictParentOfType$iv = element3;
            boolean $i$f$getStrictParentOfType = false;
            KtClassOrObject containingClass = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true);
            this.checkIfTheContainingClassIsParcelize(containingClass, annotationEntry2, context2);
            $fun$reportElement$1 = new Function0<KtElementImplStub<? extends StubElement<? extends KtElementImplStub<? extends StubElement<? extends KtElementImplStub<?>>>>>>(annotationEntry2){
                final /* synthetic */ KtAnnotationEntry $annotationEntry;

                @NotNull
                public final KtElementImplStub<? extends StubElement<? extends KtElementImplStub<? extends StubElement<? extends KtElementImplStub<?>>>>> invoke() {
                    List<KtTypeProjection> list2 = this.$annotationEntry.getTypeArguments();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"annotationEntry.typeArguments");
                    KtTypeProjection ktTypeProjection = (KtTypeProjection)CollectionsKt.singleOrNull(list2);
                    return ktTypeProjection != null ? (KtElementImplStub)ktTypeProjection : (KtElementImplStub)this.$annotationEntry;
                }
                {
                    this.$annotationEntry = ktAnnotationEntry;
                    super(0);
                }
            };
            if (parcelerClass.getKind() != ClassKind.OBJECT) {
                DiagnosticUtilsKt.reportFromPlugin(context2.getTrace(), (Diagnostic)ErrorsAndroid.PARCELER_SHOULD_BE_OBJECT.on((PsiElement)$fun$reportElement$1.invoke()), DefaultErrorMessagesAndroid.INSTANCE);
                return;
            }
            checkWriteWithUsage.2 $fun$fqName$2 = checkWriteWithUsage.2.INSTANCE;
            SimpleType simpleType2 = parcelerClass.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"parcelerClass.defaultType");
            Iterable $this$firstOrNull$iv = TypeUtilsKt.supertypes(simpleType2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KotlinType it = (KotlinType)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)checkWriteWithUsage.2.INSTANCE.invoke(it), (Object)ParcelableResolveExtensionKt.getPARCELER_FQNAME())) continue;
                v6 = element$iv;
                break block11;
            }
            v6 = null;
        }
        KotlinType kotlinType4 = v6;
        if (kotlinType4 == null) {
            return;
        }
        KotlinType parcelerSuperType = kotlinType4;
        Object object = (TypeProjection)CollectionsKt.singleOrNull(parcelerSuperType.getArguments());
        if (object == null || (object = object.getType()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parcelerSuperType.argume\u2026eOrNull()?.type ?: return");
        Object expectedType = object;
        if (!TypeUtilsKt.isSubtypeOf(actualType, (KotlinType)expectedType)) {
            DiagnosticUtilsKt.reportFromPlugin(context2.getTrace(), (Diagnostic)ErrorsAndroid.PARCELER_TYPE_INCOMPATIBLE.on((PsiElement)$fun$reportElement$1.invoke(), (KotlinType)expectedType, actualType), DefaultErrorMessagesAndroid.INSTANCE);
        }
    }

    private final void checkIfTheContainingClassIsParcelize(KtClassOrObject containingClass, KtAnnotationEntry annotationEntry2, CallCheckerContext context2) {
        ClassDescriptor containingClassDescriptor;
        if (containingClass != null && (containingClassDescriptor = (ClassDescriptor)context2.getTrace().get(BindingContext.CLASS, containingClass)) != null && !ParcelableResolveExtensionKt.isParcelize(containingClassDescriptor)) {
            KtElement ktElement;
            KtTypeReference ktTypeReference = annotationEntry2.getTypeReference();
            KtTypeElement ktTypeElement = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
            if (!(ktTypeElement instanceof KtUserType)) {
                ktTypeElement = null;
            }
            KtElement reportElement = (ktElement = (KtUserType)ktTypeElement) != null && (ktElement = ktElement.getReferenceExpression()) != null ? (KtElement)ktElement : (KtElement)annotationEntry2;
            DiagnosticUtilsKt.reportFromPlugin(context2.getTrace(), (Diagnostic)ErrorsAndroid.CLASS_SHOULD_BE_PARCELIZE.on((PsiElement)reportElement, containingClass), DefaultErrorMessagesAndroid.INSTANCE);
        }
    }

    static {
        Companion = new Companion(null);
        TYPE_PARCELER_FQNAME = new FqName(TypeParceler.class.getName());
        WRITE_WITH_FQNAME = new FqName(WriteWith.class.getName());
        IGNORED_ON_PARCEL_FQNAME = new FqName(IgnoredOnParcel.class.getName());
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/android/parcel/ParcelableAnnotationChecker$Companion;", "", "()V", "IGNORED_ON_PARCEL_FQNAME", "Lorg/jetbrains/kotlin/name/FqName;", "getIGNORED_ON_PARCEL_FQNAME", "()Lorg/jetbrains/kotlin/name/FqName;", "TYPE_PARCELER_FQNAME", "getTYPE_PARCELER_FQNAME", "WRITE_WITH_FQNAME", "getWRITE_WITH_FQNAME", "android-extensions-compiler"})
    public static final class Companion {
        @NotNull
        public final FqName getTYPE_PARCELER_FQNAME() {
            return TYPE_PARCELER_FQNAME;
        }

        @NotNull
        public final FqName getWRITE_WITH_FQNAME() {
            return WRITE_WITH_FQNAME;
        }

        @NotNull
        public final FqName getIGNORED_ON_PARCEL_FQNAME() {
            return IGNORED_ON_PARCEL_FQNAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

