/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local.xalan;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.apache.xml.serializer.ToXMLStream;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XRTreeFrag;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.intellij.plugins.xsltDebugger.rt.engine.local.xalan.XalanSupport;
import org.w3c.dom.Node;

class XObjectValue
implements Value {
    private String myTypeString;
    private Object myValue;

    XObjectValue(XObject value) {
        try {
            this.myTypeString = value != null ? value.getTypeString().replaceAll("#", "") : "undefined";
            if (value instanceof XNodeSet) {
                ArrayList<Value.Node> nodes = new ArrayList<Value.Node>();
                NodeSetDTM v = value.mutableNodeset();
                for (int i = 0; i < v.getLength(); ++i) {
                    int p = v.item(i);
                    DTM dtm = v.getDTM(p);
                    if (dtm == null) continue;
                    SourceLocator loc = dtm.getSourceLocatorFor(p);
                    nodes.add(new Value.Node(loc != null ? loc.getSystemId() : null, loc != null ? loc.getLineNumber() : -1, XalanSupport.getPath(dtm, p), dtm.getStringValue(p).toString()));
                }
                this.myValue = new Value.NodeSet(value.str(), nodes);
            } else if (value instanceof XRTreeFrag) {
                Node node = ((DTMNodeIterator)value.object()).nextNode();
                if (node == null) {
                    this.myValue = "";
                } else {
                    try {
                        ToXMLStream stream = new ToXMLStream();
                        StringWriter writer = new StringWriter();
                        stream.setWriter((Writer)writer);
                        stream.setOmitXMLDeclaration(true);
                        stream.serialize(node);
                        this.myValue = writer.toString();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.myValue = "???";
                    }
                }
            } else if (value != null) {
                this.myValue = value.object();
            }
        }
        catch (TransformerException e) {
            this.myTypeString = "UNKNOWN";
        }
    }

    public Object getValue() {
        return this.myValue;
    }

    public Value.Type getType() {
        try {
            return Value.XPathType.valueOf((String)this.myTypeString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return new Value.ObjectType(this.myTypeString);
        }
    }
}

