/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.DefaultCommitExecutorAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.commit.AbstractCommitWorkflow;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandler;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandlerKt;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.AmendCommitHandler;
import com.intellij.vcs.commit.AmendCommitHandlerImpl;
import com.intellij.vcs.commit.ChangesViewCommitWorkflow;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowHandlerKt;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowUi;
import com.intellij.vcs.commit.CommitOptions;
import com.intellij.vcs.commit.CommitProjectPanelAdapter;
import com.intellij.vcs.commit.CommitState;
import com.intellij.vcs.commit.PartialCommitInclusionModel;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001bH\u0014J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020!H\u0016J\b\u0010'\u001a\u00020\u001bH\u0002J\u0010\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u001bH\u0014J\b\u0010*\u001a\u00020\u001bH\u0014J\u001c\u0010+\u001a\u00020!2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00142\u0006\u0010.\u001a\u00020\u001bJ\u0016\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\u001b2\u0006\u00101\u001a\u000202J\"\u00103\u001a\u00020!2\f\u00104\u001a\b\u0012\u0004\u0012\u0002050\u001e2\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\u001eJ\b\u00108\u001a\u00020!H\u0002J\b\u00109\u001a\u00020!H\u0014J\b\u0010:\u001a\u00020!H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006;"}, d2={"Lcom/intellij/vcs/commit/ChangesViewCommitWorkflowHandler;", "Lcom/intellij/vcs/commit/AbstractCommitWorkflowHandler;", "Lcom/intellij/vcs/commit/ChangesViewCommitWorkflow;", "Lcom/intellij/vcs/commit/ChangesViewCommitWorkflowUi;", "workflow", "ui", "(Lcom/intellij/vcs/commit/ChangesViewCommitWorkflow;Lcom/intellij/vcs/commit/ChangesViewCommitWorkflowUi;)V", "amendCommitHandler", "Lcom/intellij/vcs/commit/AmendCommitHandler;", "getAmendCommitHandler", "()Lcom/intellij/vcs/commit/AmendCommitHandler;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "commitPanel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "getCommitPanel", "()Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "inclusionModel", "Lcom/intellij/vcs/commit/PartialCommitInclusionModel;", "knownActiveChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "getUi", "()Lcom/intellij/vcs/commit/ChangesViewCommitWorkflowUi;", "getWorkflow", "()Lcom/intellij/vcs/commit/ChangesViewCommitWorkflow;", "activate", "", "addUnversionedFiles", "createCommitExecutorActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "customCommitSucceeded", "", "ensureCommitOptions", "Lcom/intellij/vcs/commit/CommitOptions;", "getCommitState", "Lcom/intellij/vcs/commit/CommitState;", "inclusionChanged", "isDefaultCommitEnabled", "saveCommitMessage", "success", "saveCommitOptions", "setCommitState", "items", "", "force", "showCommitOptions", "isFromToolbar", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "synchronizeInclusion", "changeLists", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "unversionedFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "updateDefaultCommitAction", "updateWorkflow", "vcsesChanged", "intellij.platform.vcs.impl"})
public final class ChangesViewCommitWorkflowHandler
extends AbstractCommitWorkflowHandler<ChangesViewCommitWorkflow, ChangesViewCommitWorkflowUi> {
    @NotNull
    private final CheckinProjectPanel commitPanel;
    @NotNull
    private final AmendCommitHandler amendCommitHandler;
    private final ChangeListManager changeListManager;
    private Collection<? extends Change> knownActiveChanges;
    private final PartialCommitInclusionModel inclusionModel;
    @NotNull
    private final ChangesViewCommitWorkflow workflow;
    @NotNull
    private final ChangesViewCommitWorkflowUi ui;

    @Override
    @NotNull
    protected CheckinProjectPanel getCommitPanel() {
        return this.commitPanel;
    }

    @NotNull
    public AmendCommitHandler getAmendCommitHandler() {
        return this.amendCommitHandler;
    }

    private final CommitState getCommitState() {
        return new CommitState(this.getIncludedChanges(), this.getCommitMessage());
    }

    private final CommitOptions ensureCommitOptions() {
        if (!this.getWorkflow().getAreCommitOptionsCreated$intellij_platform_vcs_impl()) {
            this.getWorkflow().setAreCommitOptionsCreated$intellij_platform_vcs_impl(true);
            this.getWorkflow().initCommitOptions$intellij_platform_vcs_impl(this.createCommitOptions());
            AbstractCommitWorkflowKt.restoreState(this.getCommitOptions());
        }
        return this.getCommitOptions();
    }

    private final boolean isDefaultCommitEnabled() {
        Collection collection = this.getWorkflow().getVcses();
        boolean bl = false;
        return !collection.isEmpty() && !this.isCommitEmpty$intellij_platform_vcs_impl();
    }

    @Override
    public void vcsesChanged() {
        this.updateDefaultCommitAction();
        this.initCommitHandlers();
        this.getWorkflow().initCommitExecutors$intellij_platform_vcs_impl(AbstractCommitWorkflow.Companion.getCommitExecutors$intellij_platform_vcs_impl(this.getProject(), (Collection)this.getWorkflow().getVcses()));
        this.getUi().setCustomCommitActions(this.createCommitExecutorActions());
    }

    private final void updateDefaultCommitAction() {
        this.getUi().setDefaultCommitActionName(AbstractCommitWorkflowHandlerKt.getDefaultCommitActionName((Collection)this.getWorkflow().getVcses()));
        this.getUi().setDefaultCommitActionEnabled(this.isDefaultCommitEnabled());
    }

    /*
     * WARNING - void declaration
     */
    private final List<AnAction> createCommitExecutorActions() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        CommitExecutor it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection = this.getWorkflow().getCommitExecutors();
        boolean bl = false;
        if (collection.isEmpty()) {
            boolean bl2 = false;
            return CollectionsKt.emptyList();
        }
        List executors = (List)collection;
        AnAction anAction = ActionManager.getInstance().getAction("Vcs.CommitExecutor.Actions");
        if (anAction == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        ActionGroup group = (ActionGroup)anAction;
        Object[] objectArray = group.getChildren(null);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"group.getChildren(null)");
        Iterable iterable = executors;
        Collection collection2 = ArraysKt.toList((Object[])objectArray);
        boolean $i$f$filter = false;
        void var5_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CommitExecutor)element$iv$iv;
            boolean bl3 = false;
            if (!it.useDefaultAction()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<DefaultCommitExecutorAction> collection3 = (List)destination$iv$iv;
        $this$filter$iv = collection3;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (CommitExecutor)item$iv$iv;
            collection3 = destination$iv$iv;
            boolean bl4 = false;
            DefaultCommitExecutorAction defaultCommitExecutorAction = new DefaultCommitExecutorAction(it);
            collection3.add(defaultCommitExecutorAction);
        }
        collection3 = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection2, (Iterable)collection3);
    }

    /*
     * WARNING - void declaration
     */
    public final void synchronizeInclusion(@NotNull List<? extends LocalChangeList> changeLists, @NotNull List<? extends VirtualFile> unversionedFiles) {
        THashSet possibleInclusion;
        Intrinsics.checkParameterIsNotNull(changeLists, (String)"changeLists");
        Intrinsics.checkParameterIsNotNull(unversionedFiles, (String)"unversionedFiles");
        if (!this.inclusionModel.isInclusionEmpty()) {
            void $this$flatMapTo$iv;
            Iterable iterable = changeLists;
            Collection destination$iv = (Collection)new THashSet(ChangeListChange.HASHING_STRATEGY);
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                LocalChangeList it = (LocalChangeList)element$iv;
                boolean bl = false;
                Collection collection = it.getChanges();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"it.changes");
                Iterable list$iv = collection;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            possibleInclusion = (THashSet)destination$iv;
            possibleInclusion.addAll((Collection)unversionedFiles);
            this.inclusionModel.retainInclusion((Collection)possibleInclusion);
        }
        possibleInclusion = this.knownActiveChanges;
        boolean bl = false;
        if (!possibleInclusion.isEmpty()) {
            LocalChangeList localChangeList = this.changeListManager.getDefaultChangeList();
            Intrinsics.checkExpressionValueIsNotNull((Object)localChangeList, (String)"changeListManager.defaultChangeList");
            Collection activeChanges = localChangeList.getChanges();
            Iterable iterable = this.knownActiveChanges;
            Collection collection = activeChanges;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"activeChanges");
            this.knownActiveChanges = CollectionsKt.intersect((Iterable)iterable, (Iterable)collection);
        }
        this.inclusionModel.setChangeLists((Collection<? extends LocalChangeList>)changeLists);
        this.getUi().setCompletionContext(changeLists);
    }

    /*
     * WARNING - void declaration
     */
    public final void setCommitState(@NotNull Collection<? extends Object> items, boolean force) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        LocalChangeList localChangeList = this.changeListManager.getDefaultChangeList();
        Intrinsics.checkExpressionValueIsNotNull((Object)localChangeList, (String)"changeListManager.defaultChangeList");
        Collection activeChanges = localChangeList.getChanges();
        if (force || this.inclusionModel.isInclusionEmpty()) {
            this.inclusionModel.clearInclusion();
            this.getUi().includeIntoCommit(items);
            if (force) {
                Collection collection = activeChanges;
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"activeChanges");
                this.knownActiveChanges = collection;
            }
        } else {
            void $this$filterIsInstanceTo$iv$iv;
            Set<Object> set = this.inclusionModel.getInclusion();
            Collection collection = activeChanges;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"activeChanges");
            Iterable $this$filterIsInstance$iv = SetsKt.minus(set, (Iterable)((Iterable)ChangesViewCommitWorkflowHandlerKt.access$toPartialAwareSet(collection)));
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Change)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean bl = false;
            if (!$this$filterIsInstance$iv.isEmpty()) {
                return;
            }
            List newChanges = CollectionsKt.minus((Iterable)activeChanges, (Iterable)this.knownActiveChanges);
            this.getUi().includeIntoCommit(newChanges);
        }
    }

    public final boolean activate() {
        return this.getUi().activate();
    }

    public final void showCommitOptions(boolean isFromToolbar, @NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        this.getUi().showCommitOptions(this.ensureCommitOptions(), isFromToolbar, dataContext);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void inclusionChanged() {
        void $this$filterTo$iv$iv;
        Collection activeChanges;
        Set<Object> inclusion = this.inclusionModel.getInclusion();
        LocalChangeList localChangeList = this.changeListManager.getDefaultChangeList();
        Intrinsics.checkExpressionValueIsNotNull((Object)localChangeList, (String)"changeListManager.defaultChangeList");
        Collection collection = activeChanges = localChangeList.getChanges();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"activeChanges");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Change it = (Change)element$iv$iv;
            boolean bl = false;
            if (!inclusion.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List includedActiveChanges = (List)destination$iv$iv;
        if (!this.knownActiveChanges.containsAll(includedActiveChanges)) {
            this.knownActiveChanges = activeChanges;
        }
        this.getUi().setDefaultCommitActionEnabled(this.isDefaultCommitEnabled());
        super.inclusionChanged();
    }

    @Override
    protected void updateWorkflow() {
        this.getWorkflow().setCommitState$intellij_platform_vcs_impl(this.getCommitState());
    }

    @Override
    protected boolean addUnversionedFiles() {
        return this.addUnversionedFiles(this.getWorkflow().getAffectedChangeList$intellij_platform_vcs_impl((Collection<? extends Change>)this.getIncludedChanges()));
    }

    @Override
    protected boolean saveCommitOptions() {
        this.ensureCommitOptions();
        return super.saveCommitOptions();
    }

    @Override
    protected void saveCommitMessage(boolean success2) {
        VcsConfiguration.getInstance((Project)this.getProject()).saveCommitMessage(this.getCommitMessage());
    }

    @Override
    public void customCommitSucceeded() {
    }

    @Override
    @NotNull
    public ChangesViewCommitWorkflow getWorkflow() {
        return this.workflow;
    }

    @Override
    @NotNull
    public ChangesViewCommitWorkflowUi getUi() {
        return this.ui;
    }

    public ChangesViewCommitWorkflowHandler(@NotNull ChangesViewCommitWorkflow workflow, @NotNull ChangesViewCommitWorkflowUi ui2) {
        Intrinsics.checkParameterIsNotNull((Object)workflow, (String)"workflow");
        Intrinsics.checkParameterIsNotNull((Object)ui2, (String)"ui");
        this.workflow = workflow;
        this.ui = ui2;
        this.commitPanel = new CommitProjectPanelAdapter(this);
        this.amendCommitHandler = new AmendCommitHandlerImpl(this);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        this.changeListManager = changeListManager;
        this.knownActiveChanges = CollectionsKt.emptyList();
        this.inclusionModel = new PartialCommitInclusionModel(this.getProject());
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public final void dispose() {
                this.getWorkflow().disposeCommitOptions$intellij_platform_vcs_impl();
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.inclusionModel);
        Disposer.register((Disposable)((Disposable)this.getUi()), (Disposable)this);
        this.getWorkflow().addListener(this, this);
        this.getUi().addExecutorListener(this, this);
        this.getUi().addDataProvider(this.createDataProvider());
        this.getUi().addInclusionListener(this, this);
        this.getUi().setInclusionModel(this.inclusionModel);
        Disposer.register((Disposable)this.inclusionModel, (Disposable)new Disposable(){

            public final void dispose() {
                this.getUi().setInclusionModel(null);
            }
        });
        this.vcsesChanged();
    }
}

