/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.FileWatchRequestsManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.Alarm;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class NewMappings
implements Disposable {
    private static final Comparator<MappedRoot> ROOT_COMPARATOR = Comparator.comparingInt(it -> -it.rootPath.length());
    private static final Comparator<VcsDirectoryMapping> MAPPINGS_COMPARATOR = Comparator.comparing(VcsDirectoryMapping::getDirectory);
    private static final Logger LOG = Logger.getInstance(NewMappings.class);
    private final Object myUpdateLock = new Object();
    private FileWatchRequestsManager myFileWatchRequestsManager;
    private final DefaultVcsRootPolicy myDefaultVcsRootPolicy;
    private final ProjectLevelVcsManager myVcsManager;
    private final FileStatusManager myFileStatusManager;
    private final Project myProject;
    @NotNull
    private Disposable myFilePointerDisposable = Disposer.newDisposable();
    private volatile List<VcsDirectoryMapping> myMappings = Collections.emptyList();
    private volatile List<MappedRoot> myMappedRoots = Collections.emptyList();
    private volatile List<AbstractVcs> myActiveVcses = Collections.emptyList();
    private volatile boolean myActivated = false;
    @NotNull
    private final MergingUpdateQueue myRootUpdateQueue;
    private final VirtualFilePointerListener myFilePointerListener;

    public NewMappings(Project project, ProjectLevelVcsManagerImpl vcsManager, FileStatusManager fileStatusManager, DefaultVcsRootPolicy defaultVcsRootPolicy) {
        this.myProject = project;
        this.myVcsManager = vcsManager;
        this.myFileStatusManager = fileStatusManager;
        this.myFileWatchRequestsManager = new FileWatchRequestsManager(this.myProject, this);
        this.myDefaultVcsRootPolicy = defaultVcsRootPolicy;
        this.myRootUpdateQueue = new MergingUpdateQueue("NewMappings", 1000, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        vcsManager.addInitializationRequest(VcsInitObject.MAPPINGS, (Runnable)((DumbAwareRunnable)() -> {
            if (!this.myProject.isDisposed()) {
                this.activateActiveVcses();
            }
        }));
        this.myFilePointerListener = new VirtualFilePointerListener(){

            public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
                if (pointers == null) {
                    1.$$$reportNull$$$0(0);
                }
                NewMappings.this.scheduleMappedRootsUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$1", "validityChanged"));
            }
        };
    }

    public void setFileWatchRequestsManager(FileWatchRequestsManager fileWatchRequestsManager) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myFileWatchRequestsManager = fileWatchRequestsManager;
    }

    public AbstractVcs[] getActiveVcses() {
        return this.myActiveVcses.toArray(new AbstractVcs[0]);
    }

    public boolean hasActiveVcss() {
        return !this.myActiveVcses.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateActiveVcses() {
        MyVcsActivator activator;
        Object object = this.myUpdateLock;
        synchronized (object) {
            if (this.myActivated) {
                return;
            }
            this.myActivated = true;
            activator = this.updateActiveVcses();
            LOG.debug("activated");
        }
        activator.activate();
        this.updateMappedRoots(true);
    }

    public void setMapping(@NotNull String path, @Nullable String activeVcsName) {
        if (path == null) {
            NewMappings.$$$reportNull$$$0(0);
        }
        LOG.debug("setMapping path = '" + path + "' vcs = " + activeVcsName);
        VcsDirectoryMapping newMapping = new VcsDirectoryMapping(path, activeVcsName);
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(this.myMappings);
        newMappings.removeIf(mapping -> Comparing.equal((String)mapping.getDirectory(), (String)newMapping.getDirectory()));
        newMappings.add(newMapping);
        this.updateVcsMappings(newMappings);
    }

    public void waitMappedRootsUpdate() {
        this.myRootUpdateQueue.flush();
    }

    public void scheduleMappedRootsUpdate() {
        this.myRootUpdateQueue.queue(new Update("update"){

            public void run() {
                NewMappings.this.updateMappedRoots(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVcsMappings(@NotNull Collection<? extends VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            NewMappings.$$$reportNull$$$0(1);
        }
        this.myRootUpdateQueue.cancelAllUpdates();
        List newMappings = Collections.unmodifiableList(ContainerUtil.sorted(NewMappings.removeDuplicates(mappings), MAPPINGS_COMPARATOR));
        MyVcsActivator activator = null;
        Object object = this.myUpdateLock;
        synchronized (object) {
            boolean mappingsChanged;
            boolean bl = mappingsChanged = !Comparing.equal(this.myMappings, newMappings);
            if (!mappingsChanged) {
                return;
            }
            this.myMappings = newMappings;
            if (this.myActivated) {
                activator = this.updateActiveVcses();
            }
            this.dumpMappingsToLog();
        }
        if (activator != null) {
            activator.activate();
        }
        this.updateMappedRoots(false);
        this.mappingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMappedRoots(boolean fireMappingsChangedEvent) {
        this.myRootUpdateQueue.cancelAllUpdates();
        if (!this.myActivated) {
            return;
        }
        List<VcsDirectoryMapping> mappings = this.myMappings;
        Mappings newMappedRoots = this.collectMappedRoots(mappings);
        Object object = this.myUpdateLock;
        synchronized (object) {
            boolean mappedRootsChanged;
            boolean bl = mappedRootsChanged = !Comparing.equal(this.myMappedRoots, (Object)newMappedRoots);
            if (!mappedRootsChanged || this.myMappings != mappings) {
                Disposer.dispose((Disposable)newMappedRoots.filePointerDisposable);
                return;
            }
            Disposer.dispose((Disposable)this.myFilePointerDisposable);
            this.myMappedRoots = newMappedRoots.mappedRoots;
            this.myFilePointerDisposable = newMappedRoots.filePointerDisposable;
            if (LOG.isDebugEnabled()) {
                this.dumpMappedRootsToLog();
            }
        }
        if (fireMappingsChangedEvent) {
            this.mappingsChanged();
        }
    }

    @NotNull
    private static List<VcsDirectoryMapping> removeDuplicates(@NotNull Collection<? extends VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            NewMappings.$$$reportNull$$$0(2);
        }
        ArrayList<VcsDirectoryMapping> newMapping = new ArrayList<VcsDirectoryMapping>();
        HashSet<String> paths = new HashSet<String>();
        for (VcsDirectoryMapping mapping : ContainerUtil.reverse((List)ContainerUtil.newArrayList(mappings))) {
            if (!paths.add(mapping.getDirectory())) continue;
            newMapping.add(mapping);
        }
        ArrayList<VcsDirectoryMapping> arrayList = newMapping;
        if (arrayList == null) {
            NewMappings.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private Mappings collectMappedRoots(@NotNull List<VcsDirectoryMapping> mappings) {
        Mappings mappings2;
        block6: {
            if (mappings == null) {
                NewMappings.$$$reportNull$$$0(4);
            }
            VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
            HashMap mappedRoots = new HashMap();
            Disposable pointerDisposable = Disposer.newDisposable();
            try {
                AbstractVcs vcs;
                for (VcsDirectoryMapping mapping : mappings) {
                    if (mapping.isDefaultMapping()) continue;
                    vcs = this.getMappingsVcs(mapping);
                    String rootPath = mapping.getDirectory();
                    ReadAction.run(() -> {
                        VirtualFile vcsRoot = LocalFileSystem.getInstance().findFileByPath(rootPath);
                        if (vcsRoot != null && vcsRoot.isDirectory()) {
                            if (this.checkMappedRoot(vcs, vcsRoot)) {
                                mappedRoots.putIfAbsent(vcsRoot, new MappedRoot(vcs, mapping, vcsRoot));
                            } else {
                                mappedRoots.putIfAbsent(vcsRoot, new MappedRoot(null, mapping, vcsRoot));
                            }
                        }
                        pointerManager.create(VfsUtilCore.pathToUrl((String)rootPath), pointerDisposable, this.myFilePointerListener);
                    });
                }
                for (VcsDirectoryMapping mapping : mappings) {
                    if (!mapping.isDefaultMapping() || (vcs = this.getMappingsVcs(mapping)) == null) continue;
                    Collection<VirtualFile> defaultRoots = this.detectDefaultRootsFor(vcs, this.myDefaultVcsRootPolicy.getDefaultVcsRoots(), ContainerUtil.map2Set(mappedRoots.values(), it -> it.root));
                    ReadAction.run(() -> {
                        for (VirtualFile vcsRoot : defaultRoots) {
                            if (vcsRoot == null || !vcsRoot.isDirectory()) continue;
                            mappedRoots.putIfAbsent(vcsRoot, new MappedRoot(vcs, mapping, vcsRoot));
                            pointerManager.create(vcsRoot, pointerDisposable, this.myFilePointerListener);
                        }
                    });
                }
                mappings2 = new Mappings(Collections.unmodifiableList(ContainerUtil.sorted(mappedRoots.values(), ROOT_COMPARATOR)), pointerDisposable);
                if (mappings2 != null) break block6;
            }
            catch (Throwable e) {
                Disposer.dispose((Disposable)pointerDisposable);
                ExceptionUtil.rethrow((Throwable)e);
                if (null == null) {
                    NewMappings.$$$reportNull$$$0(6);
                }
                return null;
            }
            NewMappings.$$$reportNull$$$0(5);
        }
        return mappings2;
    }

    @Nullable
    private AbstractVcs getMappingsVcs(@NotNull VcsDirectoryMapping mapping) {
        String vcsName;
        if (mapping == null) {
            NewMappings.$$$reportNull$$$0(7);
        }
        return (vcsName = mapping.getVcs()) != null ? AllVcses.getInstance(this.myProject).getByName(vcsName) : null;
    }

    private boolean checkMappedRoot(@Nullable AbstractVcs vcs, @NotNull VirtualFile vcsRoot) {
        if (vcsRoot == null) {
            NewMappings.$$$reportNull$$$0(8);
        }
        try {
            if (vcs == null) {
                return false;
            }
            VcsRootChecker rootChecker = this.myVcsManager.getRootChecker(vcs);
            return rootChecker.validateRoot(vcsRoot.getPath());
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return false;
        }
    }

    @NotNull
    private Collection<VirtualFile> detectDefaultRootsFor(@NotNull AbstractVcs<?> vcs, @NotNull Collection<VirtualFile> projectRoots, @NotNull Set<VirtualFile> mappedDirs) {
        HashSet<VirtualFile> hashSet;
        block16: {
            if (vcs == null) {
                NewMappings.$$$reportNull$$$0(9);
            }
            if (projectRoots == null) {
                NewMappings.$$$reportNull$$$0(10);
            }
            if (mappedDirs == null) {
                NewMappings.$$$reportNull$$$0(11);
            }
            if (!vcs.needsLegacyDefaultMappings()) break block16;
            Collection<VirtualFile> collection = projectRoots;
            if (collection == null) {
                NewMappings.$$$reportNull$$$0(12);
            }
            return collection;
        }
        try {
            DirectoryIndex directoryIndex = DirectoryIndex.getInstance((Project)this.myProject);
            VcsRootChecker rootChecker = this.myVcsManager.getRootChecker(vcs);
            HashMap<VirtualFile, Boolean> checkedDirs = new HashMap<VirtualFile, Boolean>();
            HashSet<VirtualFile> vcsRoots = new HashSet<VirtualFile>();
            block4: for (VirtualFile f : projectRoots) {
                while (f != null && !vcsRoots.contains(f) && !mappedDirs.contains(f)) {
                    if (NewMappings.isVcsRoot(rootChecker, checkedDirs, f)) {
                        vcsRoots.add(f);
                        continue block4;
                    }
                    VirtualFile parent = f.getParent();
                    if (parent != null && !NewMappings.isUnderProject(directoryIndex, parent)) {
                        if (!rootChecker.areChildrenValidMappings()) continue block4;
                        while (parent != null && !vcsRoots.contains(parent) && !mappedDirs.contains(parent)) {
                            if (NewMappings.isVcsRoot(rootChecker, checkedDirs, parent)) {
                                vcsRoots.add(f);
                                continue block4;
                            }
                            parent = parent.getParent();
                        }
                        continue block4;
                    }
                    f = parent;
                }
            }
            hashSet = vcsRoots;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                NewMappings.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (hashSet == null) {
            NewMappings.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    private static boolean isVcsRoot(@NotNull VcsRootChecker rootChecker, @NotNull Map<VirtualFile, Boolean> checkedDirs, @NotNull VirtualFile file) {
        if (rootChecker == null) {
            NewMappings.$$$reportNull$$$0(15);
        }
        if (checkedDirs == null) {
            NewMappings.$$$reportNull$$$0(16);
        }
        if (file == null) {
            NewMappings.$$$reportNull$$$0(17);
        }
        ProgressManager.checkCanceled();
        return checkedDirs.computeIfAbsent(file, key -> rootChecker.isRoot(key.getPath()));
    }

    private static boolean isUnderProject(@NotNull DirectoryIndex directoryIndex, @NotNull VirtualFile f) {
        if (directoryIndex == null) {
            NewMappings.$$$reportNull$$$0(18);
        }
        if (f == null) {
            NewMappings.$$$reportNull$$$0(19);
        }
        return (Boolean)ReadAction.compute(() -> directoryIndex.getInfoForFile(f).isInProject(f));
    }

    public void mappingsChanged() {
        ((VcsListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED)).directoryMappingChanged();
        this.myFileStatusManager.fileStatusesChanged();
        this.myFileWatchRequestsManager.ping();
    }

    private void dumpMappingsToLog() {
        for (VcsDirectoryMapping mapping : this.myMappings) {
            String path = mapping.isDefaultMapping() ? "<Project>" : mapping.getDirectory();
            String vcs = mapping.getVcs();
            LOG.info(String.format("VCS Root: [%s] - [%s]", vcs, path));
        }
    }

    private void dumpMappedRootsToLog() {
        for (MappedRoot root : this.myMappedRoots) {
            LOG.info(String.format("Mapped Root: [%s] - [%s]", root.vcs, root.rootPath));
        }
    }

    public void setDirectoryMappings(@NotNull List<? extends VcsDirectoryMapping> items) {
        if (items == null) {
            NewMappings.$$$reportNull$$$0(20);
        }
        LOG.debug("setDirectoryMappings, size: " + items.size());
        this.updateVcsMappings(items);
    }

    @Nullable
    public MappedRoot getMappedRootFor(@Nullable VirtualFile file) {
        if (file == null || !file.isInLocalFileSystem()) {
            return null;
        }
        if (this.myVcsManager.isIgnored(file)) {
            return null;
        }
        ArrayList<MappedRoot> mappings = new ArrayList<MappedRoot>(this.myMappedRoots);
        for (MappedRoot mapping : mappings) {
            if (!mapping.root.isValid() || !VfsUtilCore.isAncestor((VirtualFile)mapping.root, (VirtualFile)file, (boolean)false)) continue;
            return mapping;
        }
        return null;
    }

    @Nullable
    public MappedRoot getMappedRootFor(@Nullable FilePath file) {
        if (file == null) {
            return null;
        }
        if (file.isNonLocal()) {
            return null;
        }
        if (this.myVcsManager.isIgnored(file)) {
            return null;
        }
        ArrayList<MappedRoot> mappings = new ArrayList<MappedRoot>(this.myMappedRoots);
        @SystemIndependent String filePath = file.getPath();
        for (MappedRoot mapping : mappings) {
            if (!mapping.root.isValid() || !FileUtil.isAncestor((String)mapping.rootPath, (String)filePath, (boolean)false)) continue;
            return mapping;
        }
        return null;
    }

    @NotNull
    public List<VirtualFile> getMappingsAsFilesUnderVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            NewMappings.$$$reportNull$$$0(21);
        }
        List list = ContainerUtil.mapNotNull(this.myMappedRoots, root -> vcs.equals((Object)root.vcs) ? root.root : null);
        if (list == null) {
            NewMappings.$$$reportNull$$$0(22);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        MyVcsActivator activator;
        LOG.debug("disposed");
        Object object = this.myUpdateLock;
        synchronized (object) {
            Disposer.dispose((Disposable)this.myFilePointerDisposable);
            this.myMappings = Collections.emptyList();
            this.myMappedRoots = Collections.emptyList();
            this.myFilePointerDisposable = Disposer.newDisposable();
            activator = this.updateActiveVcses();
        }
        activator.activate();
        this.myFileWatchRequestsManager.ping();
    }

    public List<VcsDirectoryMapping> getDirectoryMappings() {
        return this.myMappings;
    }

    public List<VcsDirectoryMapping> getDirectoryMappings(String vcsName) {
        return ContainerUtil.filter(this.myMappings, mapping -> Comparing.equal((String)mapping.getVcs(), (String)vcsName));
    }

    @Nullable
    public String haveDefaultMapping() {
        VcsDirectoryMapping defaultMapping = (VcsDirectoryMapping)ContainerUtil.find(this.myMappings, mapping -> mapping.isDefaultMapping());
        return defaultMapping != null ? defaultMapping.getVcs() : null;
    }

    public boolean isEmpty() {
        return ContainerUtil.all(this.myMappings, mapping -> StringUtil.isEmpty((String)mapping.getVcs()));
    }

    public void removeDirectoryMapping(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            NewMappings.$$$reportNull$$$0(23);
        }
        LOG.debug("remove mapping: " + mapping.getDirectory());
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(this.myMappings);
        newMappings.remove(mapping);
        this.updateVcsMappings(newMappings);
    }

    public void cleanupMappings() {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        ArrayList<VcsDirectoryMapping> oldMappings = new ArrayList<VcsDirectoryMapping>(this.getDirectoryMappings());
        ArrayList<VcsDirectoryMapping> filteredMappings = new ArrayList<VcsDirectoryMapping>();
        VcsDirectoryMapping defaultMapping = (VcsDirectoryMapping)ContainerUtil.find(oldMappings, it -> it.isDefaultMapping());
        if (defaultMapping != null) {
            oldMappings.remove(defaultMapping);
            filteredMappings.add(defaultMapping);
        }
        MultiMap groupedMappings = ContainerUtil.groupBy(oldMappings, mapping -> mapping.getVcs());
        for (Map.Entry entry : groupedMappings.entrySet()) {
            String vcsName = (String)entry.getKey();
            Collection mappings = (Collection)entry.getValue();
            List objects = ContainerUtil.mapNotNull((Collection)mappings, dm -> {
                VirtualFile vf = lfs.refreshAndFindFileByPath(dm.getDirectory());
                return vf == null ? null : Pair.create((Object)vf, (Object)dm);
            });
            if (StringUtil.isEmptyOrSpaces((String)vcsName)) {
                filteredMappings.addAll(ContainerUtil.map((Collection)objects, (Function)Functions.pairSecond()));
                continue;
            }
            AbstractVcs vcs = this.myVcsManager.findVcsByName(vcsName);
            if (vcs == null) {
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, "VCS plugin not found for mapping to : '" + vcsName + "'", MessageType.ERROR, new NamedRunnable[0]);
                filteredMappings.addAll(mappings);
                continue;
            }
            filteredMappings.addAll(ContainerUtil.map((Collection)vcs.filterUniqueRoots(objects, pair -> (VirtualFile)pair.getFirst()), (Function)Functions.pairSecond()));
        }
        this.updateVcsMappings(filteredMappings);
    }

    @NotNull
    private MyVcsActivator updateActiveVcses() {
        Set newVcses = ContainerUtil.map2SetNotNull(this.myMappings, mapping -> this.getMappingsVcs((VcsDirectoryMapping)mapping));
        List<AbstractVcs> oldVcses = this.myActiveVcses;
        this.myActiveVcses = Collections.unmodifiableList(new ArrayList(newVcses));
        Collection toAdd = ContainerUtil.subtract(this.myActiveVcses, oldVcses);
        Collection toRemove = ContainerUtil.subtract(oldVcses, this.myActiveVcses);
        MyVcsActivator myVcsActivator = new MyVcsActivator(toAdd, toRemove);
        if (myVcsActivator == null) {
            NewMappings.$$$reportNull$$$0(24);
        }
        return myVcsActivator;
    }

    public boolean haveActiveVcs(String name) {
        return ContainerUtil.exists(this.myActiveVcses, vcs -> Comparing.equal((String)vcs.getName(), (String)name));
    }

    public void beingUnregistered(String name) {
        ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(this.myMappings);
        newMappings.removeIf(mapping -> Comparing.equal((String)mapping.getVcs(), (String)name));
        this.updateVcsMappings(newMappings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings";
                break;
            }
            case 7: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRoots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedDirs";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootChecker";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedDirs";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryIndex";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicates";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMappedRoots";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "detectDefaultRootsFor";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsAsFilesUnderVcs";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "updateActiveVcses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setMapping";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateVcsMappings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 24: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectMappedRoots";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsVcs";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkMappedRoot";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "detectDefaultRootsFor";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isVcsRoot";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isUnderProject";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryMappings";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsAsFilesUnderVcs";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeDirectoryMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Mappings {
        @NotNull
        public final List<MappedRoot> mappedRoots;
        @NotNull
        public final Disposable filePointerDisposable;

        private Mappings(@NotNull List<MappedRoot> mappedRoots, @NotNull Disposable filePointerDisposable) {
            if (mappedRoots == null) {
                Mappings.$$$reportNull$$$0(0);
            }
            if (filePointerDisposable == null) {
                Mappings.$$$reportNull$$$0(1);
            }
            this.mappedRoots = mappedRoots;
            this.filePointerDisposable = filePointerDisposable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mappedRoots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePointerDisposable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$Mappings";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MappedRoot {
        @Nullable
        public final AbstractVcs vcs;
        @NotNull
        public final VcsDirectoryMapping mapping;
        @NotNull
        public final VirtualFile root;
        @NotNull
        public final String rootPath;

        private MappedRoot(@Nullable AbstractVcs vcs, @NotNull VcsDirectoryMapping mapping, @NotNull VirtualFile root) {
            if (mapping == null) {
                MappedRoot.$$$reportNull$$$0(0);
            }
            if (root == null) {
                MappedRoot.$$$reportNull$$$0(1);
            }
            this.vcs = vcs;
            this.mapping = mapping;
            this.root = root;
            this.rootPath = root.getPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mapping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$MappedRoot";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyVcsActivator {
        @NotNull
        private final Collection<? extends AbstractVcs> myAddVcses;
        @NotNull
        private final Collection<? extends AbstractVcs> myRemoveVcses;

        private MyVcsActivator(@NotNull Collection<? extends AbstractVcs> addVcses, @NotNull Collection<? extends AbstractVcs> removeVcses) {
            if (addVcses == null) {
                MyVcsActivator.$$$reportNull$$$0(0);
            }
            if (removeVcses == null) {
                MyVcsActivator.$$$reportNull$$$0(1);
            }
            this.myAddVcses = addVcses;
            this.myRemoveVcses = removeVcses;
        }

        public void activate() {
            for (AbstractVcs abstractVcs : this.myAddVcses) {
                try {
                    abstractVcs.doActivate();
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                }
            }
            for (AbstractVcs abstractVcs : this.myRemoveVcses) {
                try {
                    abstractVcs.doDeactivate();
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "addVcses";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "removeVcses";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/impl/projectlevelman/NewMappings$MyVcsActivator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

