/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;

public interface Value
extends Serializable {
    public Object getValue();

    public Type getType();

    public static class Node
    implements Serializable,
    Debugger.Locatable {
        public final String myURI;
        public final int myLineNumber;
        public final String myXPath;
        public final String myStringValue;

        public Node(String URI2, int lineNumber, String XPath, String stringValue) {
            this.myURI = URI2;
            this.myLineNumber = lineNumber;
            this.myXPath = XPath;
            this.myStringValue = stringValue;
        }

        public String getURI() {
            return this.myURI;
        }

        public int getLineNumber() {
            return this.myLineNumber;
        }

        public String toString() {
            return "Node{myURI='" + this.myURI + '\'' + ", myLineNumber=" + this.myLineNumber + ", myXPath='" + this.myXPath + '\'' + ", myStringValue='" + this.myStringValue + '\'' + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeSet
    implements Serializable {
        public final String myStringValue;
        private final List<Node> myNodes;

        public NodeSet(String stringValue, List<Node> nodes) {
            this.myStringValue = stringValue;
            this.myNodes = nodes;
        }

        public List<Node> getNodes() {
            return this.myNodes;
        }

        public String toString() {
            return this.myStringValue;
        }
    }

    public static final class ObjectType
    implements Type {
        private final String myName;

        public ObjectType(String name) {
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XPathType implements Type
    {
        BOOLEAN,
        NUMBER,
        STRING,
        NODESET,
        OBJECT,
        UNKNOWN;


        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static interface Type
    extends Serializable {
        public String getName();
    }
}

