/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.SideModel;
import com.android.tools.adtui.workbench.Split;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class MinimizedPanel<T>
extends JPanel
implements SideModel.Listener<T> {
    private final SideModel<T> myModel;
    private final Side mySide;
    private final Component myFiller;
    private boolean myHasVisibleButtons;

    MinimizedPanel(@NotNull Side side, @NotNull SideModel<T> model2) {
        if (side == null) {
            MinimizedPanel.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            MinimizedPanel.$$$reportNull$$$0(1);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(IdeBorderFactory.createBorder((int)(side.isLeft() ? 4 : 1)));
        this.setPreferredSize(new Dimension(JBUIScale.scale((int)20), 0));
        this.setBackground((Color)JBColor.white);
        this.setOpaque(false);
        this.myModel = model2;
        this.mySide = side;
        this.myFiller = Box.createVerticalGlue();
        model2.addListener(this);
    }

    @Override
    public void modelChanged(@NotNull SideModel<T> model2, @NotNull SideModel.EventType unused) {
        if (model2 == null) {
            MinimizedPanel.$$$reportNull$$$0(2);
        }
        if (unused == null) {
            MinimizedPanel.$$$reportNull$$$0(3);
        }
        this.removeAll();
        this.myHasVisibleButtons = false;
        model2.getTopTools(this.mySide).forEach(this::addButton);
        this.add(this.myFiller);
        model2.getBottomTools(this.mySide).forEach(this::addButton);
        this.setVisible(this.myHasVisibleButtons);
        this.revalidate();
        this.repaint();
    }

    private void addButton(@NotNull AttachedToolWindow tool) {
        if (tool == null) {
            MinimizedPanel.$$$reportNull$$$0(4);
        }
        AbstractButton button = tool.getMinimizedButton();
        button.setVisible(true);
        this.myHasVisibleButtons |= tool.isMinimized() || tool.isAutoHide();
        this.add(button);
    }

    public int drag(@NotNull AttachedToolWindow<T> tool, int position) {
        if (tool == null) {
            MinimizedPanel.$$$reportNull$$$0(5);
        }
        AbstractButton button = tool.getMinimizedButton();
        if (!this.isOpaque()) {
            this.enableMinimizeButtonDragAndDrop(true);
            button.setVisible(true);
        }
        int insertIndex = this.findInsertIndex(position, button);
        int index = this.getComponentIndex(button);
        if (index == insertIndex) {
            return insertIndex;
        }
        if (index >= 0) {
            this.remove(index);
        }
        this.add((Component)button, insertIndex);
        this.revalidate();
        this.repaint();
        return insertIndex;
    }

    public void dragExit(@NotNull AttachedToolWindow<T> tool) {
        if (tool == null) {
            MinimizedPanel.$$$reportNull$$$0(6);
        }
        tool.getMinimizedButton().setVisible(false);
        this.enableMinimizeButtonDragAndDrop(false);
        this.revalidate();
        this.repaint();
    }

    public void dragDrop(@NotNull AttachedToolWindow<T> tool, int position) {
        if (tool == null) {
            MinimizedPanel.$$$reportNull$$$0(7);
        }
        int index = this.drag(tool, position);
        tool.getMinimizedButton().setVisible(false);
        int fillerIndex = this.getComponentIndex(this.myFiller);
        Split newSplit = index > fillerIndex ? Split.BOTTOM : Split.TOP;
        int toolIndex = newSplit.isBottom() ? index - fillerIndex - 1 : index;
        this.myModel.changeToolSettingsAfterDragAndDrop(tool, this.mySide, newSplit, toolIndex);
        this.enableMinimizeButtonDragAndDrop(false);
    }

    private void enableMinimizeButtonDragAndDrop(boolean enable) {
        this.setOpaque(enable);
        this.setVisible(enable || this.myHasVisibleButtons);
        this.revalidate();
        this.repaint();
    }

    private int findInsertIndex(int position, @NotNull Component draggedButton) {
        if (draggedButton == null) {
            MinimizedPanel.$$$reportNull$$$0(8);
        }
        int index = 0;
        int y = 0;
        int extraFillerHeight = draggedButton.getParent() == this ? draggedButton.getHeight() : 0;
        for (Component component : this.getComponents()) {
            if (component == draggedButton) continue;
            if (component instanceof Box.Filler) {
                if (position < y + (component.getHeight() + extraFillerHeight) / 2) {
                    return index;
                }
                ++index;
                y += extraFillerHeight;
            }
            if (position < (y += component.getHeight())) {
                return index;
            }
            ++index;
        }
        return index - 1;
    }

    private int getComponentIndex(@NotNull Component component) {
        if (component == null) {
            MinimizedPanel.$$$reportNull$$$0(9);
        }
        for (int index = 0; index < this.getComponentCount(); ++index) {
            if (this.getComponent(index) != component) continue;
            return index;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unused";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "draggedButton";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/workbench/MinimizedPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "modelChanged";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addButton";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "drag";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "dragExit";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "dragDrop";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findInsertIndex";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getComponentIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

