/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.util;

import com.google.common.math.IntMath;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;

public class SwingUtil {
    private static final String DOWN = "selectNext";
    private static final String UP = "selectPrevious";

    public static void doNotSelectSeparators(@NotNull JComboBox combo) {
        if (combo == null) {
            SwingUtil.$$$reportNull$$$0(0);
        }
        SwingUtil.doNotSelectItems(combo, e -> e instanceof JSeparator);
    }

    public static void doNotSelectItems(@NotNull JComboBox combo, @NotNull Function<Object, Boolean> skipItem) {
        if (combo == null) {
            SwingUtil.$$$reportNull$$$0(1);
        }
        if (skipItem == null) {
            SwingUtil.$$$reportNull$$$0(2);
        }
        ActionMap actions = combo.getActionMap();
        actions.put(DOWN, new Actions(DOWN, combo, skipItem));
        actions.put(UP, new Actions(UP, combo, skipItem));
    }

    @NotNull
    public static MouseEvent convertMouseEventID(@NotNull MouseEvent event, int id) {
        if (event == null) {
            SwingUtil.$$$reportNull$$$0(3);
        }
        MouseEvent mouseEvent = new MouseEvent((Component)event.getSource(), id, event.getWhen(), event.getModifiers(), event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger(), event.getButton());
        if (mouseEvent == null) {
            SwingUtil.$$$reportNull$$$0(4);
        }
        return mouseEvent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipItem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/util/SwingUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/util/SwingUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMouseEventID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doNotSelectSeparators";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doNotSelectItems";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertMouseEventID";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Actions
    extends AbstractAction {
        private JComboBox comboBox;
        private Function<Object, Boolean> mySkipItem;

        public Actions(String name, JComboBox comboBox, Function<Object, Boolean> skipItem) {
            super(name);
            this.comboBox = comboBox;
            this.mySkipItem = skipItem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String key = (String)this.getValue("Name");
            if (key == SwingUtil.DOWN) {
                if (this.comboBox.isShowing()) {
                    if (this.comboBox.isPopupVisible()) {
                        if (this.comboBox.getUI() != null) {
                            this.selectNextPossibleValue();
                        }
                    } else {
                        this.comboBox.showPopup();
                    }
                }
            } else if (key == SwingUtil.UP && this.comboBox.getUI() != null) {
                if (this.comboBox.isPopupVisible()) {
                    this.selectPreviousPossibleValue();
                } else if (UIManager.getBoolean("ComboBox.showPopupOnNavigation")) {
                    this.comboBox.showPopup();
                }
            }
        }

        private JList getPopupList() {
            ComboPopup popup = UIUtil.getComboBoxPopup((JComboBox)this.comboBox);
            assert (popup != null);
            return popup.getList();
        }

        private boolean isTableCellEditor() {
            return Boolean.TRUE.equals(this.comboBox.getClientProperty("JComboBox.isTableCellEditor"));
        }

        private int newIndex(int current, boolean next) {
            int startIndex = current;
            while (startIndex != (current = IntMath.mod((int)(next ? current + 1 : current - 1), (int)this.comboBox.getItemCount())) && this.mySkipItem.apply(this.comboBox.getItemAt(current)).booleanValue()) {
            }
            return current;
        }

        protected void selectNextPossibleValue() {
            boolean isTableCellEditor = this.isTableCellEditor();
            JList listBox = this.getPopupList();
            int si = this.comboBox.isPopupVisible() ? listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
            if ((si = this.newIndex(si, true)) <= this.comboBox.getModel().getSize() - 1) {
                listBox.setSelectedIndex(si);
                listBox.ensureIndexIsVisible(si);
                if (!(isTableCellEditor || UIManager.getBoolean("ComboBox.noActionOnKeyNavigation") && this.comboBox.isPopupVisible())) {
                    this.comboBox.setSelectedIndex(si);
                }
                this.comboBox.repaint();
            }
        }

        protected void selectPreviousPossibleValue() {
            boolean isTableCellEditor = this.isTableCellEditor();
            JList listBox = this.getPopupList();
            int si = this.comboBox.isPopupVisible() ? listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
            if ((si = this.newIndex(si, false)) >= 0) {
                listBox.setSelectedIndex(si);
                listBox.ensureIndexIsVisible(si);
                if (!(isTableCellEditor || UIManager.getBoolean("ComboBox.noActionOnKeyNavigation") && this.comboBox.isPopupVisible())) {
                    this.comboBox.setSelectedIndex(si);
                }
                this.comboBox.repaint();
            }
        }
    }
}

