/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui.menu;

import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.adtui.stdui.StandardDimensions;
import com.android.tools.adtui.stdui.menu.CommonMenu;
import com.android.tools.adtui.stdui.menu.CommonMenuLayoutHelper;
import com.android.tools.adtui.stdui.menu.CommonMenuPaintHelper;
import com.intellij.ui.scale.JBUIScale;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.MenuItemLayoutHelper;

public class CommonMenuUI
extends BasicMenuUI {
    @NotNull
    private static final IconUIResource ARROW_ICON = new IconUIResource(new ImageIcon(new BufferedImage(JBUIScale.scale((int)16), JBUIScale.scale((int)16), 2)));

    @Override
    public void installUI(@NotNull JComponent component) {
        Color bgColor;
        if (component == null) {
            CommonMenuUI.$$$reportNull$$$0(0);
        }
        super.installUI(component);
        Border border = component.getBorder();
        if (border == null || border instanceof UIResource) {
            component.setBorder(new BorderUIResource(BorderFactory.createEmptyBorder(0, (int)StandardDimensions.INSTANCE.getMENU_LEFT_PADDING(), 0, (int)StandardDimensions.INSTANCE.getMENU_RIGHT_PADDING())));
        }
        if ((bgColor = component.getBackground()) == null || bgColor instanceof UIResource) {
            component.setBackground(new ColorUIResource(StandardColors.MENU_BACKGROUND_COLOR));
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.defaultTextIconGap = (int)StandardDimensions.INSTANCE.getMENU_ICON_TEXT_GAP();
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = new ColorUIResource(StandardColors.SELECTED_BACKGROUND_COLOR);
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = new ColorUIResource(StandardColors.SELECTED_TEXT_COLOR);
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = new ColorUIResource(StandardColors.DISABLED_TEXT_COLOR);
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = new IconUIResource(StudioIcons.Common.CHECKED);
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = ARROW_ICON;
        }
    }

    @Override
    protected Dimension getPreferredMenuItemSize(@NotNull JComponent component, @Nullable Icon checkIcon, @Nullable Icon arrowIcon, int defaultTextIconGap) {
        if (component == null) {
            CommonMenuUI.$$$reportNull$$$0(1);
        }
        CommonMenu menu = (CommonMenu)component;
        assert (menu != null);
        CommonMenuLayoutHelper layoutHelper = new CommonMenuLayoutHelper(menu, checkIcon, arrowIcon, MenuItemLayoutHelper.createMaxRect(), defaultTextIconGap, 0, (int)StandardDimensions.INSTANCE.getMENU_CHECK_ICON_GAP(), this.acceleratorDelimiter, component.getComponentOrientation().isLeftToRight(), menu.getFont(), this.acceleratorFont, MenuItemLayoutHelper.useCheckAndArrow(this.menuItem), this.getPropertyPrefix());
        Dimension result = new Dimension();
        MenuItemLayoutHelper.addMaxWidth(layoutHelper.getCheckSize(), layoutHelper.getAfterCheckIconGap(), result);
        if (!layoutHelper.isTopLevelMenu() && layoutHelper.getMinTextOffset() > 0 && result.width < layoutHelper.getMinTextOffset()) {
            result.width = layoutHelper.getMinTextOffset();
        }
        MenuItemLayoutHelper.addMaxWidth(layoutHelper.getLabelSize(), layoutHelper.getGap(), result);
        MenuItemLayoutHelper.addMaxWidth(layoutHelper.getAccSize(), layoutHelper.getGap(), result);
        MenuItemLayoutHelper.addMaxWidth(layoutHelper.getArrowSize(), 0, result);
        result.height = MenuItemLayoutHelper.max(layoutHelper.getCheckSize().getHeight(), layoutHelper.getLabelSize().getHeight(), layoutHelper.getAccSize().getHeight(), layoutHelper.getArrowSize().getHeight(), (int)StandardDimensions.INSTANCE.getMENU_HEIGHT());
        Insets insets = layoutHelper.getMenuItem().getInsets();
        if (insets != null) {
            result.width += insets.left + insets.right;
            result.height += insets.top + insets.bottom;
        }
        if (result.width % 2 == 0) {
            ++result.width;
        }
        if (result.height % 2 == 0 && Boolean.TRUE != UIManager.get(this.getPropertyPrefix() + ".evenHeight")) {
            ++result.height;
        }
        return result;
    }

    @Override
    protected void paintMenuItem(@NotNull Graphics graphics, @NotNull JComponent component, @Nullable Icon checkIcon, @Nullable Icon arrowIcon, @Nullable Color background, @Nullable Color foreground, int defaultTextIconGap) {
        if (graphics == null) {
            CommonMenuUI.$$$reportNull$$$0(2);
        }
        if (component == null) {
            CommonMenuUI.$$$reportNull$$$0(3);
        }
        Font holdf = graphics.getFont();
        Color holdc = graphics.getColor();
        CommonMenu menu = (CommonMenu)component;
        graphics.setFont(menu.getFont());
        Rectangle viewRect = new Rectangle(0, 0, menu.getWidth(), menu.getHeight());
        CommonMenuLayoutHelper.applyInsets(viewRect, menu.getInsets());
        CommonMenuLayoutHelper layoutHelper = new CommonMenuLayoutHelper(menu, checkIcon, arrowIcon, viewRect, defaultTextIconGap, 0, (int)StandardDimensions.INSTANCE.getMENU_CHECK_ICON_GAP(), this.acceleratorDelimiter, menu.getComponentOrientation().isLeftToRight(), menu.getFont(), this.acceleratorFont, MenuItemLayoutHelper.useCheckAndArrow(this.menuItem), this.getPropertyPrefix());
        MenuItemLayoutHelper.LayoutResult layoutResult = layoutHelper.layoutMenuItem();
        this.paintBackground(graphics, menu, background);
        if (menu.isActionSelected()) {
            CommonMenuPaintHelper.paintCheckIcon(graphics, layoutHelper, layoutResult, holdc, foreground);
        }
        CommonMenuPaintHelper.paintIcon(graphics, layoutHelper, layoutResult, holdc);
        if (!layoutHelper.getText().equals("")) {
            this.paintText(graphics, layoutHelper.getMenuItem(), layoutResult.getTextRect(), layoutHelper.getText());
        }
        CommonMenuPaintHelper.paintAccText(graphics, layoutHelper, layoutResult, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
        if (arrowIcon == ARROW_ICON) {
            CommonMenuPaintHelper.paintArrowIconCustom(graphics, layoutHelper, layoutResult);
        } else {
            CommonMenuPaintHelper.paintArrowIcon(graphics, layoutHelper, layoutResult, foreground);
        }
        graphics.setColor(holdc);
        graphics.setFont(holdf);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/stdui/menu/CommonMenuUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "installUI";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreferredMenuItemSize";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "paintMenuItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

