/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui.menu;

import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.adtui.stdui.StandardDimensions;
import com.android.tools.adtui.stdui.menu.CommonMenuItem;
import com.android.tools.adtui.stdui.menu.CommonMenuLayoutHelper;
import com.android.tools.adtui.stdui.menu.CommonMenuPaintHelper;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuItemUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.MenuItemLayoutHelper;

public class CommonMenuItemUI
extends BasicMenuItemUI {
    @Override
    public void installUI(JComponent component) {
        Color bgColor;
        super.installUI(component);
        Border border = component.getBorder();
        if (border == null || border instanceof UIResource) {
            component.setBorder(new BorderUIResource(BorderFactory.createEmptyBorder(0, (int)StandardDimensions.INSTANCE.getMENU_LEFT_PADDING(), 0, (int)StandardDimensions.INSTANCE.getMENU_RIGHT_PADDING())));
        }
        if ((bgColor = component.getBackground()) == null || bgColor instanceof UIResource) {
            component.setBackground(new ColorUIResource(StandardColors.MENU_BACKGROUND_COLOR));
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.defaultTextIconGap = (int)StandardDimensions.INSTANCE.getMENU_ICON_TEXT_GAP();
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = new ColorUIResource(StandardColors.SELECTED_BACKGROUND_COLOR);
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = new ColorUIResource(StandardColors.SELECTED_TEXT_COLOR);
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = new ColorUIResource(StandardColors.DISABLED_TEXT_COLOR);
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = new IconUIResource(StudioIcons.Common.CHECKED);
        }
        this.arrowIcon = null;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(@NotNull JComponent component, @Nullable Icon checkIcon, @Nullable Icon arrowIcon, int defaultTextIconGap) {
        if (component == null) {
            CommonMenuItemUI.$$$reportNull$$$0(0);
        }
        CommonMenuItem menuItem = (CommonMenuItem)component;
        assert (menuItem != null);
        CommonMenuLayoutHelper layoutHelper = new CommonMenuLayoutHelper(menuItem, checkIcon, arrowIcon, MenuItemLayoutHelper.createMaxRect(), defaultTextIconGap, 0, (int)StandardDimensions.INSTANCE.getMENU_CHECK_ICON_GAP(), this.acceleratorDelimiter, component.getComponentOrientation().isLeftToRight(), menuItem.getFont(), this.acceleratorFont, MenuItemLayoutHelper.useCheckAndArrow(this.menuItem), this.getPropertyPrefix());
        Dimension result = new Dimension();
        MenuItemLayoutHelper.addMaxWidth(layoutHelper.getCheckSize(), layoutHelper.getAfterCheckIconGap(), result);
        if (!layoutHelper.isTopLevelMenu() && layoutHelper.getMinTextOffset() > 0 && result.width < layoutHelper.getMinTextOffset()) {
            result.width = layoutHelper.getMinTextOffset();
        }
        MenuItemLayoutHelper.addMaxWidth(layoutHelper.getLabelSize(), layoutHelper.getGap(), result);
        MenuItemLayoutHelper.addMaxWidth(layoutHelper.getAccSize(), layoutHelper.getGap(), result);
        result.height = MenuItemLayoutHelper.max(layoutHelper.getCheckSize().getHeight(), layoutHelper.getLabelSize().getHeight(), layoutHelper.getAccSize().getHeight(), layoutHelper.getArrowSize().getHeight(), (int)StandardDimensions.INSTANCE.getMENU_HEIGHT());
        Insets insets = layoutHelper.getMenuItem().getInsets();
        if (insets != null) {
            result.width += insets.left + insets.right;
            result.height += insets.top + insets.bottom;
        }
        if (result.width % 2 == 0) {
            ++result.width;
        }
        if (result.height % 2 == 0 && Boolean.TRUE != UIManager.get(this.getPropertyPrefix() + ".evenHeight")) {
            ++result.height;
        }
        return result;
    }

    @Override
    protected void paintMenuItem(@NotNull Graphics graphics, @NotNull JComponent component, @Nullable Icon checkIcon, @Nullable Icon arrowIcon, @Nullable Color background, @Nullable Color foreground, int defaultTextIconGap) {
        if (graphics == null) {
            CommonMenuItemUI.$$$reportNull$$$0(1);
        }
        if (component == null) {
            CommonMenuItemUI.$$$reportNull$$$0(2);
        }
        Font holdf = graphics.getFont();
        Color holdc = graphics.getColor();
        CommonMenuItem menuItem = (CommonMenuItem)component;
        graphics.setFont(menuItem.getFont());
        Rectangle viewRect = new Rectangle(0, 0, menuItem.getWidth(), menuItem.getHeight());
        CommonMenuLayoutHelper.applyInsets(viewRect, menuItem.getInsets());
        CommonMenuLayoutHelper layoutHelper = new CommonMenuLayoutHelper(menuItem, checkIcon, arrowIcon, viewRect, defaultTextIconGap, 0, (int)StandardDimensions.INSTANCE.getMENU_CHECK_ICON_GAP(), this.acceleratorDelimiter, menuItem.getComponentOrientation().isLeftToRight(), menuItem.getFont(), this.acceleratorFont, MenuItemLayoutHelper.useCheckAndArrow(this.menuItem), this.getPropertyPrefix());
        MenuItemLayoutHelper.LayoutResult layoutResult = layoutHelper.layoutMenuItem();
        this.paintBackground(graphics, menuItem, background);
        if (menuItem.isActionSelected()) {
            CommonMenuPaintHelper.paintCheckIcon(graphics, layoutHelper, layoutResult, holdc, foreground);
        }
        CommonMenuPaintHelper.paintIcon(graphics, layoutHelper, layoutResult, holdc);
        if (!layoutHelper.getText().isEmpty()) {
            this.paintText(graphics, layoutHelper.getMenuItem(), layoutResult.getTextRect(), layoutHelper.getText());
        }
        CommonMenuPaintHelper.paintAccText(graphics, layoutHelper, layoutResult, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
        graphics.setColor(holdc);
        graphics.setFont(holdf);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/stdui/menu/CommonMenuItemUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreferredMenuItemSize";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "paintMenuItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

