/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;

public class EnableSwingProfilerAction
extends DumbAwareToggleAction {
    private static final Key<Object> SERVICE_KEY = Key.create((String)"com.android.tools.swingp.server.StatsSerializer");
    private static boolean ourHasInstrumentedVm;

    public EnableSwingProfilerAction() {
        super("Enable Swing Profiler");
    }

    public boolean isSelected(AnActionEvent e) {
        return SERVICE_KEY.isIn((UserDataHolder)ApplicationManager.getApplication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(AnActionEvent event, boolean state) {
        block12: {
            Object serializer = SERVICE_KEY.get((UserDataHolder)ApplicationManager.getApplication());
            if (serializer == null && state) {
                if (!EnableSwingProfilerAction.instrumentVm()) {
                    return;
                }
                try {
                    Class<?> serializerClass = Class.forName("com.android.tools.swingp.server.StatsSerializer");
                    Method start = serializerClass.getMethod("start", new Class[0]);
                    Object serializerInstance = serializerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!((Boolean)start.invoke(serializerInstance, new Object[0])).booleanValue()) break block12;
                    SERVICE_KEY.set((UserDataHolder)ApplicationManager.getApplication(), serializerInstance);
                    URL visualizerUrl = ((Object)((Object)this)).getClass().getResource("/swingp/Visualizer.html");
                    if (visualizerUrl != null) {
                        BrowserUtil.browse((URL)visualizerUrl);
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    Logger.getInstance(EnableSwingProfilerAction.class).warn("Stats serializer could not be started", (Throwable)e);
                }
            } else if (serializer != null && !state) {
                try {
                    Class<?> serializerClass = Class.forName("com.android.tools.swingp.server.StatsSerializer");
                    Method stop = serializerClass.getMethod("stop", new Class[0]);
                    stop.invoke(serializer, new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    Logger.getInstance(EnableSwingProfilerAction.class).warn("Stats serializer could not stop or stop interrupted", (Throwable)e);
                }
                finally {
                    SERVICE_KEY.set((UserDataHolder)ApplicationManager.getApplication(), null);
                }
            }
        }
    }

    private static boolean instrumentVm() {
        if (ourHasInstrumentedVm) {
            return true;
        }
        String vmName = ManagementFactory.getRuntimeMXBean().getName();
        String pid = vmName.substring(0, vmName.indexOf(64));
        try {
            Path jarPath = Paths.get(PathManager.getHomePath(), "../../bazel-genfiles/tools/adt/idea/swingp/swing-instrumenter_deploy.jarjar.jar");
            VirtualMachine vm = VirtualMachine.attach(pid);
            vm.loadAgent(jarPath.toString(), null);
        }
        catch (AgentInitializationException | AgentLoadException | AttachNotSupportedException | IOException e) {
            Logger.getInstance(EnableSwingProfilerAction.class).warn("Could not connect to the VM and start instrumentation agent.", (Throwable)e);
            return false;
        }
        ourHasInstrumentedVm = true;
        return true;
    }
}

