/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DropDownActionButton
extends ActionButtonWithText
implements TextAccessor {
    private static final Icon DROP_DOWN_ICON = AllIcons.General.ArrowDown;
    private static final int ICON_TEXT_SPACE = JBUIScale.scale((int)4);
    private static final JBInsets INSETS = JBUI.insets((int)0, (int)4, (int)0, (int)2);
    private static final int DROP_DOWN_ICON_SIZE_OFFSET = JBUIScale.scale((int)-8);
    private boolean myIsSelected;

    public DropDownActionButton(@NotNull AnAction action, @NotNull Presentation presentation, @NotNull String place) {
        if (action == null) {
            DropDownActionButton.$$$reportNull$$$0(0);
        }
        if (presentation == null) {
            DropDownActionButton.$$$reportNull$$$0(1);
        }
        if (place == null) {
            DropDownActionButton.$$$reportNull$$$0(2);
        }
        super(action, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.myIsSelected = false;
        this.setForeground(JBColor.foreground());
    }

    public int getPopState() {
        return this.myIsSelected ? 1 : super.getPopState();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        if (this.shouldPaintArrow()) {
            DROP_DOWN_ICON.paintIcon((Component)((Object)this), g, this.getWidth() - DROP_DOWN_ICON.getIconWidth() - insets.right, (this.getHeight() - DROP_DOWN_ICON.getIconHeight() - insets.bottom - insets.top) / 2);
        }
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.shouldPaintArrow()) {
            return new Dimension(size.width + DROP_DOWN_ICON.getIconWidth() + DROP_DOWN_ICON_SIZE_OFFSET, size.height);
        }
        return size;
    }

    protected int iconTextSpace() {
        return ICON_TEXT_SPACE;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets.left += DropDownActionButton.INSETS.left;
        insets.right += DropDownActionButton.INSETS.right;
        return insets;
    }

    public void setSelected(boolean selected) {
        this.myIsSelected = selected;
        this.repaint();
    }

    protected int horizontalTextAlignment() {
        return 2;
    }

    public void setText(String text) {
        this.myPresentation.setText(text);
    }

    @NotNull
    public String getText() {
        String string = this.myPresentation.getText();
        if (string == null) {
            DropDownActionButton.$$$reportNull$$$0(3);
        }
        return string;
    }

    private boolean shouldPaintArrow() {
        return this.myAction instanceof ActionGroup && ((ActionGroup)this.myAction).getChildren(null).length > 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/actions/DropDownActionButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/actions/DropDownActionButton";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

