/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.DocumentAccessor;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class LabelWithEditButton
extends JPanel
implements DocumentAccessor {
    private static final String EDIT_TEXT = "Edit";
    private static final String DONE_TEXT = "Done";
    private final JButton myButton = new JButton();
    private final JTextField myTextField = new JTextField(){

        @Override
        public Border getBorder() {
            return this.isEnabled() ? super.getBorder() : BorderFactory.createEmptyBorder();
        }

        @Override
        public Color getBackground() {
            return this.isEnabled() || this.getParent() == null ? super.getBackground() : this.getParent().getBackground();
        }
    };

    public LabelWithEditButton() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.myTextField);
        this.add(this.myButton);
        this.myButton.setLabel(EDIT_TEXT);
        this.myTextField.setEnabled(false);
        this.myButton.addActionListener(e -> this.toggleEdit());
        this.setFont(StartupUiUtil.getLabelFont());
    }

    private void toggleEdit() {
        boolean isEnabled = this.myTextField.isEnabled();
        this.myButton.setLabel(isEnabled ? EDIT_TEXT : DONE_TEXT);
        this.myTextField.setEnabled(!isEnabled);
        if (!isEnabled) {
            this.myTextField.requestFocusInWindow();
        }
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            LabelWithEditButton.$$$reportNull$$$0(0);
        }
        this.myTextField.setText(text);
    }

    @NotNull
    public String getText() {
        String string = this.myTextField.getText();
        if (string == null) {
            LabelWithEditButton.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (font != null && this.myTextField != null) {
            this.myTextField.setFont(font);
        }
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = this.myTextField.getDocument();
        if (document == null) {
            LabelWithEditButton.$$$reportNull$$$0(2);
        }
        return document;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/LabelWithEditButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/LabelWithEditButton";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

