/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.EventModel;
import com.android.tools.adtui.model.event.LifecycleAction;
import com.android.tools.adtui.model.event.LifecycleEvent;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;

public class ActivityComponent
extends AnimatedComponent {
    public static final int EVENT_LINE_WIDTH_PX = 4;
    public static final int EVENT_LINE_GAP_WIDTH_PX = 1;
    private static final Color DISABLED_ACTION = new JBColor(14409698, 6184800);
    private static final Color ENABLED_ACTION = new JBColor(6609078, 1224865);
    private static final Color EVENT_LINE = new JBColor(9014158, 0x999A9A);
    private static final int SEGMENT_SPACING = 5;
    private static final float DEFAULT_LINE_THICKNESS = 0.3f;
    private static final float FONT_PADDING = 10.0f;
    private static final int FONT_SPACING = 10;
    @NotNull
    private final EventModel<LifecycleEvent> myActivityModel;
    @NotNull
    private final EventModel<LifecycleEvent> myFragmentModel;
    private List<ActivityRenderData> myActivities;
    private List<Double> myFragmentPositions;
    private boolean myRender;

    public ActivityComponent(@NotNull EventModel<LifecycleEvent> activityModel, @NotNull EventModel<LifecycleEvent> fragmentModel) {
        if (activityModel == null) {
            ActivityComponent.$$$reportNull$$$0(0);
        }
        if (fragmentModel == null) {
            ActivityComponent.$$$reportNull$$$0(1);
        }
        this.myActivities = new ArrayList<ActivityRenderData>();
        this.myFragmentPositions = new ArrayList<Double>();
        this.myActivityModel = activityModel;
        this.myFragmentModel = fragmentModel;
        this.myActivityModel.addDependency(this.myAspectObserver).onChange(EventModel.Aspect.EVENT, this::modelChanged);
        this.myRender = true;
    }

    private void modelChanged() {
        this.myRender = true;
        this.opaqueRepaint();
    }

    private void renderActivity() {
        LifecycleAction data;
        double min = this.myActivityModel.getRangedSeries().getXRange().getMin();
        double max = this.myActivityModel.getRangedSeries().getXRange().getMax();
        this.myActivities.clear();
        for (SeriesData<EventAction<LifecycleEvent>> seriesData : this.myActivityModel.getRangedSeries().getSeries()) {
            data = (LifecycleAction)seriesData.value;
            double endTime = data.getEndUs() == 0L ? max : (double)data.getEndUs();
            double normalizedEndPosition = (endTime - min) / (max - min);
            double normalizedStartPosition = ((double)data.getStartUs() - min) / (max - min);
            if (normalizedStartPosition < 0.0) {
                normalizedStartPosition = 0.0;
            }
            Rectangle2D.Double rect = new Rectangle2D.Double(normalizedStartPosition, 0.7f, normalizedEndPosition - normalizedStartPosition, 0.3f);
            this.myActivities.add(new ActivityRenderData(data, rect));
        }
        this.myActivities.sort((erd1, erd2) -> {
            if (erd1.getAction().getEndUs() == 0L && erd2.getAction().getEndUs() != 0L) {
                return -1;
            }
            if (erd1.getAction().getEndUs() != 0L && erd2.getAction().getEndUs() == 0L) {
                return 1;
            }
            if (erd1.getAction().getEndUs() != 0L && erd2.getAction().getEndUs() != 0L) {
                return erd1.getAction().getEndUs() - erd2.getAction().getEndUs() >= 0L ? 1 : -1;
            }
            return erd1.getAction().getStartUs() - erd2.getAction().getStartUs() >= 0L ? 1 : -1;
        });
        this.myFragmentPositions.clear();
        for (SeriesData<EventAction<LifecycleEvent>> seriesData : this.myFragmentModel.getRangedSeries().getSeries()) {
            data = (LifecycleAction)seriesData.value;
            if ((double)data.getEndUs() >= min && (double)data.getEndUs() < max) {
                this.myFragmentPositions.add(((double)data.getEndUs() - min) / (max - min));
            }
            if (!((double)data.getStartUs() >= min) || !((double)data.getStartUs() < max)) continue;
            this.myFragmentPositions.add(((double)data.getStartUs() - min) / (max - min));
        }
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.myRender) {
            this.renderActivity();
            this.myRender = false;
        }
        this.drawActivity(g2d, dim);
    }

    private void drawActivity(Graphics2D g2d, Dimension dim) {
        int scaleFactor = dim.width;
        AffineTransform scale = AffineTransform.getScaleInstance(scaleFactor, dim.height - 5);
        double min = this.myActivityModel.getRangedSeries().getXRange().getMin();
        double max = this.myActivityModel.getRangedSeries().getXRange().getMax();
        FontMetrics metrics = g2d.getFontMetrics();
        Object previousHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        ListIterator<ActivityRenderData> itor = this.myActivities.listIterator();
        while (itor.hasNext()) {
            ActivityRenderData renderData = itor.next();
            EventAction<LifecycleEvent> event = renderData.getAction();
            g2d.setColor(event.getEndUs() == 0L ? ENABLED_ACTION : DISABLED_ACTION);
            Shape shape = scale.createTransformedShape(renderData.getPath());
            g2d.fill(shape);
            String text = "";
            if (event.getType() != LifecycleEvent.NONE) {
                text = ((LifecycleAction)event).getName();
            }
            double normalizedStartPosition = ((double)event.getStartUs() - min) / (max - min);
            double lifetime = event.getEndUs();
            if (event.getEndUs() == 0L) {
                lifetime = max;
            }
            double normalizedEndPosition = (lifetime - min) / (max - min);
            float startPosition = (float)normalizedStartPosition * (float)scaleFactor;
            float endPosition = (float)normalizedEndPosition * (float)scaleFactor;
            if (startPosition <= 10.0f) {
                startPosition = 10.0f;
            }
            if ((text = AdtUiUtils.shrinkToFit(text, metrics, endPosition - startPosition)).isEmpty()) continue;
            g2d.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
            g2d.drawString(text, startPosition, 10.0f);
        }
        g2d.setColor(g2d.getBackground());
        for (Double normalizedPosition : this.myFragmentPositions) {
            g2d.fill(scale.createTransformedShape(new Rectangle2D.Double(normalizedPosition - 3.0 / dim.getWidth(), 0.7f, 6.0 / dim.getWidth(), 0.3f)));
        }
        g2d.setColor(EVENT_LINE);
        for (Double normalizedPosition : this.myFragmentPositions) {
            g2d.fill(scale.createTransformedShape(new Rectangle2D.Double(normalizedPosition - 2.0 / dim.getWidth(), 0.7f, 4.0 / dim.getWidth(), 0.3f)));
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, previousHint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "activityModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fragmentModel";
                break;
            }
        }
        objectArray[1] = "com/android/tools/adtui/ActivityComponent";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ActivityRenderData {
        private final EventAction<LifecycleEvent> mAction;
        private final Rectangle2D mPath;

        public EventAction<LifecycleEvent> getAction() {
            return this.mAction;
        }

        public Rectangle2D getPath() {
            return this.mPath;
        }

        public ActivityRenderData(EventAction<LifecycleEvent> action, Rectangle2D path) {
            this.mAction = action;
            this.mPath = path;
        }
    }
}

