/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.fxom.TransientNode;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueElement;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class TransientProperty
extends TransientNode {
    private final PropertyName name;
    private final GlueElement propertyElement;
    private final List<FXOMObject> values = new ArrayList<FXOMObject>();
    private final List<FXOMProperty> collectedProperties = new ArrayList<FXOMProperty>();

    public TransientProperty(TransientNode parentNode, PropertyName name, GlueElement propertyElement) {
        super(parentNode);
        assert (name != null);
        assert (propertyElement != null);
        assert (propertyElement.getTagName().equals(name.toString()));
        this.name = name;
        this.propertyElement = propertyElement;
    }

    public List<FXOMObject> getValues() {
        return this.values;
    }

    public List<FXOMProperty> getCollectedProperties() {
        return this.collectedProperties;
    }

    public FXOMProperty makeFxomProperty(FXOMDocument fxomDocument) {
        FXOMProperty result;
        if (this.collectedProperties.isEmpty()) {
            if (this.values.isEmpty()) {
                assert (this.propertyElement.getChildren().isEmpty());
                assert (!this.propertyElement.getContent().isEmpty());
                result = new FXOMPropertyT(fxomDocument, this.name, this.propertyElement, null, this.propertyElement.getContentText());
            } else {
                FXOMInstance value;
                String fxValue;
                result = this.values.size() == 1 && this.values.get(0) instanceof FXOMInstance ? ((fxValue = (value = (FXOMInstance)this.values.get(0)).getFxValue()) != null ? new FXOMPropertyT(fxomDocument, this.name, this.propertyElement, value.getGlueElement(), fxValue) : new FXOMPropertyC(fxomDocument, this.name, this.values, this.propertyElement)) : new FXOMPropertyC(fxomDocument, this.name, this.values, this.propertyElement);
            }
        } else {
            assert (this.getSceneGraphObject() instanceof Map);
            result = new FXOMPropertyT(fxomDocument, this.name, "fake-value");
        }
        return result;
    }
}

