/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy;

import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyItem;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.net.URL;
import java.util.Locale;
import java.util.Objects;
import javafx.scene.image.Image;

public class HierarchyItemBorderPane
extends HierarchyItem {
    private final DesignHierarchyMask.Accessory position;
    private final DesignHierarchyMask owner;

    public HierarchyItemBorderPane(DesignHierarchyMask owner, FXOMObject fxomObject, DesignHierarchyMask.Accessory position) {
        assert (owner != null);
        this.owner = owner;
        this.mask = fxomObject == null ? null : new DesignHierarchyMask(fxomObject);
        this.position = position;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HierarchyItemBorderPane item = (HierarchyItemBorderPane)obj;
        if (!this.isEmpty()) {
            assert (this.getFxomObject() != null);
            return this.getFxomObject().equals(item.getFxomObject());
        }
        return this.getOwner().equals(item.getOwner()) && this.getPosition().equals((Object)item.getPosition());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.mask);
        hash = 37 * hash + Objects.hashCode(this.owner);
        hash = 37 * hash + Objects.hashCode((Object)this.position);
        return hash;
    }

    @Override
    public boolean isPlaceHolder() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.mask == null;
    }

    public DesignHierarchyMask getOwner() {
        return this.owner;
    }

    public DesignHierarchyMask.Accessory getPosition() {
        return this.position;
    }

    @Override
    public Image getPlaceHolderImage() {
        return ImageUtils.getNodeIcon("BorderPane-" + this.position.name().toLowerCase(Locale.ROOT) + ".png");
    }

    @Override
    public String getPlaceHolderInfo() {
        return this.mask != null ? null : I18N.getString("hierarchy.placeholder.insert") + this.position.name().toUpperCase(Locale.getDefault());
    }

    @Override
    public Image getClassNameIcon() {
        return this.mask == null ? null : this.mask.getClassNameIcon();
    }

    @Override
    public URL getClassNameIconURL() {
        return this.mask == null ? null : this.mask.getClassNameIconURL();
    }

    @Override
    public String getClassNameInfo() {
        return this.mask == null ? null : this.mask.getClassNameInfo();
    }
}

