/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.css;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class SelectionPath
extends HBox {
    private Path currentPath;
    private String selector;
    private final ObjectProperty<Item> selected = new SimpleObjectProperty();

    public SelectionPath() {
        this.setSpacing(5.0);
    }

    public void select(Object obj) {
        assert (this.currentPath != null && !this.currentPath.getItems().isEmpty());
        Path newPath = new Path(SelectionPath.lookupPath(this.currentPath.getItems().get(0), obj));
        this.setSelectionPath(newPath);
        int lastIndex = newPath.getItems().size() - 1;
        this.selected.set((Object)newPath.getItems().get(lastIndex));
    }

    public static List<Item> lookupPath(Item current, Object obj) {
        List<Item> ret = new ArrayList<Item>();
        if (current.getItem() == obj) {
            ret.add(current);
        } else {
            for (Item c : current.getChildren()) {
                List<Item> branch = SelectionPath.lookupPath(c, obj);
                if (branch.isEmpty()) continue;
                branch.add(0, current);
                ret = branch;
                break;
            }
        }
        return ret;
    }

    public void setSelectionPath(Path selection) {
        assert (selection != null);
        this.currentPath = selection;
        this.getChildren().clear();
        ArrayList<Item> iterationPath = new ArrayList<Item>();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < selection.getItems().size(); ++i) {
            Item item = selection.getItems().get(i);
            iterationPath.add(item);
            Hyperlink label = new Hyperlink(item.getName());
            label.setMaxHeight(Double.MAX_VALUE);
            builder.append(item.getName());
            ArrayList myPath = new ArrayList(iterationPath);
            EventHandler eh = event -> {
                this.setSelectionPath(new Path(myPath));
                this.select(item.getItem());
                this.requestFocus();
            };
            label.setOnAction(eh);
            String optional = item.getOptional();
            if (optional != null) {
                HBox hbox = new HBox(0.0);
                hbox.getChildren().add((Object)label);
                Hyperlink opt = new Hyperlink(" " + optional);
                opt.setOnAction(eh);
                hbox.setOnMouseEntered((EventHandler)new MouseEnterListener(opt, label));
                hbox.setOnMouseExited((EventHandler)new MouseExitedListener(opt, label));
                opt.setMaxHeight(Double.MAX_VALUE);
                opt.getStyleClass().add((Object)"styleable-path-optional-label");
                hbox.getChildren().add((Object)opt);
                this.getChildren().add((Object)hbox);
            } else {
                this.getChildren().add((Object)label);
            }
            if (!item.getChildren().isEmpty()) {
                Item next = null;
                if (i < selection.getItems().size() - 1) {
                    next = selection.getItems().get(i + 1);
                }
                ChildButton mb = new ChildButton(item.getChildren(), new ArrayList(iterationPath), next);
                this.getChildren().add((Object)mb);
            }
            if (i >= selection.getItems().size() - 1) continue;
            builder.append(" ");
        }
        this.selector = builder.toString();
    }

    public ObjectProperty<Item> selected() {
        return this.selected;
    }

    public String toString() {
        return this.selector;
    }

    public static class Path {
        private final List<Item> items;

        public Path(List<Item> items) {
            this.items = items;
        }

        public List<Item> getItems() {
            return this.items;
        }
    }

    public static class Item {
        private final Object item;
        private final String name;
        private final String optional;
        private final List<Item> children = new ArrayList<Item>();

        public Item(Object item, String name, String optional) {
            this.item = item;
            this.name = name;
            this.optional = optional;
        }

        public Object getItem() {
            return this.item;
        }

        public String getName() {
            return this.name;
        }

        public String getOptional() {
            return this.optional;
        }

        public List<Item> getChildren() {
            return this.children;
        }
    }

    private class ChildButton
    extends StackPane {
        private double yOffset;
        private Button pathButton = new Button();

        private ChildButton(List<Item> children, List<Item> childrenPath, Item selectedChild) {
            Region pathButtonGraphic = new Region();
            pathButtonGraphic.getStyleClass().add((Object)"styleable-path-button-shape");
            this.pathButton.setGraphic((Node)pathButtonGraphic);
            this.getChildren().add((Object)this.pathButton);
            ContextMenu menu = new ContextMenu();
            for (Item c : children) {
                ChildMenuItem mi = new ChildMenuItem(c);
                ArrayList<Item> childPath = new ArrayList<Item>(childrenPath);
                childPath.add(c);
                mi.setOnAction(event -> {
                    SelectionPath.this.setSelectionPath(new Path(childPath));
                    SelectionPath.this.selected.set((Object)c);
                });
                menu.getItems().add((Object)mi);
            }
            menu.setOnShowing(event -> {
                for (MenuItem m : menu.getItems()) {
                    ChildMenuItem cm;
                    assert (m instanceof ChildMenuItem);
                    cm.setSelected((cm = (ChildMenuItem)m).item == selectedChild);
                }
                this.positionMenu(menu);
            });
            menu.heightProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.doubleValue() <= 0.0) {
                    return;
                }
                double singleHeight = newValue.doubleValue() / (double)menu.getItems().size();
                int index = 0;
                boolean found = false;
                for (MenuItem m : menu.getItems()) {
                    assert (m instanceof ChildMenuItem);
                    ChildMenuItem cm = (ChildMenuItem)m;
                    ++index;
                    if (!cm.isSelected()) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.yOffset = singleHeight * (double)(index - 1);
                    this.positionMenu(menu);
                }
            });
            this.pathButton.setOnMouseClicked(event -> {
                if (!menu.isShowing()) {
                    menu.show((Node)this, Side.RIGHT, 0.0, 0.0);
                }
            });
        }

        private void positionMenu(ContextMenu menu) {
            if (this.yOffset != 0.0) {
                menu.setY(menu.getY() - this.yOffset);
            }
        }

        private class ChildMenuItem
        extends CheckMenuItem {
            private final Item item;

            ChildMenuItem(Item item) {
                super(item.getName());
                this.item = item;
            }
        }
    }

    private static class MouseExitedListener
    implements EventHandler<MouseEvent> {
        Hyperlink opt;
        Hyperlink label;

        public MouseExitedListener(Hyperlink opt, Hyperlink label) {
            this.opt = opt;
            this.label = label;
        }

        public void handle(MouseEvent event) {
            this.opt.setUnderline(false);
            this.label.setUnderline(false);
        }
    }

    private static class MouseEnterListener
    implements EventHandler<MouseEvent> {
        Hyperlink opt;
        Hyperlink label;

        public MouseEnterListener(Hyperlink opt, Hyperlink label) {
            this.opt = opt;
            this.label = label;
        }

        public void handle(MouseEvent event) {
            this.opt.setUnderline(true);
            this.label.setUnderline(true);
        }
    }
}

