/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.css;

import com.oracle.javafx.scenebuilder.kit.editor.panel.css.CssValueConverter;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class CssValuePresenterFactory {
    private static final CssValuePresenterFactory singleton = new CssValuePresenterFactory();

    protected CssValuePresenterFactory() {
    }

    public static CssValuePresenterFactory getInstance() {
        return singleton;
    }

    public <T> CssValuePresenter<T> newValuePresenter(T value) {
        CssValuePresenter ret = Paint.class.isAssignableFrom(value.getClass()) ? new PaintValuePresenter((Paint)value) : (value instanceof Image ? new ImageValuePresenter((Image)value) : new DefaultValuePresenter(value));
        PaintValuePresenter castedRet = ret;
        return castedRet;
    }

    private class DefaultValuePresenter
    extends CssValuePresenter<Object> {
        private DefaultValuePresenter(Object val) {
            super(val);
        }

        @Override
        protected Node doGetPresenter() {
            return null;
        }
    }

    private class ImageValuePresenter
    extends CssValuePresenter<Image> {
        private ImageValuePresenter(Image img) {
            super(img);
        }

        @Override
        protected Node doGetPresenter() {
            ImageView imgView = new ImageView((Image)this.getValue());
            imgView.setFitWidth(15.0);
            imgView.setPreserveRatio(true);
            return imgView;
        }
    }

    private class PaintValuePresenter
    extends CssValuePresenter<Paint> {
        private PaintValuePresenter(Paint p) {
            super(p);
        }

        @Override
        protected Node doGetPresenter() {
            Rectangle rect = new Rectangle(10.0, 10.0);
            rect.setStroke((Paint)Color.BLACK);
            rect.setFill((Paint)this.getValue());
            return rect;
        }
    }

    public abstract class CssValuePresenter<T> {
        private final T value;
        private Node node;

        protected CssValuePresenter(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public Node getCustomPresenter() {
            if (this.node == null) {
                this.node = this.doGetPresenter();
            }
            return this.node;
        }

        public Label getTextPresenter() {
            return new Label(CssValueConverter.toCssString(this.value));
        }

        protected abstract Node doGetPresenter();
    }
}

