/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.changeReminder.repository;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.utils.DfsWalk;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.jetbrains.changeReminder.UtilKt;
import com.jetbrains.changeReminder.repository.Commit;
import git4idea.GitCommit;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\f2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\t\u001a*\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nj\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/changeReminder/repository/FilesHistoryProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "dataManager", "Lcom/intellij/vcs/log/data/VcsLogData;", "dataGetter", "Lcom/intellij/vcs/log/data/index/IndexDataGetter;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/data/index/IndexDataGetter;)V", "filesHistoryCache", "Ljava/util/HashMap;", "Lcom/intellij/openapi/vcs/FilePath;", "", "", "Lkotlin/collections/HashMap;", "clear", "", "getCommitHashesWithFile", "file", "getCommitsData", "Lcom/jetbrains/changeReminder/repository/Commit;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "commits", "getCommitsFromHead", "Lgnu/trove/TIntHashSet;", "getFilesHistory", "files", "intellij.vcs.changeReminder"})
public final class FilesHistoryProvider {
    private final HashMap<FilePath, Collection<Integer>> filesHistoryCache;
    private final Project project;
    private final VcsLogData dataManager;
    private final IndexDataGetter dataGetter;

    private final Collection<Integer> getCommitHashesWithFile(FilePath file) {
        VcsLogStructureFilter structureFilter = VcsLogFilterObject.fromPaths((Collection)SetsKt.setOf((Object)file));
        Set set = this.dataGetter.filter(CollectionsKt.listOf((Object)structureFilter));
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"dataGetter.filter(listOf(structureFilter))");
        return set;
    }

    private final Collection<Commit> getCommitsData(VirtualFile root, Collection<Integer> commits) {
        boolean bl = false;
        Map hashes = new LinkedHashMap();
        Iterator<Integer> iterator = commits.iterator();
        while (iterator.hasNext()) {
            CommitId commitId;
            int commit = ((Number)iterator.next()).intValue();
            if (this.dataGetter.getLogStorage().getCommitId(commit) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)commitId, (String)"dataGetter.logStorage.ge\u2026mitId(commit) ?: continue");
            CommitId commitId2 = commitId;
            boolean bl2 = false;
            boolean bl3 = false;
            CommitId it = commitId2;
            boolean bl4 = false;
            Object object = Intrinsics.areEqual((Object)commitId.getRoot(), (Object)root) ? commitId2 : null;
            if (object == null || (object = object.getHash()) == null || (object = object.asString()) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"commitId.takeIf { commit\u2026h?.asString() ?: continue");
            Object hash = object;
            hashes.put(hash, commit);
        }
        boolean bl5 = false;
        Set commitsData = new LinkedHashSet();
        UtilKt.processCommitsFromHashes(this.project, root, CollectionsKt.toList((Iterable)hashes.keySet()), (Function1<? super GitCommit, Unit>)((Function1)new Function1<GitCommit, Unit>(hashes, commitsData){
            final /* synthetic */ Map $hashes;
            final /* synthetic */ Set $commitsData;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull GitCommit commit) {
                Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
                Collection collection = commit.getChanges();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"commit.changes");
                Collection collection2 = collection;
                boolean bl = false;
                if (!collection2.isEmpty()) {
                    void $this$mapNotNullTo$iv$iv;
                    Integer n = (Integer)this.$hashes.get(commit.getId().asString());
                    if (n == null) {
                        return;
                    }
                    int id = n;
                    long time = commit.getCommitTime();
                    Collection collection3 = commit.getChanges();
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"commit.changes");
                    Iterable $this$mapNotNull$iv = collection3;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        FilePath filePath;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl2 = false;
                        Change it = (Change)element$iv$iv;
                        boolean bl3 = false;
                        if (ChangesUtil.getFilePath((Change)it) == null) continue;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        FilePath it$iv$iv = filePath;
                        boolean bl6 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Set files = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    VcsUser vcsUser = commit.getAuthor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)vcsUser, (String)"commit.author");
                    VcsUser author = vcsUser;
                    String string = author.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"author.name");
                    this.$commitsData.add(new Commit(id, time, string, files));
                }
            }
            {
                this.$hashes = map;
                this.$commitsData = set;
                super(1);
            }
        }));
        return commitsData;
    }

    private final TIntHashSet getCommitsFromHead(VirtualFile root) {
        DataPack dataPack = this.dataManager.getDataPack();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataPack, (String)"dataManager.dataPack");
        DataPack dataPack2 = dataPack;
        String string = this.dataManager.getLogProvider(root).getCurrentBranch(root);
        if (string == null) {
            return new TIntHashSet();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dataManager.getLogProvid\u2026) ?: return TIntHashSet()");
        String branchName = string;
        VcsRef vcsRef = VcsLogUtil.findBranch((RefsModel)dataPack2.getRefsModel(), (VirtualFile)root, (String)branchName);
        if (vcsRef == null) {
            return new TIntHashSet();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsRef, (String)"VcsLogUtil.findBranch(da\u2026) ?: return TIntHashSet()");
        VcsRef branchRef = vcsRef;
        int branchIndex = this.dataManager.getCommitIndex(branchRef.getCommitHash(), branchRef.getRoot());
        PermanentGraph permanentGraph = dataPack2.getPermanentGraph();
        if (!(permanentGraph instanceof PermanentGraphImpl)) {
            permanentGraph = null;
        }
        PermanentGraphImpl permanentGraphImpl = (PermanentGraphImpl)permanentGraph;
        if (permanentGraphImpl == null) {
            return new TIntHashSet();
        }
        PermanentGraphImpl permanentGraph2 = permanentGraphImpl;
        int branchNodeId = permanentGraph2.getPermanentCommitsInfo().getNodeId((Object)branchIndex);
        TIntHashSet commitsFromHead = new TIntHashSet();
        Collection collection = CollectionsKt.listOf((Object)branchNodeId);
        PermanentLinearGraphImpl permanentLinearGraphImpl = permanentGraph2.getLinearGraph();
        Intrinsics.checkExpressionValueIsNotNull((Object)permanentLinearGraphImpl, (String)"permanentGraph.linearGraph");
        new DfsWalk(collection, (LinearGraph)permanentLinearGraphImpl).walk(true, (Function1)new Function1<Integer, Boolean>(commitsFromHead, permanentGraph2){
            final /* synthetic */ TIntHashSet $commitsFromHead;
            final /* synthetic */ PermanentGraphImpl $permanentGraph;

            public final boolean invoke(int it) {
                ProgressManager.checkCanceled();
                Object object = this.$permanentGraph.getPermanentCommitsInfo().getCommitId(it);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"permanentGraph.permanent\u2026mmitsInfo.getCommitId(it)");
                this.$commitsFromHead.add(((Number)object).intValue());
                return true;
            }
            {
                this.$commitsFromHead = tIntHashSet;
                this.$permanentGraph = permanentGraphImpl;
                super(1);
            }
        });
        return commitsFromHead;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Commit> getFilesHistory(@NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files) {
        void $this$mapNotNullTo$iv$iv;
        Iterator iterator;
        void $this$associateWith$iv;
        Object object;
        FilePath it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        UtilKt.retainAll((Map)this.filesHistoryCache, files);
        TIntHashSet commitsFromHead = this.getCommitsFromHead(root);
        Iterable iterable = files;
        HashMap<FilePath, Collection<Integer>> hashMap = this.filesHistoryCache;
        boolean $i$f$filter = false;
        void var6_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FilePath)element$iv$iv;
            boolean bl = false;
            Map map = this.filesHistoryCache;
            boolean bl2 = false;
            object = map;
            boolean bl3 = false;
            if (!(!object.containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object2 = (List)destination$iv$iv;
        $this$filter$iv = (Iterable)object2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv2;
            void file;
            it = (FilePath)element$iv$iv;
            Object t = element$iv$iv;
            object2 = result$iv;
            boolean bl = false;
            Iterable $this$filter$iv2 = this.getCommitHashesWithFile((FilePath)file);
            boolean $i$f$filter2 = false;
            object = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            iterator = $this$filterTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv2 = iterator.next();
                int it2 = ((Number)element$iv$iv2).intValue();
                boolean bl4 = false;
                if (!commitsFromHead.contains(it2)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv2;
            object2.put(t, list);
        }
        object2 = result$iv;
        hashMap.putAll((Map<FilePath, Collection<Integer>>)object2);
        Iterable $this$mapNotNull$iv = files;
        boolean $i$f$mapNotNull = false;
        $this$associateWithTo$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FilePath it3 = (FilePath)element$iv$iv;
            boolean bl5 = false;
            if (this.filesHistoryCache.get(it3) == null) continue;
            boolean bl6 = false;
            boolean bl7 = false;
            Object it$iv$iv = iterator;
            boolean bl8 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List commits = CollectionsKt.flatten((Iterable)((List)destination$iv$iv3));
        return this.getCommitsData(root, commits);
    }

    public final void clear() {
        this.filesHistoryCache.clear();
    }

    public FilesHistoryProvider(@NotNull Project project, @NotNull VcsLogData dataManager, @NotNull IndexDataGetter dataGetter) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataManager, (String)"dataManager");
        Intrinsics.checkParameterIsNotNull((Object)dataGetter, (String)"dataGetter");
        this.project = project;
        this.dataManager = dataManager;
        this.dataGetter = dataGetter;
        this.filesHistoryCache = new HashMap();
    }
}

