/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.changeReminder.predict;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogData;
import com.jetbrains.changeReminder.UtilKt;
import com.jetbrains.changeReminder.predict.PredictionProvider;
import com.jetbrains.changeReminder.repository.Commit;
import com.jetbrains.changeReminder.repository.FilesHistoryProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\tJ$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\t0\u0015H\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/changeReminder/predict/PredictionRequest;", "", "project", "Lcom/intellij/openapi/project/Project;", "dataManager", "Lcom/intellij/vcs/log/data/VcsLogData;", "filesHistoryProvider", "Lcom/jetbrains/changeReminder/repository/FilesHistoryProvider;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/data/VcsLogData;Lcom/jetbrains/changeReminder/repository/FilesHistoryProvider;Ljava/util/Collection;)V", "changeListFiles", "", "Lcom/intellij/openapi/vcs/FilePath;", "calculate", "getPredictedFiles", "files", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "rootFiles", "", "intellij.vcs.changeReminder"})
public final class PredictionRequest {
    private final List<FilePath> changeListFiles;
    private final Project project;
    private final VcsLogData dataManager;
    private final FilesHistoryProvider filesHistoryProvider;

    private final Collection<FilePath> getPredictedFiles(Collection<? extends FilePath> files, VirtualFile root) {
        PredictionProvider predictionProvider = new PredictionProvider(Registry.doubleValue((String)"vcs.changeReminder.prediction.threshold"));
        long l = System.currentTimeMillis();
        Object object = (VcsUser)this.dataManager.getCurrentUser().get(root);
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        return PredictionProvider.predictForgottenFiles$default(predictionProvider, new Commit(-1, l, (String)object, CollectionsKt.toSet((Iterable)this.changeListFiles)), this.filesHistoryProvider.getFilesHistory(root, files), 0, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<FilePath> getPredictedFiles(Map<VirtualFile, ? extends Collection<? extends FilePath>> rootFiles) {
        void $this$mapNotNullTo$iv$iv;
        Map<VirtualFile, ? extends Collection<? extends FilePath>> $this$mapNotNull$iv = rootFiles;
        boolean $i$f$mapNotNull = false;
        Map<VirtualFile, ? extends Collection<? extends FilePath>> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_9 = $this$forEach$iv$iv$iv;
        boolean bl = false;
        Iterator iterator = var9_9.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<FilePath> collection;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry $dstr$root$files = element$iv$iv;
            boolean bl3 = false;
            Map.Entry entry = $dstr$root$files;
            boolean bl4 = false;
            VirtualFile root = (VirtualFile)entry.getKey();
            entry = $dstr$root$files;
            bl4 = false;
            Collection files = (Collection)entry.getValue();
            if ((this.dataManager.getIndex().isIndexed(root) ? this.getPredictedFiles(files, root) : null) == null) continue;
            collection = collection;
            boolean bl5 = false;
            boolean bl6 = false;
            Collection<FilePath> it$iv$iv = collection;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final Collection<FilePath> calculate() {
        Map<VirtualFile, Collection<FilePath>> rootFiles = UtilKt.getGitRootFiles(this.project, (Collection<? extends FilePath>)this.changeListFiles);
        return this.getPredictedFiles(rootFiles);
    }

    /*
     * WARNING - void declaration
     */
    public PredictionRequest(@NotNull Project project, @NotNull VcsLogData dataManager, @NotNull FilesHistoryProvider filesHistoryProvider, @NotNull Collection<? extends Change> changes) {
        Collection<FilePath> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataManager, (String)"dataManager");
        Intrinsics.checkParameterIsNotNull((Object)filesHistoryProvider, (String)"filesHistoryProvider");
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        this.project = project;
        this.dataManager = dataManager;
        this.filesHistoryProvider = filesHistoryProvider;
        Iterable iterable = changes;
        PredictionRequest predictionRequest = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Change change = (Change)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            FilePath filePath = ChangesUtil.getFilePath((Change)it);
            collection.add(filePath);
        }
        collection = (List)destination$iv$iv;
        predictionRequest.changeListFiles = collection;
    }
}

