/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.changeReminder.predict;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.jetbrains.changeReminder.predict.Factor;
import com.jetbrains.changeReminder.predict.PredictionProvider;
import com.jetbrains.changeReminder.prediction.model.PredictionModel;
import com.jetbrains.changeReminder.repository.Commit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002J0\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\f0\u000e2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002J,\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/changeReminder/predict/PredictionProvider;", "", "minProb", "", "(D)V", "collectFileFactors", "", "newCommit", "Lcom/jetbrains/changeReminder/repository/Commit;", "candidateFile", "Lcom/intellij/openapi/vcs/FilePath;", "candidateFileHistory", "", "getRelatedFiles", "", "commit", "history", "", "predictForgottenFiles", "", "maxPredictedFileCount", "", "Companion", "FactorCounter", "intellij.vcs.changeReminder"})
public final class PredictionProvider {
    private final double minProb;
    private static final int MAX_RELATED_FILES_COUNT = 150;
    private static final int MAX_HISTORY_COMMIT_SIZE = 15;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    private final double[] collectFileFactors(Commit newCommit, FilePath candidateFile, Set<Commit> candidateFileHistory) {
        double d;
        void $this$sumByDouble$iv;
        Object v3;
        Iterable $this$maxBy$iv;
        Object it;
        double[] factors = new double[Factor.values().length];
        FactorCounter timeDistanceCounter = new FactorCounter();
        boolean bl = false;
        Map intersectionCounters = new LinkedHashMap();
        FactorCounter countFilesCounter = new FactorCounter();
        FactorCounter filePrefixCounter = new FactorCounter();
        FactorCounter pathPrefixCounter = new FactorCounter();
        double authorCommitted = 0.0;
        Iterable $this$forEach$iv = candidateFileHistory;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Commit oldCommit = (Commit)element$iv;
            boolean bl2 = false;
            Set filesFromCommit = CollectionsKt.intersect((Iterable)oldCommit.getFiles(), (Iterable)newCommit.getFiles());
            countFilesCounter.append((Number)filesFromCommit.size());
            Collection collection = filesFromCommit;
            boolean bl3 = false;
            if (!collection.isEmpty()) {
                timeDistanceCounter.append((Number)(newCommit.getTime() - oldCommit.getTime()));
            }
            if (authorCommitted != 1.0 && StringsKt.startsWith$default((String)oldCommit.getAuthor(), (String)newCommit.getAuthor(), (boolean)false, (int)2, null)) {
                authorCommitted = 1.0;
            }
            Iterable $this$forEach$iv2 = filesFromCommit;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                FilePath file = (FilePath)element$iv2;
                boolean bl4 = false;
                Map $this$getOrPut$iv = intersectionCounters;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(file);
                if (value$iv == null) {
                    boolean bl5 = false;
                    FactorCounter answer$iv = new FactorCounter();
                    $this$getOrPut$iv.put(file, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((FactorCounter)object).append((Number)1);
            }
        }
        String string = candidateFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"candidateFile.path");
        String candidateFilePath = string;
        String string2 = candidateFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"candidateFile.name");
        String candidateFileName = string2;
        Iterable $this$forEach$iv3 = newCommit.getFiles();
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            it = (FilePath)element$iv;
            boolean bl6 = false;
            pathPrefixCounter.append((Number)StringUtil.commonPrefixLength((CharSequence)candidateFilePath, (CharSequence)it.getPath()));
            filePrefixCounter.append((Number)StringUtil.commonPrefixLength((CharSequence)candidateFileName, (CharSequence)it.getName()));
        }
        $this$forEach$iv3 = intersectionCounters.values();
        int n = Factor.MAX_INTERSECTION.ordinal();
        double[] dArray = factors;
        boolean $i$f$maxBy = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            it = (FactorCounter)maxElem$iv;
            boolean bl7 = false;
            double maxValue$iv = ((FactorCounter)it).getSum();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                FactorCounter it2 = (FactorCounter)e$iv;
                $i$a$-maxBy-PredictionProvider$collectFileFactors$3 = false;
                double v$iv = it2.getSum();
                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            }
            v3 = maxElem$iv;
        }
        Object var31_50 = v3;
        FactorCounter factorCounter = var31_50;
        dArray[n] = factorCounter != null ? factorCounter.getSum() : 0.0;
        $this$maxBy$iv = intersectionCounters.values();
        n = Factor.SUM_INTERSECTION.ordinal();
        dArray = factors;
        boolean $i$f$sumByDouble = false;
        double sum$iv = 0.0;
        for (Object element$iv : $this$sumByDouble$iv) {
            void it3;
            FactorCounter v$iv = (FactorCounter)element$iv;
            double d2 = sum$iv;
            boolean bl8 = false;
            double d3 = it3.getSum();
            sum$iv = d2 + d3;
        }
        dArray[n] = d = sum$iv;
        factors[Factor.MIN_DISTANCE_TIME.ordinal()] = timeDistanceCounter.getMin();
        factors[Factor.COMMIT_SIZE.ordinal()] = newCommit.getFiles().size();
        factors[Factor.MAX_DISTANCE_TIME.ordinal()] = timeDistanceCounter.getMax();
        factors[Factor.AVG_DISTANCE_TIME.ordinal()] = timeDistanceCounter.getSum() / (double)candidateFileHistory.size();
        factors[Factor.MAX_COUNT.ordinal()] = countFilesCounter.getMax();
        factors[Factor.MIN_COUNT.ordinal()] = countFilesCounter.getMin();
        factors[Factor.AUTHOR_COMMITTED_THE_FILE.ordinal()] = authorCommitted;
        factors[Factor.MAX_PREFIX_PATH.ordinal()] = pathPrefixCounter.getMax();
        factors[Factor.MAX_PREFIX_FILE_NAME.ordinal()] = filePrefixCounter.getMax();
        return factors;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<FilePath, Set<Commit>> getRelatedFiles(Commit commit, Collection<Commit> history) {
        Iterable $this$sortedByDescending$iv = history;
        boolean $i$f$sortedByDescending = false;
        Iterable iterable = $this$sortedByDescending$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Commit it = (Commit)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getTime());
                it = (Commit)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTime();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        List sortedHistory = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        $i$f$sortedByDescending = false;
        Map relatedFiles = new LinkedHashMap();
        for (Commit oldCommit : sortedHistory) {
            void $this$filterTo$iv$iv;
            if (relatedFiles.size() > 150) break;
            if (oldCommit.getFiles().size() >= 15) continue;
            Iterable $this$filter$iv = oldCommit.getFiles();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FilePath it = (FilePath)element$iv$iv;
                boolean bl2 = false;
                if (!(!commit.getFiles().contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                FilePath relatedFile = (FilePath)element$iv;
                boolean bl3 = false;
                Map $this$getOrPut$iv = relatedFiles;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(relatedFile);
                if (value$iv == null) {
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(relatedFile, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(oldCommit);
            }
        }
        return relatedFiles;
    }

    @NotNull
    public final List<FilePath> predictForgottenFiles(@NotNull Commit commit, @NotNull Collection<Commit> history, int maxPredictedFileCount) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        Intrinsics.checkParameterIsNotNull(history, (String)"history");
        Sequence $this$sortedByDescending$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)MapsKt.asSequence(this.getRelatedFiles(commit, history)), (Function1)((Function1)new Function1<Map.Entry<? extends FilePath, ? extends Set<? extends Commit>>, Pair<? extends FilePath, ? extends Double>>(this, commit){
            final /* synthetic */ PredictionProvider this$0;
            final /* synthetic */ Commit $commit;

            @NotNull
            public final Pair<FilePath, Double> invoke(@NotNull Map.Entry<? extends FilePath, ? extends Set<Commit>> $dstr$candidateFile$candidateFileHistory) {
                Intrinsics.checkParameterIsNotNull($dstr$candidateFile$candidateFileHistory, (String)"<name for destructuring parameter 0>");
                Map.Entry<? extends FilePath, ? extends Set<Commit>> entry = $dstr$candidateFile$candidateFileHistory;
                boolean bl = false;
                FilePath candidateFile = entry.getKey();
                entry = $dstr$candidateFile$candidateFileHistory;
                bl = false;
                Set<Commit> candidateFileHistory = entry.getValue();
                ProgressManager.checkCanceled();
                double fileScore = PredictionModel.makePrediction((double[])PredictionProvider.access$collectFileFactors(this.this$0, this.$commit, candidateFile, candidateFileHistory));
                return TuplesKt.to((Object)candidateFile, (Object)fileScore);
            }
            {
                this.this$0 = predictionProvider;
                this.$commit = commit;
                super(1);
            }
        })), (Function1)((Function1)new Function1<Pair<? extends FilePath, ? extends Double>, Boolean>(this){
            final /* synthetic */ PredictionProvider this$0;

            public final boolean invoke(@NotNull Pair<? extends FilePath, Double> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return ((Number)it.getSecond()).doubleValue() > PredictionProvider.access$getMinProb$p(this.this$0);
            }
            {
                this.this$0 = predictionProvider;
                super(1);
            }
        }));
        boolean $i$f$sortedByDescending = false;
        Sequence sequence = $this$sortedByDescending$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)b;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(((Number)it.getSecond()).doubleValue());
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = ((Number)it.getSecond()).doubleValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        };
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.take((Sequence)SequencesKt.sortedWith((Sequence)sequence, (Comparator)comparator), (int)maxPredictedFileCount), (Function1)predictForgottenFiles.4.INSTANCE));
    }

    public static /* synthetic */ List predictForgottenFiles$default(PredictionProvider predictionProvider, Commit commit, Collection collection, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 5;
        }
        return predictionProvider.predictForgottenFiles(commit, collection, n);
    }

    public PredictionProvider(double minProb) {
        this.minProb = minProb;
    }

    public /* synthetic */ PredictionProvider(double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.55;
        }
        this(d);
    }

    public PredictionProvider() {
        this(0.0, 1, null);
    }

    public static final /* synthetic */ double[] access$collectFileFactors(PredictionProvider $this, Commit newCommit, FilePath candidateFile, Set candidateFileHistory) {
        return $this.collectFileFactors(newCommit, candidateFile, candidateFileHistory);
    }

    public static final /* synthetic */ double access$getMinProb$p(PredictionProvider $this) {
        return $this.minProb;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0004\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/changeReminder/predict/PredictionProvider$FactorCounter;", "", "()V", "<set-?>", "", "max", "getMax", "()D", "min", "getMin", "sum", "getSum", "append", "newValue", "", "intellij.vcs.changeReminder"})
    private static final class FactorCounter {
        private double sum;
        private double max;
        private double min = DoubleCompanionObject.INSTANCE.getMAX_VALUE();

        public final double getSum() {
            return this.sum;
        }

        public final double getMax() {
            return this.max;
        }

        public final double getMin() {
            return this.min;
        }

        @NotNull
        public final FactorCounter append(@NotNull Number newValue) {
            Intrinsics.checkParameterIsNotNull((Object)newValue, (String)"newValue");
            return this.append(newValue.doubleValue());
        }

        private final FactorCounter append(double newValue) {
            double d;
            this.sum += newValue;
            double d2 = this.max;
            FactorCounter factorCounter = this;
            boolean bl = false;
            factorCounter.max = d = Math.max(d2, newValue);
            d2 = this.min;
            factorCounter = this;
            bl = false;
            factorCounter.min = d = Math.min(d2, newValue);
            return this;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/changeReminder/predict/PredictionProvider$Companion;", "", "()V", "MAX_HISTORY_COMMIT_SIZE", "", "MAX_RELATED_FILES_COUNT", "intellij.vcs.changeReminder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

