/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.changeReminder.changes;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.jetbrains.changeReminder.predict.PredictionService;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00192\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u0019B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0014\u0010\u0017\u001a\u00020\u0010*\u00020\u00122\u0006\u0010\u0018\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/changeReminder/changes/ChangeReminderBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "files", "predictionService", "Lcom/jetbrains/changeReminder/predict/PredictionService;", "(Ljava/util/Collection;Lcom/jetbrains/changeReminder/predict/PredictionService;)V", "getHelpToolTipText", "", "getPredictionToolTipText", "predictionSize", "", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "appendCustomState", "state", "Companion", "intellij.vcs.changeReminder"})
public final class ChangeReminderBrowserNode
extends ChangesBrowserNode<Collection<? extends VirtualFile>> {
    private final Collection<VirtualFile> files;
    private final PredictionService predictionService;
    private static final String NODE_TITLE = "Related Files";
    private static final String LOADING_ATTRIBUTE = "Git Log is loading...";
    private static final String CALCULATING_ATTRIBUTE = "Calculating...";
    public static final Companion Companion = new Companion(null);

    private final void appendCustomState(@NotNull ChangesBrowserNodeRenderer $this$appendCustomState, String state) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getCountText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"countText");
        CharSequence charSequence = string;
        StringBuilder stringBuilder2 = stringBuilder;
        ChangesBrowserNodeRenderer changesBrowserNodeRenderer = $this$appendCustomState;
        boolean bl = false;
        boolean bl2 = charSequence.length() == 0;
        changesBrowserNodeRenderer.append(stringBuilder2.append(bl2 ? FontUtil.spaceAndThinSpace() : ", ").append(state).toString(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    private final String getPredictionToolTipText(int predictionSize, LocalChangeList changeList) {
        return StringUtil.pluralize((String)"This", (int)predictionSize) + ' ' + predictionSize + ' ' + StringUtil.pluralize((String)"file", (int)predictionSize) + ' ' + (predictionSize > 1 ? "are" : "is") + " usually committed together with " + "the " + StringUtil.pluralize((String)"file", (int)changeList.getChanges().size()) + " from the " + changeList.getName();
    }

    private final String getHelpToolTipText() {
        StringBuilder stringBuilder = new StringBuilder();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        return stringBuilder.append(applicationNamesInfo.getFullProductName()).append(' ').append("predicts files that are usually committed together, so that they are not forgotten by mistake.").toString();
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
        renderer.append(NODE_TITLE, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.appendCount((ColoredTreeCellRenderer)renderer);
        renderer.setIcon(AllIcons.General.Information);
        Project project = this.predictionService.getProject();
        if (this.predictionService.isReady()) {
            if (this.predictionService.getInProgress()) {
                this.appendCustomState(renderer, CALCULATING_ATTRIBUTE);
            }
        } else {
            this.appendCustomState(renderer, LOADING_ATTRIBUTE);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        ChangeListManager changeListManager2 = changeListManager;
        LocalChangeList localChangeList = changeListManager2.getDefaultChangeList();
        Intrinsics.checkExpressionValueIsNotNull((Object)localChangeList, (String)"changeListManager.defaultChangeList");
        LocalChangeList defaultChangeList = localChangeList;
        Collection<VirtualFile> collection = this.files;
        boolean bl = false;
        if (!collection.isEmpty()) {
            renderer.setToolTipText(this.getPredictionToolTipText(this.files.size(), defaultChangeList));
        } else {
            renderer.setToolTipText(this.getHelpToolTipText());
        }
    }

    public ChangeReminderBrowserNode(@NotNull Collection<? extends VirtualFile> files, @NotNull PredictionService predictionService) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)predictionService, (String)"predictionService");
        super(files);
        this.files = files;
        this.predictionService = predictionService;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/changeReminder/changes/ChangeReminderBrowserNode$Companion;", "", "()V", "CALCULATING_ATTRIBUTE", "", "LOADING_ATTRIBUTE", "NODE_TITLE", "intellij.vcs.changeReminder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

