/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.EvaluatedXmlNameImpl;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildInvocationHandler;
import com.intellij.util.xml.impl.CollectionElementInvocationHandler;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.FileDescriptionCachedValueProvider;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.IndexedElementInvocationHandler;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.stubs.DomStub;
import com.intellij.util.xml.stubs.ElementStub;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DomSemContributor
extends SemContributor {
    DomSemContributor() {
    }

    public void registerSemProviders(@NotNull SemRegistrar registrar, @NotNull Project project2) {
        if (registrar == null) {
            DomSemContributor.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            DomSemContributor.$$$reportNull$$$0(1);
        }
        registrar.registerSemElementProvider(DomManagerImpl.FILE_DESCRIPTION_KEY, (ElementPattern)XmlPatterns.xmlFile(), xmlFile -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            return new FileDescriptionCachedValueProvider(DomManagerImpl.getDomManager(xmlFile.getProject()), (XmlFile)xmlFile);
        });
        SemService semService = SemService.getSemService((Project)project2);
        registrar.registerSemElementProvider(DomManagerImpl.DOM_HANDLER_KEY, (ElementPattern)XmlPatterns.xmlTag().withParent((ElementPattern)XmlPatterns.psiElement((IElementType)XmlElementType.XML_DOCUMENT).withParent((ElementPattern)XmlPatterns.xmlFile())), xmlTag -> {
            DomRootInvocationHandler handler;
            FileDescriptionCachedValueProvider provider = (FileDescriptionCachedValueProvider)semService.getSemElement(DomManagerImpl.FILE_DESCRIPTION_KEY, (PsiElement)xmlTag.getContainingFile());
            assert (provider != null);
            DomFileElementImpl element = provider.getFileElement();
            if (element != null && (handler = element.getRootHandler()).getXmlTag() == xmlTag) {
                return handler;
            }
            return null;
        });
        TreeElementPattern nonRootTag = XmlPatterns.xmlTag().withParent(XmlPatterns.or((ElementPattern[])new ElementPattern[]{XmlPatterns.xmlTag(), XmlPatterns.xmlEntityRef().withParent((ElementPattern)XmlPatterns.xmlTag())}));
        registrar.registerSemElementProvider(DomManagerImpl.DOM_INDEXED_HANDLER_KEY, (ElementPattern)nonRootTag, tag -> {
            XmlTag parentTag = PhysicalDomParentStrategy.getParentTag((XmlElement)tag);
            assert (parentTag != null);
            DomInvocationHandler parent = DomSemContributor.getParentDom(parentTag);
            if (parent == null) {
                return null;
            }
            String localName = tag.getLocalName();
            String namespace = tag.getNamespace();
            DomFixedChildDescription description = (DomFixedChildDescription)DomSemContributor.findChildrenDescription(parent.getGenericInfo().getFixedChildrenDescriptions(), tag, parent);
            if (description != null) {
                int totalCount = description.getCount();
                int index = 0;
                XmlTag current = tag;
                while ((current = current.getPrevSibling()) != null) {
                    XmlTag xmlTag;
                    if (!(current instanceof XmlTag) || !localName.equals((xmlTag = current).getLocalName()) || !namespace.equals(xmlTag.getNamespace()) || ++index < totalCount) continue;
                    return null;
                }
                DomManagerImpl myDomManager = parent.getManager();
                return new IndexedElementInvocationHandler(parent.createEvaluatedXmlName(description.getXmlName()), (FixedChildDescriptionImpl)description, index, new PhysicalDomParentStrategy((XmlElement)tag, myDomManager), myDomManager, null);
            }
            return null;
        });
        registrar.registerSemElementProvider(DomManagerImpl.DOM_COLLECTION_HANDLER_KEY, (ElementPattern)nonRootTag, tag -> {
            XmlTag parentTag = PhysicalDomParentStrategy.getParentTag((XmlElement)tag);
            assert (parentTag != null);
            DomInvocationHandler parent = DomSemContributor.getParentDom(parentTag);
            if (parent == null) {
                return null;
            }
            DomCollectionChildDescription description = (DomCollectionChildDescription)DomSemContributor.findChildrenDescription(parent.getGenericInfo().getCollectionChildrenDescriptions(), tag, parent);
            if (description != null) {
                Object parentStub = parent.getStub();
                if (parentStub != null) {
                    int index = ArrayUtil.indexOf((Object[])parentTag.findSubTags(tag.getName(), tag.getNamespace()), (Object)tag);
                    ElementStub stub = ((DomStub)((Object)((Object)parentStub))).getElementStub(tag.getLocalName(), index);
                    if (stub != null) {
                        XmlName name = description.getXmlName();
                        EvaluatedXmlNameImpl evaluatedXmlName = EvaluatedXmlNameImpl.createEvaluatedXmlName((XmlName)name, (String)name.getNamespaceKey(), (boolean)true);
                        return new CollectionElementInvocationHandler((EvaluatedXmlName)evaluatedXmlName, (AbstractDomChildDescriptionImpl)description, parent.getManager(), stub);
                    }
                }
                return new CollectionElementInvocationHandler(description.getType(), (XmlTag)tag, (AbstractCollectionChildDescription)description, parent, null);
            }
            return null;
        });
        registrar.registerSemElementProvider(DomManagerImpl.DOM_CUSTOM_HANDLER_KEY, (ElementPattern)nonRootTag, tag -> {
            if (StringUtil.isEmpty((String)tag.getName())) {
                return null;
            }
            XmlTag parentTag = PhysicalDomParentStrategy.getParentTag((XmlElement)tag);
            assert (parentTag != null);
            DomInvocationHandler parent = (DomInvocationHandler)((Object)((Object)RecursionManager.doPreventingRecursion((Object)tag, (boolean)true, () -> DomSemContributor.getParentDom(parentTag))));
            if (parent == null) {
                return null;
            }
            DomGenericInfoEx info = parent.getGenericInfo();
            List customs = info.getCustomNameChildrenDescription();
            if (customs.isEmpty()) {
                return null;
            }
            if (semService.getSemElement(DomManagerImpl.DOM_INDEXED_HANDLER_KEY, (PsiElement)tag) == null && semService.getSemElement(DomManagerImpl.DOM_COLLECTION_HANDLER_KEY, (PsiElement)tag) == null) {
                String localName = tag.getLocalName();
                XmlFile file = parent.getFile();
                for (DomFixedChildDescription description : info.getFixedChildrenDescriptions()) {
                    XmlName xmlName = description.getXmlName();
                    if (!localName.equals(xmlName.getLocalName()) || !DomImplUtil.isNameSuitable(xmlName, tag, parent, file)) continue;
                    return null;
                }
                for (DomFixedChildDescription description : customs) {
                    if (description.getTagNameDescriptor() == null) continue;
                    AbstractCollectionChildDescription desc = (AbstractCollectionChildDescription)description;
                    Type type = description.getType();
                    return new CollectionElementInvocationHandler(type, (XmlTag)tag, desc, parent, null);
                }
            }
            return null;
        });
        registrar.registerSemElementProvider(DomManagerImpl.DOM_ATTRIBUTE_HANDLER_KEY, (ElementPattern)XmlPatterns.xmlAttribute(), DomSemContributor::createAttributeHandler);
    }

    @Nullable
    static DomInvocationHandler getParentDom(@NotNull XmlTag tag) {
        if (tag == null) {
            DomSemContributor.$$$reportNull$$$0(2);
        }
        LinkedHashSet<XmlTag> allParents = new LinkedHashSet<XmlTag>();
        XmlTag each = tag;
        while (each instanceof XmlTag && allParents.add(each)) {
            each = PhysicalDomParentStrategy.getParentTagCandidate((XmlElement)each);
        }
        ArrayList list = new ArrayList(allParents);
        Collections.reverse(list);
        DomManagerImpl manager = DomManagerImpl.getDomManager(tag.getProject());
        for (XmlTag xmlTag : list) {
            manager.getDomHandler((XmlElement)xmlTag);
        }
        return manager.getDomHandler((XmlElement)tag);
    }

    @Nullable
    private static <T extends DomChildrenDescription> T findChildrenDescription(List<T> descriptions, XmlTag tag, DomInvocationHandler parent) {
        String localName = tag.getLocalName();
        String namespace = null;
        String qName = tag.getName();
        XmlFile file = parent.getFile();
        int size = descriptions.size();
        for (int i = 0; i < size; ++i) {
            EvaluatedXmlName evaluatedXmlName;
            DomChildrenDescription description = (DomChildrenDescription)descriptions.get(i);
            XmlName xmlName = description.getXmlName();
            if (!localName.equals(xmlName.getLocalName()) && !qName.equals(xmlName.getLocalName()) || !DomImplUtil.isNameSuitable(evaluatedXmlName = parent.createEvaluatedXmlName(xmlName), localName, qName, namespace == null ? tag.getNamespace() : namespace, file)) continue;
            return (T)description;
        }
        return null;
    }

    @Nullable
    static AttributeChildInvocationHandler createAttributeHandler(@NotNull XmlAttribute attribute) {
        XmlTag tag;
        DomInvocationHandler handler;
        if (attribute == null) {
            DomSemContributor.$$$reportNull$$$0(3);
        }
        DomInvocationHandler domInvocationHandler = handler = (tag = PhysicalDomParentStrategy.getParentTag((XmlElement)attribute)) == null ? null : DomSemContributor.getParentDom(tag);
        if (handler == null) {
            return null;
        }
        String localName = attribute.getLocalName();
        Ref result = Ref.create(null);
        handler.getGenericInfo().processAttributeChildrenDescriptions((Processor<? super AttributeChildDescriptionImpl>)((Processor)description -> {
            EvaluatedXmlName evaluatedXmlName;
            String ns;
            if (description.getXmlName().getLocalName().equals(localName) && ((ns = (evaluatedXmlName = handler.createEvaluatedXmlName(description.getXmlName())).getNamespace((XmlElement)tag, handler.getFile())).equals(tag.getNamespace()) && localName.equals(attribute.getName()) || ns.equals(attribute.getNamespace()))) {
                DomManagerImpl manager = handler.getManager();
                result.set((Object)new AttributeChildInvocationHandler(evaluatedXmlName, (AttributeChildDescriptionImpl)description, manager, new PhysicalDomParentStrategy((XmlElement)attribute, manager), null));
                return false;
            }
            return true;
        }));
        return (AttributeChildInvocationHandler)((Object)result.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/xml/impl/DomSemContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerSemProviders";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentDom";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createAttributeHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

