/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterEditor;
import com.intellij.structuralsearch.plugin.ui.filters.FilterTable;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class TypeFilter
extends FilterAction {
    public TypeFilter(FilterTable filterTable) {
        super("Type", filterTable);
    }

    @Override
    public boolean hasFilter() {
        return !StringUtil.isEmpty((String)this.myTable.getConstraint().getNameOfExprType());
    }

    @Override
    public void clearFilter() {
        MatchVariableConstraint constraint = this.myTable.getConstraint();
        constraint.setNameOfExprType("");
        constraint.setInvertExprType(false);
        constraint.setExprTypeWithinHierarchy(false);
    }

    @Override
    public boolean isApplicable(List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        return this.myTable.getProfile().isApplicableConstraint("TYPE", nodes, completePattern, target);
    }

    @Override
    protected void setLabel(SimpleColoredComponent component) {
        MatchVariableConstraint constraint = this.myTable.getConstraint();
        this.myLabel.append("type=");
        if (constraint.isInvertExprType()) {
            this.myLabel.append("!");
        }
        this.myLabel.append(constraint.getNameOfExprType());
        if (constraint.isExprTypeWithinHierarchy()) {
            this.myLabel.append(", within hierarchy", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    @Override
    public FilterEditor getEditor() {
        return new FilterEditor(this.myTable.getConstraint(), this.myTable.getConstraintChangedCallback()){
            private final EditorTextField myTextField;
            private final JLabel myTypeLabel;
            private final JCheckBox myHierarchyCheckBox;
            private final ContextHelpLabel myHelpLabel;
            {
                this.myTextField = UIUtil.createTextComponent("", TypeFilter.this.myTable.getProject());
                this.myTypeLabel = new JLabel("type=");
                this.myHierarchyCheckBox = new JCheckBox("Within type hierarchy", false);
                this.myHelpLabel = ContextHelpLabel.create((String)"<p>The type of the matched expression is checked against the provided \"|\"-separated patterns. <p>Use \"!\" to invert the pattern.");
            }

            @Override
            protected void layoutComponents() {
                GroupLayout layout = new GroupLayout((Container)((Object)this));
                this.setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.myTypeLabel).addComponent((Component)this.myTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1).addComponent((Component)this.myHelpLabel)).addComponent(this.myHierarchyCheckBox));
                layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myTypeLabel).addComponent((Component)this.myTextField).addComponent((Component)this.myHelpLabel)).addComponent(this.myHierarchyCheckBox));
            }

            @Override
            protected void loadValues() {
                this.myTextField.setText((this.myConstraint.isInvertExprType() ? "!" : "") + this.myConstraint.getNameOfExprType());
                this.myHierarchyCheckBox.setSelected(this.myConstraint.isExprTypeWithinHierarchy());
            }

            @Override
            public void saveValues() {
                String text = this.myTextField.getText();
                if (text.startsWith("!")) {
                    this.myConstraint.setNameOfExprType(text.substring(1));
                    this.myConstraint.setInvertExprType(true);
                } else {
                    this.myConstraint.setNameOfExprType(text);
                    this.myConstraint.setInvertExprType(false);
                }
                this.myConstraint.setExprTypeWithinHierarchy(this.myHierarchyCheckBox.isSelected());
            }

            public JComponent getPreferredFocusedComponent() {
                return this.myTextField;
            }

            public JComponent[] getFocusableComponents() {
                return new JComponent[]{this.myTextField};
            }
        };
    }
}

