/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterEditor;
import com.intellij.structuralsearch.plugin.ui.filters.FilterTable;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.fields.ExpandableSupport;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.jetbrains.annotations.NotNull;

public class ScriptFilter
extends FilterAction {
    public ScriptFilter(FilterTable filterTable) {
        super("Script", filterTable);
    }

    @Override
    public boolean hasFilter() {
        return !StringUtil.isEmpty((String)this.myTable.getConstraint().getScriptCodeConstraint());
    }

    @Override
    public void clearFilter() {
        this.myTable.getConstraint().setScriptCodeConstraint("");
    }

    @Override
    public boolean isApplicable(List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        return true;
    }

    @Override
    protected void setLabel(SimpleColoredComponent component) {
        component.append("script=").append(StringUtil.unquoteString((String)this.myTable.getConstraint().getScriptCodeConstraint()));
    }

    @Override
    public FilterEditor getEditor() {
        return new FilterEditor(this.myTable.getConstraint(), this.myTable.getConstraintChangedCallback()){
            private final JLabel myLabel;
            private final EditorTextField myTextField;
            private ContextHelpLabel myHelpLabel;
            {
                this.myLabel = new JLabel("script=");
                this.myTextField = UIUtil.createScriptComponent("", ScriptFilter.this.myTable.getProject());
            }

            @Override
            protected void layoutComponents() {
                new ExpandableEditorSupport(this.myTextField){

                    @NotNull
                    protected ExpandableSupport.Content prepare(@NotNull EditorTextField field, @NotNull Function<? super String, String> onShow) {
                        if (field == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (onShow == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        ExpandableSupport.Content popup = super.prepare(field, onShow);
                        popup.getContentComponent().setPreferredSize(new Dimension(600, 150));
                        ExpandableSupport.Content content = popup;
                        if (content == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return content;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 2: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 2: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "field";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "onShow";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/filters/ScriptFilter$1$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/filters/ScriptFilter$1$1";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "prepare";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "prepare";
                                break;
                            }
                            case 2: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 2: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                CharSequence[] variableNames = new String[]{"__context__", "__log__"};
                this.myHelpLabel = ContextHelpLabel.create((String)("<p>Use GroovyScript IntelliJ API to filter the search results.<p>Available variables: " + String.join((CharSequence)", ", variableNames)));
                GroupLayout layout = new GroupLayout((Container)((Object)this));
                this.setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.myLabel).addComponent((Component)this.myTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1).addComponent((Component)this.myHelpLabel));
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myLabel).addComponent((Component)this.myTextField).addComponent((Component)this.myHelpLabel));
            }

            @Override
            protected void loadValues() {
                this.myTextField.setText(StringUtil.unquoteString((String)this.myConstraint.getScriptCodeConstraint()));
            }

            @Override
            protected void saveValues() {
                this.myConstraint.setScriptCodeConstraint('\"' + this.myTextField.getText() + '\"');
            }

            public JComponent getPreferredFocusedComponent() {
                return this.myTextField;
            }

            public JComponent[] getFocusableComponents() {
                return new JComponent[]{this.myTextField};
            }
        };
    }
}

