/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.plugin.ui.filters.CountFilter;
import com.intellij.structuralsearch.plugin.ui.filters.Filter;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterTable;
import com.intellij.structuralsearch.plugin.ui.filters.ReferenceFilter;
import com.intellij.structuralsearch.plugin.ui.filters.ScriptFilter;
import com.intellij.structuralsearch.plugin.ui.filters.TextFilter;
import com.intellij.structuralsearch.plugin.ui.filters.TypeFilter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.SmartList;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterPanel
implements FilterTable {
    private final JPanel myFilterPanel;
    final JBListTable myFilterTable;
    final ListTableModel<Filter> myTableModel;
    @NotNull
    final Project myProject;
    private CompiledPattern myCompiledPattern;
    MatchVariableConstraint myConstraint;
    StructuralSearchProfile myProfile;
    final Header myHeader;
    private final List<FilterAction> myFilters;
    private Runnable myConstraintChangedCallback;
    boolean myValid;

    public FilterPanel(@NotNull Project project2, StructuralSearchProfile profile2, Disposable parent) {
        if (project2 == null) {
            FilterPanel.$$$reportNull$$$0(0);
        }
        this.myHeader = new Header();
        this.myFilters = Arrays.asList(new TextFilter(this), new CountFilter(this), new TypeFilter(this), new ReferenceFilter(this), new ScriptFilter(this));
        this.myProject = project2;
        this.myProfile = profile2;
        this.myTableModel = new ListTableModel(new ColumnInfo[]{new ColumnInfo<Filter, Filter>(""){

            @Nullable
            public Filter valueOf(Filter s) {
                return s;
            }
        }}, (List)new SmartList());
        this.myFilterTable = new JBListTable((JTable)new TableView(this.myTableModel), parent){

            protected JBTableRowRenderer getRowRenderer(int row) {
                return (table, row1, selected, focused) -> ((Filter)FilterPanel.this.myTableModel.getRowValue(row1)).getRenderer();
            }

            protected JBTableRowEditor getRowEditor(int row) {
                if (!FilterPanel.this.myValid) {
                    return null;
                }
                return ((Filter)FilterPanel.this.myTableModel.getRowValue(row)).getEditor();
            }
        };
        JBTable table = this.myFilterTable.getTable();
        table.setTableHeader(new JTableHeader());
        table.setStriped(false);
        this.myFilterPanel = ToolbarDecorator.createDecorator((JTable)table).disableUpDownActions().setToolbarPosition(ActionToolbarPosition.RIGHT).setAddAction(button -> {
            RelativePoint point = button.getPreferredPopupPoint();
            if (point == null) {
                return;
            }
            this.showAddFilterPopup(button.getContextComponent(), point);
        }).setAddActionUpdater(e -> this.myValid).setRemoveAction(button -> {
            this.myFilterTable.stopEditing();
            int selectedRow = this.myFilterTable.getTable().getSelectedRow();
            Filter filter = (Filter)this.myTableModel.getRowValue(selectedRow);
            if (filter instanceof FilterAction) {
                this.removeFilter((FilterAction)filter);
            }
        }).setRemoveActionUpdater(e -> this.myValid && this.myFilterTable.getTable().getSelectedRow() != 0).setPanelBorder(null).createPanel();
        this.myFilterPanel.setPreferredSize(new Dimension(350, 60));
        this.myFilterPanel.setBorder(BorderFactory.createCompoundBorder((Border)JBUI.Borders.empty((int)3, (int)0), this.myFilterPanel.getBorder()));
    }

    @Override
    public void addFilter(FilterAction filter) {
        int index;
        filter.getTemplatePresentation().setEnabledAndVisible(false);
        JBTable table = this.myFilterTable.getTable();
        TableUtil.stopEditing((JTable)table);
        table.setRowHeight(table.getRowHeight());
        int max = this.myTableModel.getRowCount();
        for (index = 0; index < max && filter.position() >= ((Filter)this.myTableModel.getItem(index)).position(); ++index) {
        }
        if (index == 0) {
            this.myTableModel.addRow((Object)this.myHeader);
            index = 1;
        }
        this.myTableModel.insertRow(index, (Object)filter);
        table.editCellAt(index, 0);
        table.setRowSelectionInterval(index, index);
        table.setColumnSelectionInterval(0, 0);
        TableUtil.updateScroller((JTable)table);
        Component editorComponent = table.getEditorComponent();
        if (editorComponent != null) {
            table.scrollRectToVisible(editorComponent.getBounds());
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(editorComponent, true));
        }
    }

    public final void addFilterIfPresent(FilterAction filter) {
        if (filter.hasFilter()) {
            filter.getTemplatePresentation().setEnabledAndVisible(false);
            if (this.myTableModel.getRowCount() == 0) {
                this.myTableModel.addRow((Object)this.myHeader);
            }
            this.myTableModel.addRow((Object)filter);
        } else {
            filter.getTemplatePresentation().setEnabledAndVisible(true);
        }
    }

    public final void initFilter(FilterAction filter, List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        if (filter.isApplicable(nodes, completePattern, target) && !this.myTableModel.getItems().contains(filter)) {
            this.addFilterIfPresent(filter);
        } else {
            filter.clearFilter();
            filter.getTemplatePresentation().setEnabledAndVisible(false);
        }
    }

    @Override
    public final void removeFilter(FilterAction filter) {
        int index = this.myTableModel.indexOf((Object)filter);
        if (index >= 0) {
            this.myTableModel.removeRow(index);
        }
        if (this.myTableModel.getRowCount() == 1) {
            this.myTableModel.removeRow(0);
        }
        filter.getTemplatePresentation().setEnabledAndVisible(true);
        filter.clearFilter();
        this.myConstraintChangedCallback.run();
    }

    @Override
    public MatchVariableConstraint getConstraint() {
        return this.myConstraint;
    }

    @Override
    @NotNull
    public StructuralSearchProfile getProfile() {
        StructuralSearchProfile structuralSearchProfile = this.myProfile;
        if (structuralSearchProfile == null) {
            FilterPanel.$$$reportNull$$$0(1);
        }
        return structuralSearchProfile;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            FilterPanel.$$$reportNull$$$0(2);
        }
        return project2;
    }

    void showAddFilterPopup(Component component, RelativePoint point) {
        this.myFilterTable.getTable().requestFocus();
        DefaultActionGroup group = new DefaultActionGroup(this.myFilters);
        DataContext context = DataManager.getInstance().getDataContext(component);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Add Filter", (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, true, null);
        popup.show(point);
    }

    public JComponent getComponent() {
        return this.myFilterPanel;
    }

    public void setProfile(@NotNull StructuralSearchProfile profile2) {
        if (profile2 == null) {
            FilterPanel.$$$reportNull$$$0(3);
        }
        this.myProfile = profile2;
    }

    public void setCompiledPattern(@NotNull CompiledPattern compiledPattern) {
        if (compiledPattern == null) {
            FilterPanel.$$$reportNull$$$0(4);
        }
        this.myCompiledPattern = compiledPattern;
    }

    public void setValid(boolean valid) {
        this.myValid = valid;
        this.initFilters(this.myConstraint);
    }

    public boolean isInitialized() {
        return this.myConstraint != null;
    }

    public void initFilters(@NotNull MatchVariableConstraint constraint) {
        if (constraint == null) {
            FilterPanel.$$$reportNull$$$0(5);
        }
        if (this.myCompiledPattern == null) {
            return;
        }
        this.myConstraint = constraint;
        String varName = this.myConstraint.getName();
        List<PsiElement> nodes = this.myCompiledPattern.getVariableNodes(varName);
        boolean completePattern = "__context__".equals(varName);
        boolean target = this.myConstraint.isPartOfSearchResults();
        this.myTableModel.setItems((List)new SmartList());
        ReadAction.run(() -> {
            for (FilterAction filter : this.myFilters) {
                this.initFilter(filter, nodes, completePattern, target);
            }
        });
        String message = "__context__".equals(varName) ? "No filters added for the complete match." : "No Filters added for $" + varName + "$.";
        StatusText statusText = this.myFilterTable.getTable().getEmptyText();
        statusText.setText(message);
        if (this.myValid) {
            statusText.appendSecondaryText("Add filter", SimpleTextAttributes.LINK_ATTRIBUTES, e -> {
                JBTable table = this.myFilterTable.getTable();
                this.showAddFilterPopup((Component)table, new RelativePoint((Component)table, table.getMousePosition()));
            });
        }
    }

    public void setConstraintChangedCallback(Runnable callback) {
        this.myConstraintChangedCallback = callback;
    }

    @Override
    public Runnable getConstraintChangedCallback() {
        return this.myConstraintChangedCallback;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/filters/FilterPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiledPattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/filters/FilterPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setProfile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCompiledPattern";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initFilters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Header
    implements Filter {
        private final SimpleColoredComponent myLabel = new SimpleColoredComponent();

        Header() {
        }

        @Override
        public int position() {
            return 0;
        }

        public SimpleColoredComponent getRenderer() {
            this.myLabel.clear();
            String varName = FilterPanel.this.myConstraint.getName();
            this.myLabel.append("__context__".equals(varName) ? "Filters for the Complete Match:" : "Filters for $" + varName + "$:", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            return this.myLabel;
        }
    }
}

