/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.StructuralReplaceAction;
import com.intellij.structuralsearch.plugin.StructuralSearchAction;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TooltipWithClickableLinks;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIUtil {
    private static final String MODIFY_EDITOR_CONTENT = SSRBundle.message("modify.editor.content.command.name", new Object[0]);
    @NonNls
    private static final String SS_GROUP = "structuralsearchgroup";
    public static final NotificationGroup SSR_NOTIFICATION_GROUP = new NotificationGroup(SSRBundle.message("structural.search.title", new Object[0]), NotificationDisplayType.STICKY_BALLOON, true, ToolWindowId.FIND);
    @NonNls
    public static final String TEXT = "TEXT";
    @NonNls
    public static final String TEXT_HIERARCHY = "TEXT HIERARCHY";
    @NonNls
    public static final String REFERENCE = "REFERENCE";
    @NonNls
    public static final String TYPE = "TYPE";
    @NonNls
    public static final String EXPECTED_TYPE = "EXPECTED TYPE";
    @NonNls
    public static final String MINIMUM_ZERO = "MINIMUM ZERO";
    @NonNls
    public static final String MAXIMUM_UNLIMITED = "MAXIMUM UNLIMITED";

    private UIUtil() {
    }

    @NotNull
    public static Editor createEditor(Document doc, Project project2, boolean editable, @Nullable TemplateContextType contextType) {
        Editor editor = UIUtil.createEditor(doc, project2, editable, false, contextType);
        if (editor == null) {
            UIUtil.$$$reportNull$$$0(0);
        }
        return editor;
    }

    @NotNull
    public static Editor createEditor(@NotNull Document doc, Project project2, boolean editable, boolean addToolTipForVariableHandler, @Nullable TemplateContextType contextType) {
        if (doc == null) {
            UIUtil.$$$reportNull$$$0(1);
        }
        Editor editor = editable ? EditorFactory.getInstance().createEditor(doc, project2) : EditorFactory.getInstance().createViewer(doc, project2);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setCaretRowShown(false);
        if (!editable) {
            EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color c = globalScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            if (c == null) {
                c = globalScheme.getDefaultBackground();
            }
            ((EditorEx)editor).setBackgroundColor(c);
        } else {
            ((EditorEx)editor).setEmbeddedIntoDialogWrapper(true);
        }
        TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)contextType);
        if (addToolTipForVariableHandler) {
            SubstitutionShortInfoHandler.install(editor, null);
        }
        Editor editor2 = editor;
        if (editor2 == null) {
            UIUtil.$$$reportNull$$$0(2);
        }
        return editor2;
    }

    public static JComponent createOptionLine(JComponent ... options) {
        JPanel tmp = new JPanel();
        tmp.setLayout(new BoxLayout(tmp, 0));
        for (int i = 0; i < options.length; ++i) {
            if (i != 0) {
                tmp.add(Box.createHorizontalStrut(10));
            }
            tmp.add(options[i]);
        }
        tmp.add(Box.createHorizontalGlue());
        return tmp;
    }

    public static void setContent(@NotNull Editor editor, String text) {
        if (editor == null) {
            UIUtil.$$$reportNull$$$0(3);
        }
        String value = text != null ? text : "";
        Document document = editor.getDocument();
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (String)MODIFY_EDITOR_CONTENT, (String)SS_GROUP, () -> document.replaceString(0, document.getTextLength(), (CharSequence)value), (PsiFile[])new PsiFile[0]);
    }

    public static void setContent(@NotNull EditorTextField editor, String text) {
        if (editor == null) {
            UIUtil.$$$reportNull$$$0(4);
        }
        String value = text != null ? text : "";
        Document document = editor.getDocument();
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (String)MODIFY_EDITOR_CONTENT, (String)SS_GROUP, () -> document.replaceString(0, document.getTextLength(), (CharSequence)value), (PsiFile[])new PsiFile[0]);
    }

    public static void invokeAction(Configuration config, SearchContext context) {
        if (config instanceof SearchConfiguration) {
            StructuralSearchAction.triggerAction(config, context);
        } else {
            StructuralReplaceAction.triggerAction(config, context);
        }
    }

    public static MatchVariableConstraint getOrAddVariableConstraint(String varName, Configuration configuration) {
        MatchVariableConstraint varInfo = configuration.getMatchOptions().getVariableConstraint(varName);
        if (varInfo == null) {
            varInfo = new MatchVariableConstraint();
            varInfo.setName(varName);
            configuration.getMatchOptions().addVariableConstraint(varInfo);
        }
        return varInfo;
    }

    public static boolean isTarget(String varName, MatchOptions matchOptions) {
        if ("__context__".equals(varName)) {
            for (String name : matchOptions.getVariableConstraintNames()) {
                if (name.equals("__context__") || !matchOptions.getVariableConstraint(name).isPartOfSearchResults()) continue;
                return false;
            }
            return true;
        }
        MatchVariableConstraint constraint = matchOptions.getVariableConstraint(varName);
        if (constraint == null) {
            return false;
        }
        return constraint.isPartOfSearchResults();
    }

    @NotNull
    public static JComponent createCompleteMatchInfo(Supplier<? extends Configuration> configurationProducer) {
        JComponent jComponent = UIUtil.installCompleteMatchInfo(new JLabel(AllIcons.Actions.ListFiles), configurationProducer, null);
        if (jComponent == null) {
            UIUtil.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    @NotNull
    public static JComponent installCompleteMatchInfo(final JLabel completeMatchInfo, final Supplier<? extends Configuration> configurationProducer, final Consumer<? super String> linkConsumer) {
        completeMatchInfo.putClientProperty(IdeTooltip.TOOLTIP_DISMISS_DELAY_KEY, 20000);
        completeMatchInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent ignore) {
                if (Registry.is((String)"ssr.use.editor.inlays.instead.of.tool.tips") && Registry.is((String)"ssr.use.new.search.dialog")) {
                    return;
                }
                Configuration configuration = (Configuration)configurationProducer.get();
                if (configuration == null) {
                    return;
                }
                MatchOptions matchOptions = configuration.getMatchOptions();
                if (matchOptions.getSearchPattern().isEmpty()) {
                    return;
                }
                MatchVariableConstraint constraint = UIUtil.getOrAddVariableConstraint("__context__", configuration);
                if (UIUtil.isTarget("__context__", matchOptions)) {
                    constraint.setPartOfSearchResults(true);
                }
                String filterText = StringUtil.escapeXmlEntities((String)SSRBundle.message("complete.match.variable.tooltip.message", SubstitutionShortInfoHandler.getShortParamString(constraint, linkConsumer == null)));
                if (linkConsumer != null && !"__context__".equals(configuration.getCurrentVariableName())) {
                    filterText = SubstitutionShortInfoHandler.appendLinkText(filterText, "__context__");
                }
                HyperlinkListener listener = e -> {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && linkConsumer != null) {
                        linkConsumer.accept("__context__");
                        IdeTooltipManager.getInstance().hideCurrentNow(true);
                    }
                };
                TooltipWithClickableLinks tooltip = new TooltipWithClickableLinks((JComponent)completeMatchInfo, filterText, listener);
                Rectangle bounds = completeMatchInfo.getBounds();
                tooltip.setHint(true).setExplicitClose(true).setPreferredPosition(Balloon.Position.below).setPoint(new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height));
                IdeTooltipManager.getInstance().show((IdeTooltip)tooltip, true);
                if (linkConsumer == null) {
                    configuration.setCurrentVariableName("__context__");
                }
            }
        });
        JLabel jLabel = completeMatchInfo;
        if (jLabel == null) {
            UIUtil.$$$reportNull$$$0(6);
        }
        return jLabel;
    }

    public static EditorTextField createTextComponent(String text, Project project2) {
        return UIUtil.createEditorComponent(text, "1.txt", project2);
    }

    public static EditorTextField createRegexComponent(String text, Project project2) {
        return UIUtil.createEditorComponent(text, "1.regexp", project2);
    }

    public static EditorTextField createScriptComponent(String text, Project project2) {
        return UIUtil.createEditorComponent(text, "1.groovy", project2);
    }

    @NotNull
    public static EditorTextField createEditorComponent(String text, String fileName, Project project2) {
        EditorTextField editorTextField = new EditorTextField(text, project2, UIUtil.getFileType(fileName));
        if (editorTextField == null) {
            UIUtil.$$$reportNull$$$0(7);
        }
        return editorTextField;
    }

    private static FileType getFileType(String fileName) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (fileType == FileTypes.UNKNOWN) {
            fileType = FileTypes.PLAIN_TEXT;
        }
        return fileType;
    }

    public static LanguageFileType detectFileType(@NotNull SearchContext searchContext) {
        Language language;
        StructuralSearchProfile profile2;
        if (searchContext == null) {
            UIUtil.$$$reportNull$$$0(8);
        }
        PsiFile file = searchContext.getFile();
        PsiElement context = null;
        Editor editor = searchContext.getEditor();
        if (editor != null && file != null) {
            int offset = editor.getCaretModel().getOffset();
            context = InjectedLanguageManager.getInstance((Project)searchContext.getProject()).findInjectedElementAt(file, offset);
            if (context == null) {
                context = file.findElementAt(offset);
            }
            if (context != null) {
                context = context.getParent();
            }
            if (context == null) {
                context = file;
            }
        }
        if (context != null && (profile2 = StructuralSearchUtil.getProfileByLanguage(language = context.getLanguage())) != null) {
            LanguageFileType fileType = profile2.detectFileType(context);
            return fileType != null ? fileType : language.getAssociatedFileType();
        }
        return StructuralSearchUtil.getDefaultFileType();
    }

    @NotNull
    public static Document createDocument(@NotNull Project project2, @NotNull LanguageFileType fileType, Language dialect, PatternContext patternContext, @NotNull String text, @NotNull StructuralSearchProfile profile2) {
        String contextId;
        PsiCodeFragment codeFragment;
        if (project2 == null) {
            UIUtil.$$$reportNull$$$0(9);
        }
        if (fileType == null) {
            UIUtil.$$$reportNull$$$0(10);
        }
        if (text == null) {
            UIUtil.$$$reportNull$$$0(11);
        }
        if (profile2 == null) {
            UIUtil.$$$reportNull$$$0(12);
        }
        if ((codeFragment = profile2.createCodeFragment(project2, text, contextId = patternContext == null ? null : patternContext.getId())) == null) {
            codeFragment = UIUtil.createFileFragment(project2, fileType, dialect, text);
        }
        if (codeFragment != null) {
            Document doc = PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)codeFragment);
            assert (doc != null) : "code fragment element should be physical";
            Document document = doc;
            if (document == null) {
                UIUtil.$$$reportNull$$$0(13);
            }
            return document;
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text);
        if (document == null) {
            UIUtil.$$$reportNull$$$0(14);
        }
        return document;
    }

    @NotNull
    public static Editor createEditor(@NotNull Project project2, @NotNull LanguageFileType fileType, Language dialect, @NotNull String text, @NotNull StructuralSearchProfile profile2) {
        PsiCodeFragment codeFragment;
        if (project2 == null) {
            UIUtil.$$$reportNull$$$0(15);
        }
        if (fileType == null) {
            UIUtil.$$$reportNull$$$0(16);
        }
        if (text == null) {
            UIUtil.$$$reportNull$$$0(17);
        }
        if (profile2 == null) {
            UIUtil.$$$reportNull$$$0(18);
        }
        if ((codeFragment = profile2.createCodeFragment(project2, text, null)) == null) {
            codeFragment = UIUtil.createFileFragment(project2, fileType, dialect, text);
        }
        if (codeFragment != null) {
            Document doc = PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)codeFragment);
            assert (doc != null) : "code fragment element should be physical";
            DaemonCodeAnalyzer.getInstance((Project)project2).setHighlightingEnabled((PsiFile)codeFragment, false);
            Editor editor = UIUtil.createEditor(doc, project2, true, true, UIUtil.getTemplateContextType(profile2));
            if (editor == null) {
                UIUtil.$$$reportNull$$$0(19);
            }
            return editor;
        }
        EditorFactory factory = EditorFactory.getInstance();
        Document document = factory.createDocument((CharSequence)text);
        EditorEx editor = (EditorEx)factory.createEditor(document, project2);
        editor.getSettings().setFoldingOutlineShown(false);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            UIUtil.$$$reportNull$$$0(20);
        }
        return editorEx;
    }

    private static PsiFile createFileFragment(@NotNull Project project2, @NotNull LanguageFileType fileType, Language dialect, @NotNull String text) {
        if (project2 == null) {
            UIUtil.$$$reportNull$$$0(21);
        }
        if (fileType == null) {
            UIUtil.$$$reportNull$$$0(22);
        }
        if (text == null) {
            UIUtil.$$$reportNull$$$0(23);
        }
        String name = "__dummy." + fileType.getDefaultExtension();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project2);
        return dialect == null ? factory.createFileFromText(name, (FileType)fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true, true) : factory.createFileFromText(name, dialect, (CharSequence)text, true, true);
    }

    public static TemplateContextType getTemplateContextType(StructuralSearchProfile profile2) {
        Class<? extends TemplateContextType> clazz = profile2.getTemplateContextTypeClass();
        return (TemplateContextType)ContainerUtil.findInstance((Object[])TemplateContextType.EP_NAME.getExtensions(), clazz);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/UIUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 9: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 11: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/UIUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompleteMatchInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "installCompleteMatchInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorComponent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "detectFileType";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createFileFragment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

