/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchTemplateBuilder;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceCommand;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.ConfigurationUtil;
import com.intellij.structuralsearch.plugin.ui.FileTypeInfo;
import com.intellij.structuralsearch.plugin.ui.FileTypeSelector;
import com.intellij.structuralsearch.plugin.ui.LinkComboBox;
import com.intellij.structuralsearch.plugin.ui.ScopePanel;
import com.intellij.structuralsearch.plugin.ui.SearchCommand;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SelectTemplateDialog;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterPanel;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.NullableConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.textCompletion.TextCompletionUtil;
import com.intellij.util.ui.TextTransferable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchDialog
extends DialogWrapper {
    @NonNls
    private static final String SEARCH_DIMENSION_SERVICE_KEY = "#com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog";
    @NonNls
    private static final String REPLACE_DIMENSION_SERVICE_KEY = "#com.intellij.structuralsearch.plugin.ui.StructuralReplaceDialog";
    @NonNls
    private static final String RECURSIVE_STATE = "structural.search.recursive";
    @NonNls
    private static final String MATCH_CASE_STATE = "structural.search.match.case";
    @NonNls
    private static final String SHORTEN_FQN_STATE = "structural.search.shorten.fqn";
    @NonNls
    private static final String REFORMAT_STATE = "structural.search.reformat";
    @NonNls
    private static final String USE_STATIC_IMPORT_STATE = "structural.search.use.static.import";
    @NonNls
    private static final String FILTERS_VISIBLE_STATE = "structural.search.filters.visible";
    public static final Key<StructuralSearchDialog> STRUCTURAL_SEARCH_DIALOG = Key.create((String)"STRUCTURAL_SEARCH_DIALOG");
    public static final Key<String> STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID = Key.create((String)"STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID");
    public static final String USER_DEFINED = SSRBundle.message("new.template.defaultname", new Object[0]);
    private final SearchContext mySearchContext;
    Editor myEditor;
    boolean myReplace;
    Configuration myConfiguration;
    @NonNls
    LanguageFileType myFileType;
    Language myDialect;
    PatternContext myPatternContext;
    final List<RangeHighlighter> myRangeHighlighters;
    private final Alarm myAlarm;
    private boolean myUseLastConfiguration;
    private final boolean myEditConfigOnly;
    private boolean myDoingOkAction;
    JCheckBox myRecursive;
    private JCheckBox myMatchCase;
    private JCheckBox myShortenFQN;
    private JCheckBox myReformat;
    private JCheckBox myUseStaticImport;
    FileTypeSelector myFileTypesComboBox;
    ActionToolbarImpl myOptionsToolbar;
    EditorTextField mySearchCriteriaEdit;
    EditorTextField myReplaceCriteriaEdit;
    OnePixelSplitter mySearchEditorPanel;
    private OnePixelSplitter myReplaceEditorPanel;
    FilterPanel myFilterPanel;
    private LinkComboBox myTargetComboBox;
    private ScopePanel myScopePanel;
    private JCheckBox myOpenInNewTab;
    JComponent myReplacePanel;
    Balloon myBalloon;

    public StructuralSearchDialog(SearchContext searchContext, boolean replace) {
        this(searchContext, replace, false);
    }

    public StructuralSearchDialog(@NotNull SearchContext searchContext, boolean replace, boolean editConfigOnly) {
        if (searchContext == null) {
            StructuralSearchDialog.$$$reportNull$$$0(0);
        }
        super(searchContext.getProject(), true);
        this.myFileType = StructuralSearchUtil.getDefaultFileType();
        this.myDialect = null;
        this.myPatternContext = null;
        this.myRangeHighlighters = new SmartList();
        this.myBalloon = null;
        if (!editConfigOnly) {
            this.setModal(false);
            this.setOKButtonText(FindBundle.message((String)"find.dialog.find.button", (Object[])new Object[0]));
        }
        this.myReplace = replace;
        this.myEditConfigOnly = editConfigOnly;
        this.mySearchContext = searchContext;
        this.myEditor = searchContext.getEditor();
        FileEditorManagerListener listener = new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (StructuralSearchDialog.this.myRangeHighlighters.isEmpty()) {
                    return;
                }
                StructuralSearchDialog.this.removeMatchHighlights();
                StructuralSearchDialog.this.myEditor = event.getManager().getSelectedTextEditor();
                StructuralSearchDialog.this.addMatchHighlights();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$1", "selectionChanged"));
            }
        };
        searchContext.getProject().getMessageBus().connect(this.getDisposable()).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener);
        this.myConfiguration = this.createConfiguration(null);
        this.setTitle(this.getDefaultTitle());
        this.init();
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        ProjectManager.getInstance().addProjectManagerListener(searchContext.getProject(), new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                StructuralSearchDialog.this.close(1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$2", "projectClosing"));
            }
        });
    }

    public void setUseLastConfiguration(boolean useLastConfiguration) {
        this.myUseLastConfiguration = useLastConfiguration;
    }

    private EditorTextField createEditor() {
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        assert (profile2 != null);
        Document document = UIUtil.createDocument(this.getProject(), this.myFileType, this.myDialect, this.myPatternContext, "", profile2);
        document.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)(this.myPatternContext == null ? "" : this.myPatternContext.getId()));
        EditorTextField textField = new EditorTextField(document, this.getProject(), (FileType)this.myFileType, false, false){

            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.setHorizontalScrollbarVisible(true);
                editor.setVerticalScrollbarVisible(true);
                StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
                assert (profile2 != null);
                TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)UIUtil.getTemplateContextType(profile2));
                SubstitutionShortInfoHandler.install((Editor)editor, variableName -> {
                    StructuralSearchDialog.this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(variableName, StructuralSearchDialog.this.myConfiguration));
                    if (StructuralSearchDialog.this.isFilterPanelVisible()) {
                        StructuralSearchDialog.this.myConfiguration.setCurrentVariableName((String)variableName);
                    }
                });
                editor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)StructuralSearchDialog.this.myConfiguration);
                if (profile2.highlightProblemsInEditor()) {
                    profile2.setProblemCallback(() -> {
                        StructuralSearchDialog.this.mySearchCriteriaEdit.putClientProperty((Object)"JComponent.outline", (Object)"error");
                        StructuralSearchDialog.this.mySearchCriteriaEdit.repaint();
                        StructuralSearchDialog.this.getOKAction().setEnabled(false);
                        StructuralSearchDialog.this.removeMatchHighlights();
                    });
                } else {
                    Project project2 = this.getProject();
                    PsiFile file = PsiDocumentManager.getInstance((Project)project2).getPsiFile(this.getDocument());
                    if (file != null) {
                        DaemonCodeAnalyzer.getInstance((Project)project2).setHighlightingEnabled(file, false);
                    }
                }
                TextCompletionUtil.installCompletionHint((EditorEx)editor);
                editor.putUserData(STRUCTURAL_SEARCH_DIALOG, (Object)StructuralSearchDialog.this);
                editor.setEmbeddedIntoDialogWrapper(true);
                return editor;
            }

            protected void updateBorder(@NotNull EditorEx editor) {
                if (editor == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.setupBorder(editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$3", "updateBorder"));
            }
        };
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        textField.setFont(scheme.getFont(EditorFontType.PLAIN));
        textField.setPreferredSize(new Dimension(550, 150));
        textField.setMinimumSize(new Dimension(200, 50));
        textField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                StructuralSearchDialog.this.initiateValidation();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$4", "documentChanged"));
            }
        });
        return textField;
    }

    void initiateValidation() {
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            boolean success = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                try {
                    CompiledPattern compiledPattern = this.compilePattern();
                    JRootPane component = this.getRootPane();
                    if (component == null) {
                        return;
                    }
                    this.initializeFilterPanel();
                    if (compiledPattern != null) {
                        this.addMatchHighlights();
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        this.setSearchTargets(this.myConfiguration.getMatchOptions());
                        this.getOKAction().setEnabled(compiledPattern != null);
                    }, ModalityState.stateForComponent((Component)component));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    Logger.getInstance(StructuralSearchDialog.class).error((Throwable)e);
                }
            });
            if (!success) {
                this.initiateValidation();
            }
        }, 100);
    }

    private void initializeFilterPanel() {
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        CompiledPattern compiledPattern = PatternCompiler.compilePattern(this.getProject(), matchOptions, false, false);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (compiledPattern != null) {
                SubstitutionShortInfoHandler handler = SubstitutionShortInfoHandler.retrieve(this.mySearchCriteriaEdit.getEditor());
                if (handler != null) {
                    handler.updateEditorInlays();
                }
                this.myFilterPanel.setCompiledPattern(compiledPattern);
            }
            if (!this.myFilterPanel.isInitialized()) {
                this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
            }
            this.myFilterPanel.setValid(compiledPattern != null);
        }, ModalityState.stateForComponent((Component)this.myFilterPanel.getComponent()));
    }

    private Configuration createConfiguration(Configuration template) {
        if (this.myReplace) {
            return template == null ? new ReplaceConfiguration(USER_DEFINED, USER_DEFINED) : new ReplaceConfiguration(template);
        }
        return template == null ? new SearchConfiguration(USER_DEFINED, USER_DEFINED) : new SearchConfiguration(template);
    }

    private void setTextFromContext() {
        SelectionModel selectionModel;
        String selectedText;
        Editor editor = this.myEditor;
        if (editor != null && (selectedText = (selectionModel = editor.getSelectionModel()).getSelectedText()) != null) {
            if (this.loadConfiguration(selectedText)) {
                return;
            }
            String text = selectedText.trim();
            this.setTextForEditor(text.trim(), this.mySearchCriteriaEdit);
            if (this.myReplace) {
                this.setTextForEditor(text, this.myReplaceCriteriaEdit);
            }
            this.myScopePanel.setScopesFromContext();
            ApplicationManager.getApplication().invokeLater(() -> this.startTemplate());
            return;
        }
        Configuration configuration = ConfigurationManager.getInstance(this.getProject()).getMostRecentConfiguration();
        if (configuration != null) {
            this.loadConfiguration(configuration);
        }
    }

    private void setTextForEditor(String text, EditorTextField editor) {
        editor.setText(text);
        editor.selectAll();
        Project project2 = this.getProject();
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        documentManager.commitDocument(document);
        PsiFile file = documentManager.getPsiFile(document);
        if (file == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project2, (String)"Adjust line indent", (String)"Structural Search", () -> CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file, new TextRange(0, document.getTextLength())), (PsiFile[])new PsiFile[]{file});
    }

    private void startSearching() {
        if (this.myReplace) {
            new ReplaceCommand(this.myConfiguration, this.mySearchContext).startSearching();
        } else {
            new SearchCommand(this.myConfiguration, this.mySearchContext).startSearching();
        }
    }

    @NotNull
    String getDefaultTitle() {
        String string = this.myReplace ? SSRBundle.message("structural.replace.title", new Object[0]) : SSRBundle.message("structural.search.title", new Object[0]);
        if (string == null) {
            StructuralSearchDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected JComponent createCenterPanel() {
        this.mySearchEditorPanel = new OnePixelSplitter(false, 1.0f);
        this.mySearchEditorPanel.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        this.mySearchEditorPanel.getDivider().setOpaque(false);
        this.mySearchCriteriaEdit = this.createEditor();
        this.mySearchEditorPanel.setFirstComponent((JComponent)this.mySearchCriteriaEdit);
        this.mySearchEditorPanel.add("Center", (Component)this.mySearchCriteriaEdit);
        this.myReplacePanel = this.createReplacePanel();
        this.myReplacePanel.setVisible(this.myReplace);
        this.myScopePanel = new ScopePanel(this.getProject(), this.myDisposable);
        if (!this.myEditConfigOnly) {
            this.myScopePanel.setRecentDirectories(FindInProjectSettings.getInstance((Project)this.getProject()).getRecentDirectories());
            this.myScopePanel.setScopeConsumer((NullableConsumer<? super SearchScope>)((NullableConsumer)scope -> this.initiateValidation()));
        } else {
            this.myScopePanel.setVisible(false);
        }
        this.myFilterPanel = new FilterPanel(this.getProject(), StructuralSearchUtil.getProfileByFileType(this.myFileType), this.getDisposable());
        this.myFilterPanel.setConstraintChangedCallback(() -> this.initiateValidation());
        this.myFilterPanel.getComponent().setMinimumSize(new Dimension(300, 50));
        this.mySearchEditorPanel.setSecondComponent(this.myFilterPanel.getComponent());
        JLabel searchTargetLabel = new JLabel(SSRBundle.message("search.target.label", new Object[0]));
        this.myTargetComboBox = new LinkComboBox(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.myTargetComboBox.setItemConsumer((NullableConsumer<? super String>)((NullableConsumer)item -> {
            MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
            for (String name : matchOptions.getVariableConstraintNames()) {
                matchOptions.getVariableConstraint(name).setPartOfSearchResults(name.equals(item));
            }
            this.initiateValidation();
        }));
        JPanel centerPanel = new JPanel(null);
        GroupLayout layout = new GroupLayout(centerPanel);
        centerPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent((Component)this.mySearchEditorPanel).addComponent(this.myReplacePanel).addComponent(this.myScopePanel).addGroup(layout.createSequentialGroup().addComponent(searchTargetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent((Component)((Object)this.myTargetComboBox), -2, -1, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent((Component)this.mySearchEditorPanel).addGap(2).addComponent(this.myReplacePanel).addComponent(this.myScopePanel, -2, -1, -2).addGap(16).addGroup(layout.createParallelGroup().addComponent(searchTargetLabel).addComponent((Component)((Object)this.myTargetComboBox), -2, -1, -2)));
        return centerPanel;
    }

    private JComponent createReplacePanel() {
        JLabel label = new JLabel(SSRBundle.message("replacement.template.label", new Object[0]));
        this.myShortenFQN = new JCheckBox(SSRBundle.message("shorten.fully.qualified.names.checkbox", new Object[0]));
        this.myReformat = new JCheckBox(SSRBundle.message("reformat.checkbox", new Object[0]));
        this.myUseStaticImport = new JCheckBox(SSRBundle.message("use.static.import.checkbox", new Object[0]));
        this.myReplaceCriteriaEdit = this.createEditor();
        this.myReplaceEditorPanel = new OnePixelSplitter(false, 1.0f);
        this.myReplaceEditorPanel.setFirstComponent((JComponent)this.myReplaceCriteriaEdit);
        JPanel replacePanel = new JPanel(null);
        GroupLayout layout = new GroupLayout(replacePanel);
        replacePanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 28, 28).addComponent(label).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, Integer.MAX_VALUE).addComponent(this.myShortenFQN).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.myReformat).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.myUseStaticImport)).addComponent((Component)this.myReplaceEditorPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label).addComponent(this.myShortenFQN).addComponent(this.myReformat).addComponent(this.myUseStaticImport)).addComponent((Component)this.myReplaceEditorPanel));
        return replacePanel;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        List<PatternContext> contexts;
        DefaultActionGroup historyActionGroup = new DefaultActionGroup(new AnAction[]{new DumbAwareAction("History", null, AllIcons.Actions.SearchWithHistory){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Object source;
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (!((source = e.getInputEvent().getSource()) instanceof Component)) {
                    return;
                }
                JBPopupFactory.getInstance().createPopupChooserBuilder(ConfigurationManager.getInstance(StructuralSearchDialog.this.getProject()).getHistoryConfigurations()).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
                    if (value instanceof ReplaceConfiguration) {
                        label.setIcon(AllIcons.Actions.Replace);
                        label.setText(StringUtil.shortenTextWithEllipsis((String)StringUtil.collapseWhiteSpace((CharSequence)value.getMatchOptions().getSearchPattern()), (int)49, (int)0, (boolean)true) + " \u21d2 " + StringUtil.shortenTextWithEllipsis((String)StringUtil.collapseWhiteSpace((CharSequence)value.getReplaceOptions().getReplacement()), (int)49, (int)0, (boolean)true));
                    } else {
                        label.setIcon(AllIcons.Actions.Find);
                        label.setText(StringUtil.shortenTextWithEllipsis((String)StringUtil.collapseWhiteSpace((CharSequence)value.getMatchOptions().getSearchPattern()), (int)100, (int)0, (boolean)true));
                    }
                })).setItemChosenCallback(c -> StructuralSearchDialog.this.loadConfiguration((Configuration)c)).setSelectionMode(0).createPopup().showUnderneathOf((Component)source);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$5", "actionPerformed"));
            }
        }});
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbarImpl historyToolbar = (ActionToolbarImpl)actionManager.createActionToolbar("EditorToolbar", (ActionGroup)historyActionGroup, true);
        historyToolbar.setLayoutPolicy(0);
        JLabel label = new JLabel(SSRBundle.message("search.template", new Object[0]));
        UIUtil.installCompleteMatchInfo(label, () -> this.myConfiguration, link -> this.showFilterPanel((String)link));
        this.myRecursive = new JCheckBox(SSRBundle.message("recursive.matching.checkbox", new Object[0]), true);
        this.myRecursive.setVisible(!this.myReplace);
        this.myMatchCase = new JCheckBox(FindBundle.message((String)"find.popup.case.sensitive", (Object[])new Object[0]), true);
        this.myFileType = UIUtil.detectFileType(this.mySearchContext);
        this.myDialect = this.myFileType.getLanguage();
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        if (profile2 != null && !(contexts = profile2.getPatternContexts()).isEmpty()) {
            this.myPatternContext = contexts.get(0);
        }
        this.myFileTypesComboBox = new FileTypeSelector();
        this.myFileTypesComboBox.setMinimumAndPreferredWidth(200);
        this.myFileTypesComboBox.setSelectedItem(this.myFileType, this.myDialect, this.myPatternContext);
        this.myFileTypesComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FileTypeInfo item = StructuralSearchDialog.this.myFileTypesComboBox.getSelectedItem();
                    if (item == null) {
                        return;
                    }
                    StructuralSearchDialog.this.myFileType = item.getFileType();
                    StructuralSearchDialog.this.myDialect = item.getDialect();
                    StructuralSearchDialog.this.myPatternContext = item.getContext();
                    StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
                    assert (profile2 != null);
                    Document searchDocument = UIUtil.createDocument(StructuralSearchDialog.this.getProject(), StructuralSearchDialog.this.myFileType, StructuralSearchDialog.this.myDialect, StructuralSearchDialog.this.myPatternContext, StructuralSearchDialog.this.mySearchCriteriaEdit.getText(), profile2);
                    StructuralSearchDialog.this.mySearchCriteriaEdit.setNewDocumentAndFileType((FileType)StructuralSearchDialog.this.myFileType, searchDocument);
                    String contextId = StructuralSearchDialog.this.myPatternContext == null ? "" : StructuralSearchDialog.this.myPatternContext.getId();
                    searchDocument.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)contextId);
                    Document replaceDocument = UIUtil.createDocument(StructuralSearchDialog.this.getProject(), StructuralSearchDialog.this.myFileType, StructuralSearchDialog.this.myDialect, StructuralSearchDialog.this.myPatternContext, StructuralSearchDialog.this.myReplaceCriteriaEdit.getText(), profile2);
                    StructuralSearchDialog.this.myReplaceCriteriaEdit.setNewDocumentAndFileType((FileType)StructuralSearchDialog.this.myFileType, replaceDocument);
                    replaceDocument.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)contextId);
                    StructuralSearchDialog.this.myFilterPanel.setProfile(profile2);
                    StructuralSearchDialog.this.initiateValidation();
                }
            }
        });
        JLabel fileTypeLabel = new JLabel(SSRBundle.message("search.dialog.file.type.label", new Object[0]));
        fileTypeLabel.setLabelFor((Component)((Object)this.myFileTypesComboBox));
        DefaultActionGroup templateActionGroup = new DefaultActionGroup(new AnAction[]{new DumbAwareAction(SSRBundle.message("save.template.text.button", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                ConfigurationManager.getInstance(StructuralSearchDialog.this.getProject()).showSaveTemplateAsDialog(StructuralSearchDialog.this.getConfiguration());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$7", "actionPerformed"));
            }
        }, new CopyConfigurationAction(), new PasteConfigurationAction(), new DumbAwareAction(SSRBundle.message("copy.existing.template.button", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                SelectTemplateDialog dialog;
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (!(dialog = new SelectTemplateDialog(StructuralSearchDialog.this.getProject(), false, StructuralSearchDialog.this.myReplace)).showAndGet()) {
                    return;
                }
                Configuration[] configurations = dialog.getSelectedConfigurations();
                if (configurations.length == 1) {
                    StructuralSearchDialog.this.loadConfiguration(configurations[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$8", "actionPerformed"));
            }
        }, Separator.getInstance(), new SwitchAction()});
        templateActionGroup.setPopup(true);
        templateActionGroup.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        DumbAwareToggleAction filterAction = new DumbAwareToggleAction(null, "View variable filters", AllIcons.General.Filter){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                return StructuralSearchDialog.this.isFilterPanelVisible();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    9.$$$reportNull$$$0(1);
                }
                StructuralSearchDialog.this.setFilterPanelVisible(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$9";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DefaultActionGroup optionsActionGroup = new DefaultActionGroup(new AnAction[]{filterAction, templateActionGroup});
        this.myOptionsToolbar = (ActionToolbarImpl)actionManager.createActionToolbar("EditorToolbar", (ActionGroup)optionsActionGroup, true);
        this.myOptionsToolbar.setLayoutPolicy(0);
        this.myOptionsToolbar.setForceMinimumSize(true);
        JPanel northPanel = new JPanel(null);
        GroupLayout layout = new GroupLayout(northPanel);
        northPanel.setLayout(layout);
        layout.setHonorsVisibility(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent((Component)historyToolbar, -2, -1, -2).addComponent(label).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, Integer.MAX_VALUE).addComponent(this.myRecursive).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.myMatchCase).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(fileTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent((Component)((Object)this.myFileTypesComboBox), 125, -1, -2).addComponent((Component)this.myOptionsToolbar, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)historyToolbar).addComponent(label).addComponent(this.myRecursive).addComponent(this.myMatchCase).addComponent(fileTypeLabel).addComponent((Component)((Object)this.myFileTypesComboBox)).addComponent((Component)this.myOptionsToolbar));
        return northPanel;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        if (this.myEditConfigOnly) {
            return null;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.myOpenInNewTab = new JCheckBox(SSRBundle.message("open.in.new.tab.checkbox", new Object[0]));
        this.myOpenInNewTab.setSelected(FindSettings.getInstance().isShowResultsInSeparateView());
        panel.add((Component)this.myOpenInNewTab, "East");
        return panel;
    }

    Project getProject() {
        return this.mySearchContext.getProject();
    }

    @Nullable
    public Point getInitialLocation() {
        DimensionService dimensionService = DimensionService.getInstance();
        Dimension size = dimensionService.getSize(this.myReplace ? REPLACE_DIMENSION_SERVICE_KEY : SEARCH_DIMENSION_SERVICE_KEY, this.getProject());
        if (size != null) {
            this.setSize(size.width, this.myEditConfigOnly ? size.height - this.myScopePanel.getPreferredSize().height : size.height);
        } else {
            this.pack();
            Dimension otherSize = dimensionService.getSize(this.myReplace ? SEARCH_DIMENSION_SERVICE_KEY : REPLACE_DIMENSION_SERVICE_KEY, this.getProject());
            if (otherSize != null) {
                this.setSize(otherSize.width, this.getSize().height);
            }
        }
        if (this.myEditConfigOnly) {
            return super.getInitialLocation();
        }
        Point location = dimensionService.getLocation(SEARCH_DIMENSION_SERVICE_KEY, this.getProject());
        return location == null ? super.getInitialLocation() : location;
    }

    public void show() {
        StructuralSearchPlugin.getInstance(this.getProject()).setDialogVisible(true);
        if (!this.myUseLastConfiguration) {
            this.setTextFromContext();
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        this.setFilterPanelVisible(properties.getBoolean(FILTERS_VISIBLE_STATE, true));
        super.show();
    }

    private void startTemplate() {
        if (!Registry.is((String)"ssr.template.from.selection.builder")) {
            return;
        }
        Document document = this.mySearchCriteriaEdit.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
        assert (psiFile != null);
        TemplateBuilder builder = new StructuralSearchTemplateBuilder(psiFile).buildTemplate();
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (String)"Live search template builder", (String)"Structural Search", () -> builder.run(Objects.requireNonNull(this.mySearchCriteriaEdit.getEditor()), true), (PsiFile[])new PsiFile[0]);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchCriteriaEdit;
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.removeMatchHighlights();
    }

    protected void doOKAction() {
        this.myDoingOkAction = true;
        CompiledPattern compiledPattern = this.compilePattern();
        this.myDoingOkAction = false;
        if (compiledPattern == null) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myConfiguration.removeUnusedVariables();
        super.doOKAction();
        if (this.myEditConfigOnly) {
            return;
        }
        SearchScope scope = this.myScopePanel.getScope();
        if (scope instanceof GlobalSearchScopesCore.DirectoryScope) {
            GlobalSearchScopesCore.DirectoryScope directoryScope = (GlobalSearchScopesCore.DirectoryScope)scope;
            FindInProjectSettings.getInstance((Project)this.getProject()).addDirectory(directoryScope.getDirectory().getPresentableUrl());
        }
        FindSettings findSettings = FindSettings.getInstance();
        findSettings.setShowResultsInSeparateView(this.myOpenInNewTab.isSelected());
        try {
            ConfigurationManager.getInstance(this.getProject()).addHistoryConfiguration(this.myConfiguration);
            this.startSearching();
        }
        catch (MalformedPatternException ex) {
            this.reportMessage(SSRBundle.message("this.pattern.is.malformed.message", ex.getMessage()), true, (JComponent)this.mySearchCriteriaEdit);
        }
    }

    public Configuration getConfiguration() {
        this.saveConfiguration();
        return this.myConfiguration;
    }

    private CompiledPattern compilePattern() {
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        Project project2 = this.getProject();
        try {
            CompiledPattern compiledPattern = PatternCompiler.compilePattern(project2, matchOptions, true, !this.myEditConfigOnly);
            this.reportMessage(null, false, (JComponent)this.mySearchCriteriaEdit);
            if (this.myReplace) {
                try {
                    Replacer.checkReplacementPattern(project2, this.myConfiguration.getReplaceOptions());
                }
                catch (UnsupportedPatternException ex) {
                    this.reportMessage(SSRBundle.message("unsupported.replacement.pattern.message", ex.getMessage()), true, (JComponent)this.myReplaceCriteriaEdit);
                    return null;
                }
                catch (MalformedPatternException ex) {
                    if (!ex.isErrorElement || !Registry.is((String)"ssr.in.editor.problem.highlighting")) {
                        this.reportMessage(SSRBundle.message("malformed.replacement.pattern.message", ex.getMessage()), true, (JComponent)this.myReplaceCriteriaEdit);
                    }
                    return null;
                }
            }
            this.reportMessage(null, false, (JComponent)this.myReplaceCriteriaEdit);
            return compiledPattern;
        }
        catch (MalformedPatternException e) {
            String message;
            this.removeMatchHighlights();
            String string = StringUtil.isEmpty((String)matchOptions.getSearchPattern()) ? null : (message = SSRBundle.message("this.pattern.is.malformed.message", e.getMessage() != null ? e.getMessage() : ""));
            if (!e.isErrorElement || !Registry.is((String)"ssr.in.editor.problem.highlighting")) {
                this.reportMessage(message, true, (JComponent)this.mySearchCriteriaEdit);
            }
            return null;
        }
        catch (UnsupportedPatternException e) {
            this.removeMatchHighlights();
            this.reportMessage(SSRBundle.message("this.pattern.is.unsupported.message", e.getMessage()), true, (JComponent)this.mySearchCriteriaEdit);
            return null;
        }
        catch (NoMatchFoundException e) {
            this.removeMatchHighlights();
            this.reportMessage(e.getMessage(), false, this.myScopePanel);
            return null;
        }
    }

    void removeMatchHighlights() {
        if (this.myEditConfigOnly) {
            return;
        }
        Editor editor = this.myEditor;
        if (editor == null) {
            return;
        }
        Project project2 = this.getProject();
        ApplicationManager.getApplication().invokeLater(() -> {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
            for (RangeHighlighter highlighter : this.myRangeHighlighters) {
                highlightManager.removeSegmentHighlighter(editor, highlighter);
            }
            WindowManager.getInstance().getStatusBar(project2).setInfo("");
            this.myRangeHighlighters.clear();
        });
    }

    void addMatchHighlights() {
        if (this.myEditConfigOnly) {
            return;
        }
        if (this.myDoingOkAction) {
            this.removeMatchHighlights();
        } else {
            Project project2 = this.getProject();
            Editor editor = this.myEditor;
            if (editor == null) {
                return;
            }
            Document document = editor.getDocument();
            PsiFile file = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
            if (file == null) {
                return;
            }
            MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
            matchOptions.setScope((SearchScope)new LocalSearchScope((PsiElement)file, IdeBundle.message((String)"scope.current.file", (Object[])new Object[0])));
            CollectingMatchResultSink sink = new CollectingMatchResultSink();
            new Matcher(project2).findMatches(sink, matchOptions);
            List<MatchResult> matches = sink.getMatches();
            this.removeMatchHighlights();
            this.addMatchHighlights(matches, editor, file, matches.size() + " results found in current file");
        }
    }

    private void addMatchHighlights(@NotNull List<MatchResult> matchResults, @NotNull Editor editor, @NotNull PsiFile file, @Nullable String statusBarText) {
        if (matchResults == null) {
            StructuralSearchDialog.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            StructuralSearchDialog.$$$reportNull$$$0(3);
        }
        if (file == null) {
            StructuralSearchDialog.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project2 = this.getProject();
            if (project2.isDisposed()) {
                return;
            }
            if (!matchResults.isEmpty()) {
                EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
                TextAttributes textAttributes = globalScheme.getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
                HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
                for (MatchResult result : matchResults) {
                    PsiElement match = result.getMatch();
                    if (match == null || match.getContainingFile() != file) continue;
                    int start = -1;
                    int end = -1;
                    if ("__multi_line__".equals(result.getName())) {
                        for (MatchResult child : result.getChildren()) {
                            int endOffset;
                            TextRange range = child.getMatch().getTextRange();
                            int startOffset = range.getStartOffset();
                            if (start == -1 || start > startOffset) {
                                start = startOffset;
                            }
                            if (end >= (endOffset = range.getEndOffset())) continue;
                            end = endOffset;
                        }
                    } else {
                        TextRange range = match.getTextRange();
                        start = range.getStartOffset();
                        end = range.getEndOffset();
                    }
                    highlightManager.addRangeHighlight(editor, start, end, textAttributes, false, this.myRangeHighlighters);
                }
                FindManager findmanager = FindManager.getInstance((Project)project2);
                FindModel findmodel = findmanager.getFindNextModel();
                if (findmodel == null) {
                    findmodel = findmanager.getFindInFileModel();
                }
                findmodel.setSearchHighlighters(true);
                findmanager.setFindWasPerformed();
                findmanager.setFindNextModel(findmodel);
            }
            WindowManager.getInstance().getStatusBar(project2).setInfo(statusBarText);
        });
    }

    void reportMessage(String message, boolean error, JComponent component) {
        com.intellij.util.ui.UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myBalloon != null) {
                this.myBalloon.hide();
            }
            component.putClientProperty("JComponent.outline", !error || message == null ? null : "error");
            component.repaint();
            if (message == null) {
                return;
            }
            this.myBalloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, error ? MessageType.ERROR : MessageType.WARNING, null).setHideOnFrameResize(false).createBalloon();
            if (component != this.myScopePanel) {
                this.myBalloon.show(new RelativePoint((Component)component, new Point(component.getWidth() / 2, component.getHeight())), Balloon.Position.below);
            } else {
                this.myBalloon.show(new RelativePoint((Component)component, new Point(component.getWidth() / 2, 0)), Balloon.Position.above);
            }
            this.myBalloon.showInCenterOf(component);
            Disposer.register((Disposable)this.myDisposable, (Disposable)this.myBalloon);
        });
    }

    void securityCheck() {
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        int scripts = 0;
        for (String name : matchOptions.getVariableConstraintNames()) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name);
            if (constraint.getScriptCodeConstraint().length() <= 2) continue;
            ++scripts;
        }
        ReplaceOptions replaceOptions = this.myConfiguration.getReplaceOptions();
        if (replaceOptions != null) {
            for (ReplacementVariableDefinition variableDefinition : replaceOptions.getVariableDefinitions()) {
                if (variableDefinition.getScriptCodeConstraint().length() <= 2) continue;
                ++scripts;
            }
        }
        if (scripts > 0) {
            UIUtil.SSR_NOTIFICATION_GROUP.createNotification(NotificationType.WARNING).setTitle(SSRBundle.message("import.template.script.warning.title", new Object[0])).setContent(SSRBundle.message("import.template.script.warning", ApplicationNamesInfo.getInstance().getFullProductName(), scripts)).notify(this.mySearchContext.getProject());
        }
    }

    public void showFilterPanel(String variableName) {
        this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(variableName, this.myConfiguration));
        this.setFilterPanelVisible(true);
        this.myConfiguration.setCurrentVariableName(variableName);
    }

    void setFilterPanelVisible(boolean visible) {
        if (visible) {
            if (!this.myFilterPanel.isInitialized()) {
                this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
            }
            if (!this.isFilterPanelVisible()) {
                this.mySearchEditorPanel.setSecondComponent(this.myFilterPanel.getComponent());
            }
        } else if (this.isFilterPanelVisible()) {
            this.mySearchEditorPanel.setSecondComponent(null);
            this.myConfiguration.setCurrentVariableName(null);
        }
    }

    boolean isFilterPanelVisible() {
        return this.mySearchEditorPanel.getSecondComponent() != null;
    }

    private void setSearchTargets(MatchOptions matchOptions) {
        ArrayList<String> names = new ArrayList<String>(matchOptions.getUsedVariableNames());
        Collections.sort(names);
        names.remove("__context__");
        names.add(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.myTargetComboBox.setItems(names);
        if (names.size() > 1) {
            this.myTargetComboBox.setEnabled(true);
            for (String name : names) {
                MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name);
                if (constraint == null || !constraint.isPartOfSearchResults()) continue;
                this.myTargetComboBox.setSelectedItem(name);
                return;
            }
            this.myTargetComboBox.setSelectedItem(SSRBundle.message("complete.match.variable.name", new Object[0]));
        } else {
            this.myTargetComboBox.setEnabled(false);
        }
    }

    boolean loadConfiguration(String text) {
        if (text == null) {
            return false;
        }
        try {
            Configuration configuration = ConfigurationUtil.fromXml(text);
            if (configuration == null) {
                return false;
            }
            this.loadConfiguration(configuration);
            this.securityCheck();
        }
        catch (JDOMException e) {
            ApplicationManager.getApplication().invokeLater(() -> this.reportMessage(e.getMessage(), false, (JComponent)this.myOptionsToolbar));
        }
        return true;
    }

    public void loadConfiguration(Configuration configuration) {
        this.myConfiguration = this.createConfiguration(configuration);
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        this.setSearchTargets(matchOptions);
        if (!this.myEditConfigOnly) {
            this.myScopePanel.setScopesFromContext();
            SearchScope scope = matchOptions.getScope();
            if (scope != null) {
                this.myScopePanel.setScope(scope);
            }
        }
        UIUtil.setContent(this.mySearchCriteriaEdit, matchOptions.getSearchPattern());
        this.myMatchCase.setSelected(matchOptions.isCaseSensitiveMatch());
        this.myFileTypesComboBox.setSelectedItem(matchOptions.getFileType(), matchOptions.getDialect(), matchOptions.getPatternContext());
        Editor searchEditor = this.mySearchCriteriaEdit.getEditor();
        if (searchEditor != null) {
            searchEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (this.myReplace) {
            if (configuration instanceof ReplaceConfiguration) {
                ReplaceOptions replaceOptions = configuration.getReplaceOptions();
                UIUtil.setContent(this.myReplaceCriteriaEdit, replaceOptions.getReplacement());
                this.myShortenFQN.setSelected(replaceOptions.isToShortenFQN());
                this.myReformat.setSelected(replaceOptions.isToReformatAccordingToStyle());
                this.myUseStaticImport.setSelected(replaceOptions.isToUseStaticImport());
            } else {
                UIUtil.setContent(this.myReplaceCriteriaEdit, matchOptions.getSearchPattern());
                this.myShortenFQN.setSelected(properties.getBoolean(SHORTEN_FQN_STATE));
                this.myReformat.setSelected(properties.getBoolean(REFORMAT_STATE));
                this.myUseStaticImport.setSelected(properties.getBoolean(USE_STATIC_IMPORT_STATE));
            }
            Editor replaceEditor = this.myReplaceCriteriaEdit.getEditor();
            if (replaceEditor != null) {
                replaceEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
            }
            this.myRecursive.setSelected(false);
        } else if (configuration instanceof ReplaceConfiguration) {
            this.myRecursive.setSelected(properties.getBoolean(RECURSIVE_STATE));
        }
    }

    private void saveConfiguration() {
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        if (!this.myEditConfigOnly) {
            SearchScope scope = this.myScopePanel.getScope();
            boolean searchWithinHierarchy = IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(scope.getDisplayName());
            matchOptions.setScope((SearchScope)(searchWithinHierarchy && !this.myDoingOkAction ? GlobalSearchScope.projectScope((Project)this.getProject()) : scope));
        }
        matchOptions.setFileType(this.myFileType);
        matchOptions.setDialect(this.myDialect);
        matchOptions.setPatternContext(this.myPatternContext);
        matchOptions.setSearchPattern(this.getPattern(this.mySearchCriteriaEdit));
        matchOptions.setCaseSensitiveMatch(this.myMatchCase.isSelected());
        if (this.myReplace) {
            ReplaceOptions replaceOptions = this.myConfiguration.getReplaceOptions();
            replaceOptions.setReplacement(this.getPattern(this.myReplaceCriteriaEdit));
            replaceOptions.setToShortenFQN(this.myShortenFQN.isSelected());
            replaceOptions.setToReformatAccordingToStyle(this.myReformat.isSelected());
            replaceOptions.setToUseStaticImport(this.myUseStaticImport.isSelected());
            matchOptions.setRecursiveSearch(false);
        } else {
            matchOptions.setRecursiveSearch(this.myRecursive.isSelected());
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (this.myReplace) {
            properties.setValue(SHORTEN_FQN_STATE, this.myShortenFQN.isSelected());
            properties.setValue(REFORMAT_STATE, this.myReformat.isSelected());
            properties.setValue(USE_STATIC_IMPORT_STATE, this.myUseStaticImport.isSelected());
        } else {
            properties.setValue(RECURSIVE_STATE, this.myRecursive.isSelected());
            properties.setValue(MATCH_CASE_STATE, this.myMatchCase.isSelected());
        }
    }

    private String getPattern(EditorTextField textField) {
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        assert (profile2 != null);
        Document document = textField.getDocument();
        String pattern = (String)ReadAction.compute(() -> {
            PsiFile file = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
            assert (file != null);
            return profile2.getCodeFragmentText(file);
        });
        return pattern.isEmpty() ? textField.getText() : pattern;
    }

    @Nullable
    protected final String getDimensionServiceKey() {
        return null;
    }

    public void dispose() {
        if (this.myReplace) {
            this.storeDimensions(REPLACE_DIMENSION_SERVICE_KEY, SEARCH_DIMENSION_SERVICE_KEY);
        } else {
            this.storeDimensions(SEARCH_DIMENSION_SERVICE_KEY, REPLACE_DIMENSION_SERVICE_KEY);
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        properties.setValue(FILTERS_VISIBLE_STATE, this.isFilterPanelVisible(), true);
        StructuralSearchPlugin.getInstance(this.getProject()).setDialogVisible(false);
        this.myAlarm.cancelAllRequests();
        this.mySearchCriteriaEdit.removeNotify();
        this.myReplaceCriteriaEdit.removeNotify();
        super.dispose();
    }

    private void storeDimensions(String key1, String key2) {
        if (this.myEditConfigOnly) {
            return;
        }
        Dimension size = this.getSize();
        DimensionService dimensionService = DimensionService.getInstance();
        Point location = this.getLocation();
        if (location.x < 0) {
            location.x = 0;
        }
        if (location.y < 0) {
            location.y = 0;
        }
        dimensionService.setLocation(SEARCH_DIMENSION_SERVICE_KEY, location, this.getProject());
        dimensionService.setSize(key1, size, this.getProject());
        Dimension otherSize = dimensionService.getSize(key2);
        if (otherSize != null && otherSize.width != size.width) {
            otherSize.width = size.width;
            dimensionService.setSize(key2, otherSize, this.getProject());
        }
    }

    protected String getHelpId() {
        return "find.structuredSearch";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchResults";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addMatchHighlights";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PasteConfigurationAction
    extends AnAction
    implements DumbAware {
        PasteConfigurationAction() {
            super(SSRBundle.message("import.template.action", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String contents;
            if (e == null) {
                PasteConfigurationAction.$$$reportNull$$$0(0);
            }
            if (!StructuralSearchDialog.this.loadConfiguration(contents = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor))) {
                StructuralSearchDialog.this.reportMessage(SSRBundle.message("no.template.found.warning", new Object[0]), false, (JComponent)StructuralSearchDialog.this.myOptionsToolbar);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$PasteConfigurationAction", "actionPerformed"));
        }
    }

    private class CopyConfigurationAction
    extends AnAction
    implements DumbAware {
        CopyConfigurationAction() {
            super(SSRBundle.message("export.template.action", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyConfigurationAction.$$$reportNull$$$0(0);
            }
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(ConfigurationUtil.toXml(StructuralSearchDialog.this.myConfiguration)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$CopyConfigurationAction", "actionPerformed"));
        }
    }

    private class SwitchAction
    extends AnAction
    implements DumbAware {
        SwitchAction() {
            this.init();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SwitchAction.$$$reportNull$$$0(0);
            }
            StructuralSearchDialog.this.myReplace = !StructuralSearchDialog.this.myReplace;
            StructuralSearchDialog.this.setTitle(StructuralSearchDialog.this.getDefaultTitle());
            StructuralSearchDialog.this.myReplacePanel.setVisible(StructuralSearchDialog.this.myReplace);
            StructuralSearchDialog.this.myRecursive.setVisible(!StructuralSearchDialog.this.myReplace);
            StructuralSearchDialog.this.loadConfiguration(StructuralSearchDialog.this.myConfiguration);
            Dimension size = DimensionService.getInstance().getSize(StructuralSearchDialog.this.myReplace ? StructuralSearchDialog.REPLACE_DIMENSION_SERVICE_KEY : StructuralSearchDialog.SEARCH_DIMENSION_SERVICE_KEY);
            if (size != null) {
                StructuralSearchDialog.this.setSize(StructuralSearchDialog.this.getSize().width, size.height);
            } else {
                StructuralSearchDialog.this.pack();
            }
            this.init();
        }

        private void init() {
            this.getTemplatePresentation().setText(SSRBundle.message(StructuralSearchDialog.this.myReplace ? "switch.to.search.action" : "switch.to.replace.action", new Object[0]));
            ActionManager actionManager = ActionManager.getInstance();
            ShortcutSet searchShortcutSet = actionManager.getAction("StructuralSearchPlugin.StructuralSearchAction").getShortcutSet();
            ShortcutSet replaceShortcutSet = actionManager.getAction("StructuralSearchPlugin.StructuralReplaceAction").getShortcutSet();
            CompositeShortcutSet shortcutSet = StructuralSearchDialog.this.myReplace ? new CompositeShortcutSet(new ShortcutSet[]{searchShortcutSet, replaceShortcutSet}) : new CompositeShortcutSet(new ShortcutSet[]{replaceShortcutSet, searchShortcutSet});
            this.registerCustomShortcutSet((ShortcutSet)shortcutSet, StructuralSearchDialog.this.getRootPane());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$SwitchAction", "actionPerformed"));
        }
    }
}

