/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.FileTypeInfo;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeSelector
extends ComboBox<FileTypeInfo> {
    public FileTypeSelector() {
        super(FileTypeSelector.createModel());
        this.setRenderer((ListCellRenderer)((Object)new MyCellRenderer()));
        this.setSwingPopup(false);
    }

    @Nullable
    public FileTypeInfo getSelectedItem() {
        return (FileTypeInfo)super.getSelectedItem();
    }

    @Nullable
    public LanguageFileType getSelectedFileType() {
        FileTypeInfo info = (FileTypeInfo)super.getSelectedItem();
        return info != null ? info.getFileType() : null;
    }

    public void setSelectedItem(@NotNull LanguageFileType type, @Nullable Language dialect, @Nullable PatternContext context) {
        if (type == null) {
            FileTypeSelector.$$$reportNull$$$0(0);
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            FileTypeInfo info = (FileTypeInfo)model.getElementAt(i);
            if (!info.isEqualTo(type, dialect, context)) continue;
            this.setSelectedItem(info);
            return;
        }
    }

    @NotNull
    private static DefaultComboBoxModel<FileTypeInfo> createModel() {
        ArrayList<LanguageFileType> types = new ArrayList<LanguageFileType>();
        for (LanguageFileType fileType : StructuralSearchUtil.getSuitableFileTypes()) {
            if (StructuralSearchUtil.getProfileByFileType(fileType) == null) continue;
            types.add(fileType);
        }
        Collections.sort(types, (o1, o2) -> o1.getDescription().compareToIgnoreCase(o2.getDescription()));
        ArrayList<FileTypeInfo> infos = new ArrayList<FileTypeInfo>();
        for (LanguageFileType fileType : types) {
            StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(fileType);
            assert (profile2 != null);
            Language language = fileType.getLanguage();
            ArrayList<PatternContext> patternContexts = new ArrayList<PatternContext>(profile2.getPatternContexts());
            if (!patternContexts.isEmpty()) {
                infos.add(new FileTypeInfo(fileType, language, (PatternContext)patternContexts.get(0), false));
                for (int i = 1; i < patternContexts.size(); ++i) {
                    infos.add(new FileTypeInfo(fileType, language, (PatternContext)patternContexts.get(i), true));
                }
                continue;
            }
            infos.add(new FileTypeInfo(fileType, language, null, false));
            Language[] languageDialects = LanguageUtil.getLanguageDialects((Language)language);
            Arrays.sort(languageDialects, Comparator.comparing(Language::getDisplayName));
            for (Language dialect : languageDialects) {
                if (!profile2.isMyLanguage(dialect)) continue;
                infos.add(new FileTypeInfo(fileType, dialect, null, true));
            }
        }
        MyComboBoxModel myComboBoxModel = new MyComboBoxModel(infos);
        if (myComboBoxModel == null) {
            FileTypeSelector.$$$reportNull$$$0(1);
        }
        return myComboBoxModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/FileTypeSelector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/FileTypeSelector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedItem";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCellRenderer
    extends SimpleListCellRenderer<FileTypeInfo> {
        private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
        private static final Icon WIDE_EMPTY_ICON = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)32, (int)18));

        MyCellRenderer() {
        }

        public void customize(JList<? extends FileTypeInfo> list, FileTypeInfo value, int index, boolean selected, boolean hasFocus) {
            if (value == null) {
                return;
            }
            this.setIcon(value.isNested() && index >= 0 ? WIDE_EMPTY_ICON : MyCellRenderer.getFileTypeIcon(value));
            this.setText(value.getText());
        }

        @NotNull
        private static Icon getFileTypeIcon(FileTypeInfo info) {
            LayeredIcon layeredIcon = new LayeredIcon(2);
            layeredIcon.setIcon(EMPTY_ICON, 0);
            Icon icon = info.getFileType().getIcon();
            if (icon != null) {
                layeredIcon.setIcon(icon, 1);
            }
            LayeredIcon layeredIcon2 = layeredIcon;
            if (layeredIcon2 == null) {
                MyCellRenderer.$$$reportNull$$$0(0);
            }
            return layeredIcon2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/FileTypeSelector$MyCellRenderer", "getFileTypeIcon"));
        }
    }

    private static class MyComboBoxModel
    extends DefaultComboBoxModel<FileTypeInfo> {
        MyComboBoxModel(List<FileTypeInfo> infos) {
            super(infos.toArray(FileTypeInfo.EMPTY_ARRAY));
        }
    }
}

