/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.ConfigurationUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.SmartList;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExistingTemplatesComponent {
    private static final Pattern SPLIT = Pattern.compile("(?<!/)/(?!/)");
    private final Tree patternTree;
    private final DefaultTreeModel patternTreeModel;
    private final DefaultMutableTreeNode userTemplatesNode;
    private final JComponent panel;
    private final CollectionListModel<Configuration> historyModel;
    private final JList<Configuration> historyList;
    private final JComponent historyPanel;
    private DialogWrapper owner;
    private final Project project;
    private final SmartList<Runnable> queuedActions = new SmartList();

    private ExistingTemplatesComponent(Project project2) {
        this.project = project2;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(null);
        this.patternTreeModel = new DefaultTreeModel(root);
        this.patternTree = ExistingTemplatesComponent.createTree(this.patternTreeModel);
        for (Configuration info : StructuralSearchUtil.getPredefinedTemplates()) {
            ExistingTemplatesComponent.getOrCreateCategoryNode(root, SPLIT.split(info.getCategory())).add(new DefaultMutableTreeNode(info, false));
        }
        this.userTemplatesNode = new DefaultMutableTreeNode(SSRBundle.message("user.defined.category", new Object[0]));
        root.add(this.userTemplatesNode);
        TreeUtil.expandAll((JTree)this.patternTree);
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)this.patternTree);
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        this.panel = ToolbarDecorator.createDecorator((JTree)this.patternTree).setRemoveAction(button -> {
            int[] rows;
            Object selection = this.patternTree.getLastSelectedPathComponent();
            if (!(selection instanceof DefaultMutableTreeNode)) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection;
            if (!(node.getUserObject() instanceof Configuration)) {
                return;
            }
            Configuration configuration = (Configuration)node.getUserObject();
            if (configuration.isPredefined()) {
                return;
            }
            String configurationName = configuration.getName();
            for (Configuration otherConfiguration : ConfigurationManager.getInstance(project2).getConfigurations()) {
                String within;
                MatchVariableConstraint constraint = otherConfiguration.getMatchOptions().getVariableConstraint("__context__");
                if (constraint == null || !configurationName.equals(within = constraint.getWithinConstraint())) continue;
                if (2 != Messages.showOkCancelDialog((Project)project2, (String)SSRBundle.message("template.in.use.message", configurationName, otherConfiguration.getName()), (String)SSRBundle.message("template.in.use.title", configurationName), (String)CommonBundle.message((String)"button.remove", (Object[])new Object[0]), (String)Messages.CANCEL_BUTTON, (Icon)AllIcons.General.WarningDialog)) break;
                return;
            }
            if ((rows = this.patternTree.getSelectionRows()) != null && rows.length > 0) {
                this.patternTree.addSelectionRow(rows[0] - 1);
            }
            this.patternTreeModel.removeNodeFromParent(node);
            this.queuedActions.add(() -> ConfigurationManager.getInstance(project2).removeConfiguration(configuration));
        }).setRemoveActionUpdater(e -> {
            Configuration configuration = this.getSelectedConfiguration();
            return configuration != null && !configuration.isPredefined();
        }).addExtraAction(AnActionButton.fromAction((AnAction)actionManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)this.patternTree))).addExtraAction(AnActionButton.fromAction((AnAction)actionManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)this.patternTree))).createPanel();
        new JPanel(new BorderLayout());
        this.configureSelectTemplateAction((JComponent)this.patternTree);
        this.historyModel = new CollectionListModel((Object[])new Configuration[0]);
        this.historyPanel = new JPanel(new BorderLayout());
        this.historyPanel.add("North", new JLabel(SSRBundle.message("used.templates", new Object[0])));
        this.historyList = new JBList(this.historyModel);
        this.historyPanel.add("Center", ScrollPaneFactory.createScrollPane(this.historyList));
        this.historyList.setSelectionMode(0);
        ListSpeedSearch speedSearch = new ListSpeedSearch(this.historyList, Configuration::getName);
        this.historyList.setCellRenderer((ListCellRenderer<Configuration>)((Object)new ExistingTemplatesListCellRenderer(speedSearch)));
        this.configureSelectTemplateAction(this.historyList);
    }

    @NotNull
    private static DefaultMutableTreeNode getOrCreateCategoryNode(@NotNull DefaultMutableTreeNode root, String[] path) {
        if (root == null) {
            ExistingTemplatesComponent.$$$reportNull$$$0(0);
        }
        DefaultMutableTreeNode result = root;
        block0: for (String step : path) {
            DefaultMutableTreeNode child;
            step = StringUtil.replace((String)step, (String)"//", (String)"/");
            DefaultMutableTreeNode defaultMutableTreeNode = child = result.getChildCount() == 0 ? null : (DefaultMutableTreeNode)result.getLastChild();
            while (child != null) {
                if (step.equals(child.getUserObject())) {
                    result = child;
                    continue block0;
                }
                child = child.getPreviousSibling();
            }
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(step);
            result.add(newNode);
            result = newNode;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = result;
        if (defaultMutableTreeNode == null) {
            ExistingTemplatesComponent.$$$reportNull$$$0(1);
        }
        return defaultMutableTreeNode;
    }

    public void selectConfiguration(String name) {
        DefaultMutableTreeNode node = TreeUtil.findNode((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.patternTreeModel.getRoot()), n -> {
            Object object = n.getUserObject();
            return object instanceof Configuration && name.equals(((Configuration)object).getName());
        });
        TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)false, (JTree)this.patternTree, (boolean)false);
    }

    public Configuration getSelectedConfiguration() {
        Object selection = this.patternTree.getLastSelectedPathComponent();
        if (!(selection instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection;
        if (!(node.getUserObject() instanceof Configuration)) {
            return null;
        }
        return (Configuration)node.getUserObject();
    }

    private void initialize() {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance(this.project);
        this.userTemplatesNode.removeAllChildren();
        for (Configuration config : configurationManager.getConfigurations()) {
            this.userTemplatesNode.add(new DefaultMutableTreeNode(config));
        }
        this.patternTreeModel.reload(this.userTemplatesNode);
        this.patternTree.expandPath(new TreePath(new Object[]{this.patternTreeModel.getRoot(), this.userTemplatesNode}));
        this.historyModel.replaceAll(configurationManager.getHistoryConfigurations());
        this.historyList.setSelectedIndex(0);
    }

    private void configureSelectTemplateAction(JComponent component) {
        component.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && ExistingTemplatesComponent.this.patternTree.isVisible() && ExistingTemplatesComponent.this.getSelectedConfiguration() != null) {
                    ExistingTemplatesComponent.this.owner.close(0);
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                if (ExistingTemplatesComponent.this.patternTree.isVisible() && ExistingTemplatesComponent.this.getSelectedConfiguration() != null) {
                    ExistingTemplatesComponent.this.owner.close(0);
                }
                return true;
            }
        }.installOn((Component)component);
    }

    private static Tree createTree(TreeModel treeModel) {
        final Tree tree = new Tree(treeModel);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setDragEnabled(false);
        tree.setEditable(false);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setTransferHandler(new TransferHandler(){

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent c) {
                Object selection = tree.getLastSelectedPathComponent();
                if (!(selection instanceof DefaultMutableTreeNode)) {
                    return null;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection;
                if (!(node.getUserObject() instanceof Configuration)) {
                    return null;
                }
                return new TextTransferable(ConfigurationUtil.toXml((Configuration)node.getUserObject()));
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        TreeSpeedSearch speedSearch = new TreeSpeedSearch(tree, object -> {
            Object userObject = ((DefaultMutableTreeNode)object.getLastPathComponent()).getUserObject();
            return userObject instanceof Configuration ? ((Configuration)userObject).getName() : userObject.toString();
        });
        tree.setCellRenderer((TreeCellRenderer)((Object)new ExistingTemplatesTreeCellRenderer(speedSearch)));
        return tree;
    }

    public JTree getPatternTree() {
        return this.patternTree;
    }

    public JComponent getTemplatesPanel() {
        return this.panel;
    }

    public static ExistingTemplatesComponent getInstance(Project project2) {
        ExistingTemplatesComponent existingTemplatesComponent = (ExistingTemplatesComponent)ServiceManager.getService((Project)project2, ExistingTemplatesComponent.class);
        existingTemplatesComponent.initialize();
        return existingTemplatesComponent;
    }

    public JList<Configuration> getHistoryList() {
        return this.historyList;
    }

    public JComponent getHistoryPanel() {
        return this.historyPanel;
    }

    public void setOwner(DialogWrapper owner) {
        this.owner = owner;
    }

    public void finish(boolean performQueuedActions) {
        if (performQueuedActions) {
            this.queuedActions.forEach(Runnable::run);
        }
        this.queuedActions.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCategoryNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCategoryNode";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExistingTemplatesTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final TreeSpeedSearch mySpeedSearch;

        ExistingTemplatesTreeCellRenderer(TreeSpeedSearch speedSearch) {
            this.mySpeedSearch = speedSearch;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            int style;
            String text;
            DefaultMutableTreeNode treeNode;
            Object userObject;
            if (tree == null) {
                ExistingTemplatesTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if ((userObject = (treeNode = (DefaultMutableTreeNode)value).getUserObject()) == null) {
                return;
            }
            Color background = UIUtil.getTreeBackground((boolean)selected, (boolean)hasFocus);
            Color foreground = UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus);
            if (userObject instanceof Configuration) {
                text = ((Configuration)userObject).getName();
                style = 0;
            } else {
                text = userObject.toString();
                style = 1;
            }
            SearchUtil.appendFragments((String)this.mySpeedSearch.getEnteredPrefix(), (String)text, (int)style, (Color)foreground, (Color)background, (SimpleColoredComponent)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent$ExistingTemplatesTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private static class ExistingTemplatesListCellRenderer
    extends ColoredListCellRenderer<Configuration> {
        private final ListSpeedSearch mySpeedSearch;

        ExistingTemplatesListCellRenderer(ListSpeedSearch speedSearch) {
            this.mySpeedSearch = speedSearch;
        }

        protected void customizeCellRenderer(@NotNull JList list, Configuration value, int index, boolean selected, boolean focus) {
            if (list == null) {
                ExistingTemplatesListCellRenderer.$$$reportNull$$$0(0);
            }
            Color background = selected && !focus ? UIUtil.getListUnfocusedSelectionBackground() : UIUtil.getListBackground((boolean)selected);
            Color foreground = UIUtil.getListForeground((boolean)selected);
            this.setPaintFocusBorder(false);
            SearchUtil.appendFragments((String)this.mySpeedSearch.getEnteredPrefix(), (String)value.getName(), (int)0, (Color)foreground, (Color)background, (SimpleColoredComponent)this);
            long created = value.getCreated();
            if (created > 0L) {
                String createdString = DateFormatUtil.formatPrettyDateTime((long)created);
                this.append(" (" + createdString + ')', selected ? new SimpleTextAttributes(0, foreground) : SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/structuralsearch/plugin/ui/ExistingTemplatesComponent$ExistingTemplatesListCellRenderer", "customizeCellRenderer"));
        }
    }
}

