/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementInfoImpl;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Replacer {
    private final Project project;
    private final ReplaceOptions options;
    private final StructuralReplaceHandler replaceHandler;
    private final ReplacementBuilder replacementBuilder;
    private PsiElement lastAffectedElement = null;

    public Replacer(Project project2, ReplaceOptions options) {
        this.project = project2;
        this.options = options;
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(options.getMatchOptions().getFileType());
        assert (profile2 != null);
        this.replaceHandler = profile2.getReplaceHandler(project2, options);
        assert (this.replaceHandler != null);
        this.replacementBuilder = new ReplacementBuilder(this.project, this.options);
    }

    public static String stripTypedVariableDecoration(String type) {
        return type.substring(1, type.length() - 1);
    }

    public static int insertSubstitution(StringBuilder result, int offset, ParameterInfo info, String image) {
        if (!image.isEmpty()) {
            result.insert(offset + info.getStartIndex(), image);
            offset += image.length();
        }
        return offset;
    }

    public static String testReplace(String in, String what, String by, ReplaceOptions options, Project project2) {
        return Replacer.testReplace(in, what, by, options, project2, false);
    }

    public static String testReplace(String in, String what, String by, ReplaceOptions options, Project project2, boolean sourceIsFile) {
        LanguageFileType type = options.getMatchOptions().getFileType();
        return Replacer.testReplace(in, what, by, options, project2, sourceIsFile, false, type, null);
    }

    public static String testReplace(String in, String what, String by, ReplaceOptions replaceOptions, Project project2, boolean sourceIsFile, boolean createPhysicalFile, LanguageFileType sourceFileType, Language sourceDialect) {
        replaceOptions.setReplacement(by);
        MatchOptions matchOptions = replaceOptions.getMatchOptions();
        matchOptions.fillSearchCriteria(what);
        Matcher.validate(project2, matchOptions);
        Replacer.checkReplacementPattern(project2, replaceOptions);
        Replacer replacer = new Replacer(project2, replaceOptions);
        Matcher matcher = new Matcher(project2);
        try {
            PsiElement nextSibling;
            PsiElement parent;
            PsiElement lastElement;
            PsiElement firstElement;
            if (matchOptions.getScope() == null) {
                PsiElement[] elements = MatcherImplUtil.createTreeFromText(in, sourceIsFile ? PatternTreeContext.File : PatternTreeContext.Block, sourceFileType, sourceDialect, null, project2, createPhysicalFile);
                firstElement = elements[0];
                lastElement = elements[elements.length - 1];
                parent = firstElement.getParent();
                matchOptions.setScope((SearchScope)new LocalSearchScope(elements));
            } else {
                parent = ((LocalSearchScope)matchOptions.getScope()).getScope()[0];
                firstElement = parent.getFirstChild();
                lastElement = parent.getLastChild();
            }
            CollectingMatchResultSink sink = new CollectingMatchResultSink();
            matcher.testFindMatches(sink, matchOptions);
            SmartList resultPtrList = new SmartList();
            for (MatchResult result : sink.getMatches()) {
                resultPtrList.add(replacer.buildReplacement(result));
            }
            int startOffset = firstElement.getTextRange().getStartOffset();
            int endOffset = sourceIsFile ? 0 : parent.getTextLength() - lastElement.getTextRange().getEndOffset();
            PsiElement prevSibling = firstElement.getPrevSibling();
            if (prevSibling instanceof PsiWhiteSpace) {
                startOffset -= prevSibling.getTextLength() - 1;
            }
            if ((nextSibling = lastElement.getNextSibling()) instanceof PsiWhiteSpace) {
                endOffset -= nextSibling.getTextLength() - 1;
            }
            replacer.replaceAll((List<? extends ReplacementInfo>)resultPtrList);
            String result = parent.getText();
            result = result.substring(startOffset);
            String string = result = result.substring(0, result.length() - endOffset);
            return string;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IncorrectOperationException((Throwable)e);
        }
        finally {
            matchOptions.setScope(null);
        }
    }

    public void replaceAll(List<? extends ReplacementInfo> infos) {
        for (ReplacementInfo replacementInfo : infos) {
            this.replaceHandler.prepare(replacementInfo);
        }
        ((ApplicationImpl)ApplicationManager.getApplication()).runWriteActionWithCancellableProgressInDispatchThread(SSRBundle.message("structural.replace.title", new Object[0]), this.project, null, indicator -> {
            indicator.setIndeterminate(false);
            try {
                int size = infos.size();
                VirtualFile lastFile = null;
                for (int i = 0; i < size; ++i) {
                    indicator.checkCanceled();
                    indicator.setFraction((double)((float)(i + 1) / (float)size));
                    ReplacementInfo info = (ReplacementInfo)infos.get(i);
                    PsiElement element = info.getMatch(0);
                    if (element == null) continue;
                    VirtualFile vFile = element.getContainingFile().getVirtualFile();
                    if (vFile != null && !vFile.equals(lastFile)) {
                        indicator.setText2(vFile.getPresentableUrl());
                        lastFile = vFile;
                    }
                    ProgressManager.getInstance().executeNonCancelableSection(() -> {
                        PsiElement affectedElement = this.doReplace(info);
                        if (affectedElement != this.lastAffectedElement) {
                            if (this.lastAffectedElement != null) {
                                this.reformatAndPostProcess(this.lastAffectedElement);
                            }
                            this.lastAffectedElement = affectedElement;
                        }
                    });
                }
            }
            finally {
                ProgressManager.getInstance().executeNonCancelableSection(() -> this.reformatAndPostProcess(this.lastAffectedElement));
            }
        });
    }

    public void replace(ReplacementInfo info) {
        this.replaceHandler.prepare(info);
        this.reformatAndPostProcess(this.doReplace(info));
    }

    @Nullable
    private PsiElement doReplace(ReplacementInfo info) {
        PsiElement element = info.getMatch(0);
        if (element == null || !element.isWritable() || !element.isValid()) {
            return null;
        }
        PsiElement elementParent = StructuralSearchUtil.getPresentableElement(element).getParent();
        CodeStyleManager.getInstance((Project)this.project).performActionWithFormatterDisabled(() -> this.replaceHandler.replace(info, this.options));
        if (!elementParent.isValid() || !elementParent.isWritable()) {
            return null;
        }
        return elementParent;
    }

    private void reformatAndPostProcess(PsiElement elementParent) {
        if (elementParent == null || !elementParent.isValid()) {
            return;
        }
        PsiFile containingFile = elementParent.getContainingFile();
        if (containingFile != null && this.options.isToReformatAccordingToStyle()) {
            Document document;
            VirtualFile file = containingFile.getVirtualFile();
            if (file != null && (document = FileDocumentManager.getInstance().getDocument(file)) != null) {
                PsiDocumentManager.getInstance((Project)this.project).commitDocument(document);
            }
            int parentOffset = elementParent.getTextRange().getStartOffset();
            CodeStyleManager.getInstance((Project)this.project).reformatRange((PsiElement)containingFile, parentOffset, parentOffset + elementParent.getTextLength(), true);
        }
        this.replaceHandler.postProcess(elementParent, this.options);
    }

    public static void handleComments(PsiElement el, PsiElement replacement, ReplacementInfo replacementInfo) {
        PsiElement firstChild;
        PsiElement lastChild = el.getLastChild();
        if (lastChild instanceof PsiComment && replacementInfo.getVariableName(lastChild) == null && !(replacement.getLastChild() instanceof PsiComment)) {
            PsiElement firstElementAfterStatementEnd = lastChild;
            for (PsiElement curElement = firstElementAfterStatementEnd.getPrevSibling(); curElement != null && (curElement instanceof PsiWhiteSpace || curElement instanceof PsiComment); curElement = curElement.getPrevSibling()) {
                firstElementAfterStatementEnd = curElement;
            }
            replacement.addRangeAfter(firstElementAfterStatementEnd, lastChild, replacement.getLastChild());
        }
        if ((firstChild = el.getFirstChild()) instanceof PsiComment && !(firstChild instanceof PsiDocCommentBase) && replacementInfo.getVariableName(firstChild) == null) {
            PsiElement lastElementBeforeStatementStart = firstChild;
            for (PsiElement curElement = lastElementBeforeStatementStart.getNextSibling(); curElement != null && (curElement instanceof PsiWhiteSpace || curElement instanceof PsiComment); curElement = curElement.getNextSibling()) {
                lastElementBeforeStatementStart = curElement;
            }
            replacement.addRangeBefore(firstChild, lastElementBeforeStatementStart, replacement.getFirstChild());
        }
    }

    public static void checkReplacementPattern(Project project2, ReplaceOptions options) {
        try {
            String search = options.getMatchOptions().getSearchPattern();
            String replacement = options.getReplacement();
            LanguageFileType fileType = options.getMatchOptions().getFileType();
            Template searchTemplate = TemplateManager.getInstance((Project)project2).createTemplate("", "", search);
            Template replaceTemplate = TemplateManager.getInstance((Project)project2).createTemplate("", "", replacement);
            int segmentCount = replaceTemplate.getSegmentsCount();
            for (int i = 0; i < segmentCount; ++i) {
                String searchSegmentName;
                int j;
                String replacementSegmentName = replaceTemplate.getSegmentName(i);
                int segmentCount2 = searchTemplate.getSegmentsCount();
                for (j = 0; j < segmentCount2 && !replacementSegmentName.equals(searchSegmentName = searchTemplate.getSegmentName(j)); ++j) {
                    if (!replacementSegmentName.startsWith(searchSegmentName) || replacementSegmentName.charAt(searchSegmentName.length()) != '_') continue;
                    try {
                        Integer.parseInt(replacementSegmentName.substring(searchSegmentName.length() + 1));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (j != segmentCount2) continue;
                ReplacementVariableDefinition definition = options.getVariableDefinition(replacementSegmentName);
                if (definition == null || definition.getScriptCodeConstraint().length() <= 2) {
                    throw new MalformedPatternException(SSRBundle.message("replacement.variable.is.not.defined.message", replacementSegmentName));
                }
                String message = ScriptSupport.checkValidScript(StringUtil.unquoteString((String)definition.getScriptCodeConstraint()), options.getMatchOptions());
                if (message == null) continue;
                throw new MalformedPatternException(SSRBundle.message("replacement.variable.is.not.valid", replacementSegmentName, message));
            }
            StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByFileType(fileType);
            assert (profile2 != null);
            ReadAction.run(() -> profile2.checkReplacementPattern(project2, options));
        }
        catch (IncorrectOperationException ex) {
            throw new MalformedPatternException(SSRBundle.message("incorrect.pattern.message", new Object[0]));
        }
    }

    public ReplacementInfo buildReplacement(MatchResult result) {
        ReplacementInfoImpl replacementInfo = new ReplacementInfoImpl(result, this.project);
        replacementInfo.setReplacement(this.replacementBuilder.process(result, replacementInfo, this.options.getMatchOptions().getFileType()));
        return replacementInfo;
    }
}

