/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchScriptException;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptLog;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.jetbrains.annotations.NotNull;

public class ScriptSupport {
    static final String UUID = "a3cd264774bf4efb9ab609b250c5165c";
    private final Script script;
    private final ScriptLog myScriptLog;
    private final String myName;
    private final Collection<String> myVariableNames;

    public ScriptSupport(Project project2, String text, String name, Collection<String> variableNames, MatchOptions matchOptions) {
        this.myScriptLog = new ScriptLog(project2);
        this.myName = name;
        this.myVariableNames = variableNames;
        GroovyShell shell = ScriptSupport.createShell(matchOptions);
        try {
            File scriptFile = new File(text);
            this.script = scriptFile.exists() ? shell.parse(scriptFile) : shell.parse(text, name + UUID + ".groovy");
        }
        catch (Exception ex) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    private static GroovyShell createShell(@NotNull MatchOptions options) {
        if (options == null) {
            ScriptSupport.$$$reportNull$$$0(0);
        }
        GroovyShell groovyShell = new GroovyShell(options.getDialect().getClass().getClassLoader());
        if (groovyShell == null) {
            ScriptSupport.$$$reportNull$$$0(1);
        }
        return groovyShell;
    }

    private static Map<String, Object> buildVariableMap(@NotNull MatchResult result, @NotNull Map<String, Object> out) {
        String name;
        if (result == null) {
            ScriptSupport.$$$reportNull$$$0(2);
        }
        if (out == null) {
            ScriptSupport.$$$reportNull$$$0(3);
        }
        if ((name = result.getName()) != null && !result.isMultipleMatch()) {
            ArrayList<PsiElement> list;
            Object value = out.get(name);
            PsiElement match = StructuralSearchUtil.getPresentableElement(result.getMatch());
            if (value == null) {
                out.put(name, match);
            } else if (value instanceof List) {
                list = (ArrayList<PsiElement>)value;
                list.add(match);
            } else if (value instanceof PsiElement) {
                list = new ArrayList<PsiElement>();
                list.add((PsiElement)value);
                list.add(match);
                out.put(name, list);
            } else {
                throw new AssertionError();
            }
        }
        for (MatchResult son : result.getChildren()) {
            ScriptSupport.buildVariableMap(son, out);
        }
        return out;
    }

    public String evaluate(MatchResult result, PsiElement context) {
        try {
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            this.myVariableNames.forEach(n -> variableMap.put((String)n, null));
            variableMap.put("__log__", this.myScriptLog);
            if (result != null) {
                ScriptSupport.buildVariableMap(result.getRoot(), variableMap);
                if (context == null) {
                    context = result.getMatch();
                }
            }
            context = StructuralSearchUtil.getPresentableElement(context);
            variableMap.put(this.myName, context);
            variableMap.put("__context__", context);
            this.script.setBinding(new Binding(variableMap));
            Object o = this.script.run();
            String string = String.valueOf(o);
            return string;
        }
        catch (ProcessCanceledException | ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            Logger.getInstance(ScriptSupport.class).info("Exception thrown by Structural Search Groovy Script", t);
            throw new StructuralSearchScriptException(t);
        }
        finally {
            this.script.setBinding(null);
        }
    }

    public static String checkValidScript(@NotNull String scriptText, @NotNull MatchOptions matchOptions) {
        if (scriptText == null) {
            ScriptSupport.$$$reportNull$$$0(4);
        }
        if (matchOptions == null) {
            ScriptSupport.$$$reportNull$$$0(5);
        }
        try {
            File scriptFile = new File(scriptText);
            GroovyShell shell = ScriptSupport.createShell(matchOptions);
            Script script = scriptFile.exists() ? shell.parse(scriptFile) : shell.parse(scriptText);
            return null;
        }
        catch (IOException e) {
            return e.getMessage();
        }
        catch (MultipleCompilationErrorsException e) {
            ErrorCollector errorCollector = e.getErrorCollector();
            List errors = errorCollector.getErrors();
            for (Message error : errors) {
                if (!(error instanceof SyntaxErrorMessage)) continue;
                SyntaxErrorMessage errorMessage = (SyntaxErrorMessage)error;
                SyntaxException cause = errorMessage.getCause();
                return cause.getMessage();
            }
            return e.getMessage();
        }
        catch (CompilationFailedException ex) {
            return ex.getLocalizedMessage();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/predicates/ScriptSupport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/predicates/ScriptSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createShell";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createShell";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVariableMap";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkValidScript";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

