/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.iterators.SiblingNodeIterator;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import org.jetbrains.annotations.NotNull;

public final class TopLevelMatchingHandler
extends MatchingHandler
implements DelegatingHandler {
    private final MatchingHandler delegate;

    public TopLevelMatchingHandler(@NotNull MatchingHandler _delegate) {
        if (_delegate == null) {
            TopLevelMatchingHandler.$$$reportNull$$$0(0);
        }
        this.delegate = _delegate;
        this.setFilter(_delegate.getFilter());
    }

    @Override
    public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext matchContext) {
        PsiElement child;
        boolean matched = this.delegate.match(patternNode, matchedNode, matchContext);
        if (matched) {
            PsiElement elementToAdd = matchedNode;
            if (patternNode instanceof PsiComment && StructuralSearchUtil.isDocCommentOwner(matchedNode)) {
                elementToAdd = matchedNode.getFirstChild();
                assert (elementToAdd instanceof PsiComment);
            }
            matchContext.addMatchedNode(elementToAdd);
        }
        if ((!matched || matchContext.getOptions().isRecursiveSearch()) && matchContext.getPattern().getStrategy().continueMatching(matchedNode) && matchContext.shouldRecursivelyMatch() && (child = matchedNode.getFirstChild()) != null) {
            matchContext.getMatcher().matchContext(new SsrFilteringNodeIterator(new SiblingNodeIterator(child)));
        }
        return matched;
    }

    @Override
    public boolean canMatch(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
        return this.delegate.canMatch(patternNode, matchedNode, context);
    }

    @Override
    public boolean matchSequentially(NodeIterator patternNodes, NodeIterator matchNodes, MatchContext context) {
        return this.delegate.matchSequentially(patternNodes, matchNodes, context);
    }

    @Override
    public boolean isMatchSequentiallySucceeded(NodeIterator matchNodes) {
        return true;
    }

    @Override
    public boolean shouldAdvanceTheMatchFor(PsiElement patternElement, PsiElement matchedElement) {
        return this.delegate.shouldAdvanceTheMatchFor(patternElement, matchedElement);
    }

    @Override
    public MatchingHandler getDelegate() {
        return this.delegate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_delegate", "com/intellij/structuralsearch/impl/matcher/handlers/TopLevelMatchingHandler", "<init>"));
    }
}

