/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.FindInFilesOptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.compiler.TestModeOptimizingSearchHelper;

public class CompileContext {
    private final OptimizingSearchHelper mySearchHelper;
    private final CompiledPattern myPattern;
    private final MatchOptions myOptions;
    private final Project myProject;

    public CompileContext(CompiledPattern pattern, MatchOptions options, Project project2) {
        this.myPattern = pattern;
        this.myOptions = options;
        this.myProject = project2;
        this.mySearchHelper = ApplicationManager.getApplication().isUnitTestMode() ? new TestModeOptimizingSearchHelper() : new FindInFilesOptimizingSearchHelper(this.myOptions.getScope(), options.isCaseSensitiveMatch(), project2);
    }

    public void clear() {
        this.mySearchHelper.clear();
    }

    public OptimizingSearchHelper getSearchHelper() {
        return this.mySearchHelper;
    }

    public CompiledPattern getPattern() {
        return this.myPattern;
    }

    public MatchOptions getOptions() {
        return this.myOptions;
    }

    public Project getProject() {
        return this.myProject;
    }
}

