/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;

public class MatcherImplUtil {
    public static PsiElement[] createTreeFromText(String text, PatternTreeContext context, LanguageFileType fileType, Project project2) {
        return MatcherImplUtil.createTreeFromText(text, context, fileType, null, null, project2, false);
    }

    public static PsiElement[] createSourceTreeFromText(String text, PatternTreeContext context, LanguageFileType fileType, Project project2, boolean physical) {
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByLanguage(fileType.getLanguage());
        if (profile2 != null) {
            return profile2.createPatternTree(text, context, fileType, fileType.getLanguage(), null, project2, physical);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public static PsiElement[] createTreeFromText(String text, PatternTreeContext context, LanguageFileType fileType, Language language, PatternContext patternContext, Project project2, boolean physical) {
        StructuralSearchProfile profile2;
        if (language == null) {
            language = fileType.getLanguage();
        }
        if ((profile2 = StructuralSearchUtil.getProfileByLanguage(language)) != null) {
            String contextId = patternContext == null ? null : patternContext.getId();
            return profile2.createPatternTree(text, context, fileType, language, contextId, project2, physical);
        }
        return PsiElement.EMPTY_ARRAY;
    }
}

