/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.AbstractMatchingVisitor;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SingleNodeIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalMatchingVisitor
extends AbstractMatchingVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor");
    public static final Key<List<? extends PsiElement>> UNMATCHED_ELEMENTS_KEY = Key.create((String)"UnmatchedElements");
    private PsiElement myElement;
    private boolean myResult;
    private MatchContext matchContext;
    private final Map<Language, PsiElementVisitor> myLanguage2MatchingVisitor = new HashMap<Language, PsiElementVisitor>(1);

    public PsiElement getElement() {
        return this.myElement;
    }

    public boolean getResult() {
        return this.myResult;
    }

    @Contract(value="true->true;false->false")
    public boolean setResult(boolean result) {
        this.myResult = result;
        return this.myResult;
    }

    public MatchContext getMatchContext() {
        return this.matchContext;
    }

    @Override
    protected boolean doMatchInAnyOrder(@NotNull NodeIterator elements, @NotNull NodeIterator elements2) {
        if (elements == null) {
            GlobalMatchingVisitor.$$$reportNull$$$0(0);
        }
        if (elements2 == null) {
            GlobalMatchingVisitor.$$$reportNull$$$0(1);
        }
        return this.matchContext.getPattern().getHandler(elements.current()).matchInAnyOrder(elements, elements2, this.matchContext);
    }

    @Override
    public boolean matchOptionally(@Nullable PsiElement patternNode, @Nullable PsiElement matchNode) {
        return patternNode == null && this.isLeftLooseMatching() || this.matchSequentially(SingleNodeIterator.newSingleNodeIterator(patternNode), SingleNodeIterator.newSingleNodeIterator(matchNode));
    }

    @Override
    @NotNull
    protected NodeFilter getNodeFilter() {
        NodeFilter nodeFilter = LexicalNodesFilter.getInstance();
        if (nodeFilter == null) {
            GlobalMatchingVisitor.$$$reportNull$$$0(2);
        }
        return nodeFilter;
    }

    public final boolean handleTypedElement(PsiElement typedElement, PsiElement match) {
        MatchingHandler handler;
        MatchingHandler initialHandler = handler = this.matchContext.getPattern().getHandler(typedElement);
        if (handler instanceof DelegatingHandler) {
            handler = ((DelegatingHandler)((Object)handler)).getDelegate();
        }
        assert (handler instanceof SubstitutionHandler) : handler != null ? handler.getClass() : "null " + (initialHandler != null ? initialHandler.getClass() : "null");
        return ((SubstitutionHandler)handler).handle(match, this.matchContext);
    }

    public boolean allowsAbsenceOfMatch(PsiElement element) {
        MatchingHandler handler = this.getMatchContext().getPattern().getHandler(element);
        return handler instanceof SubstitutionHandler && ((SubstitutionHandler)handler).getMinOccurs() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean match(PsiElement el1, PsiElement el2) {
        if (el1 == el2) {
            return true;
        }
        if (el1 == null) {
            return true;
        }
        if (el2 == null) {
            return this.allowsAbsenceOfMatch(el1);
        }
        PsiElement prevElement = this.myElement;
        this.myElement = el2;
        try {
            PsiElementVisitor visitor = this.getVisitorForElement(el1);
            if (visitor != null) {
                el1.accept(visitor);
            }
        }
        catch (ClassCastException ex) {
            this.myResult = false;
        }
        finally {
            this.myElement = prevElement;
        }
        return this.myResult;
    }

    @Nullable
    private PsiElementVisitor getVisitorForElement(PsiElement element) {
        Language language = element.getLanguage();
        PsiElementVisitor visitor = this.myLanguage2MatchingVisitor.get(language);
        if (visitor == null) {
            visitor = this.createMatchingVisitor(language);
            this.myLanguage2MatchingVisitor.put(language, visitor);
        }
        return visitor;
    }

    @Nullable
    private PsiElementVisitor createMatchingVisitor(Language language) {
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByLanguage(language);
        if (profile2 == null) {
            LOG.warn("there is no StructuralSearchProfile for language " + language.getID());
            return null;
        }
        return profile2.createMatchingVisitor(this);
    }

    @Override
    public boolean matchSequentially(@NotNull NodeIterator patternNodes, @NotNull NodeIterator matchNodes) {
        if (patternNodes == null) {
            GlobalMatchingVisitor.$$$reportNull$$$0(3);
        }
        if (matchNodes == null) {
            GlobalMatchingVisitor.$$$reportNull$$$0(4);
        }
        if (!patternNodes.hasNext()) {
            while (matchNodes.current() instanceof PsiComment) {
                matchNodes.advance();
            }
            return !matchNodes.hasNext();
        }
        PsiElement current = patternNodes.current();
        return this.matchContext.getPattern().getHandler(current).matchSequentially(patternNodes, matchNodes, this.matchContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void matchContext(@NotNull NodeIterator elements) {
        if (elements == null) {
            GlobalMatchingVisitor.$$$reportNull$$$0(5);
        }
        CompiledPattern pattern = this.matchContext.getPattern();
        NodeIterator patternNodes = pattern.getNodes().clone();
        MatchResultImpl saveResult = this.matchContext.hasResult() ? this.matchContext.getResult() : null;
        this.matchContext.saveMatchedNodes();
        try {
            if (!patternNodes.hasNext()) {
                return;
            }
            MatchingHandler firstMatchingHandler = pattern.getHandler(patternNodes.current());
            while (elements.hasNext()) {
                MatchingHandler matchingHandler;
                this.matchContext.setResult(null);
                this.matchContext.clearMatchedNodes();
                PsiElement elementNode = elements.current();
                boolean patternMatched = firstMatchingHandler.matchSequentially(patternNodes, elements, this.matchContext);
                boolean contextMatched = patternMatched ? (matchingHandler = pattern.getHandler("__context__")) == null || ((SubstitutionHandler)matchingHandler).handle(elementNode, this.matchContext) : false;
                if (contextMatched) {
                    this.matchContext.dispatchMatched();
                }
                patternNodes.reset();
                if (patternMatched) {
                    elements.rewind();
                }
                elements.advance();
            }
        }
        finally {
            this.matchContext.setResult(saveResult);
            this.matchContext.restoreMatchedNodes();
        }
    }

    public void setMatchContext(MatchContext matchContext) {
        this.matchContext = matchContext;
    }

    @Override
    public boolean isLeftLooseMatching() {
        return this.matchContext.getOptions().isLooseMatching();
    }

    @Override
    public boolean isRightLooseMatching() {
        return false;
    }

    public boolean matchText(@Nullable PsiElement left, @Nullable PsiElement right) {
        if (left == null) {
            return right == null;
        }
        return right != null && this.matchText(left.getText(), right.getText());
    }

    public boolean matchText(String left, String right) {
        return this.matchContext.getOptions().isCaseSensitiveMatch() ? left.equals(right) : left.equalsIgnoreCase(right);
    }

    public void scopeMatch(PsiElement patternNode, boolean typedVar, PsiElement matchNode) {
        MatchResultImpl ourResult = this.matchContext.hasResult() ? this.matchContext.getResult() : null;
        this.matchContext.popResult();
        if (this.myResult) {
            if (typedVar) {
                SubstitutionHandler handler = (SubstitutionHandler)this.matchContext.getPattern().getHandler(patternNode);
                if (ourResult != null) {
                    ourResult.setScopeMatch(true);
                }
                handler.setNestedResult(ourResult);
                this.setResult(handler.handle(matchNode, this.matchContext));
                MatchResultImpl nestedResult = handler.getNestedResult();
                if (nestedResult != null) {
                    this.copyResults(nestedResult);
                    handler.setNestedResult(null);
                }
            } else if (ourResult != null) {
                this.copyResults(ourResult);
            }
        }
    }

    private void copyResults(MatchResult ourResult) {
        MatchResultImpl result = this.matchContext.getResult();
        for (MatchResult son : ourResult.getChildren()) {
            result.addChild(son);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/GlobalMatchingVisitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternNodes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/GlobalMatchingVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doMatchInAnyOrder";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "matchSequentially";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matchContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

