/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.XmlContextType;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.PredefinedConfigurationUtil;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.XmlCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.XmlMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.XmlCompilingVisitor;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacerUtil;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlStructuralSearchProfile
extends StructuralSearchProfile {
    @Override
    public void compile(PsiElement[] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(0);
        }
        new XmlCompilingVisitor(globalVisitor).compile(elements);
    }

    @Override
    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(1);
        }
        XmlMatchingVisitor xmlMatchingVisitor = new XmlMatchingVisitor(globalVisitor);
        if (xmlMatchingVisitor == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(2);
        }
        return xmlMatchingVisitor;
    }

    @Override
    public boolean isIdentifier(@Nullable PsiElement element) {
        return element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_NAME;
    }

    @Override
    @NotNull
    public String getTypedVarString(PsiElement element) {
        String string = element instanceof XmlText ? element.getText().trim() : super.getTypedVarString(element);
        if (string == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public NodeFilter getLexicalNodesFilter() {
        NodeFilter nodeFilter = element -> {
            if (element instanceof XmlText) {
                PsiElement child = element.getFirstChild();
                return child == element.getLastChild() && child instanceof PsiWhiteSpace;
            }
            return element instanceof PsiWhiteSpace || element instanceof PsiErrorElement;
        };
        if (nodeFilter == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(4);
        }
        return nodeFilter;
    }

    @Override
    @NotNull
    public CompiledPattern createCompiledPattern() {
        XmlCompiledPattern xmlCompiledPattern = new XmlCompiledPattern();
        if (xmlCompiledPattern == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(5);
        }
        return xmlCompiledPattern;
    }

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(6);
        }
        return language instanceof XMLLanguage;
    }

    @Override
    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull LanguageFileType fileType, @NotNull Language language, String contextId, @NotNull Project project2, boolean physical) {
        if (text == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(7);
        }
        if (context == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(8);
        }
        if (fileType == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(9);
        }
        if (language == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(10);
        }
        if (project2 == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(11);
        }
        text = context == PatternTreeContext.File ? text : "<QQQ>" + text + "</QQQ>";
        String fileName = "dummy." + fileType.getDefaultExtension();
        PsiFile fileFromText = PsiFileFactory.getInstance((Project)project2).createFileFromText(fileName, (FileType)fileType, (CharSequence)text, LocalTimeCounter.currentTime(), physical, true);
        XmlDocument document = HtmlUtil.getRealXmlDocument((XmlDocument)((XmlFile)fileFromText).getDocument());
        if (context == PatternTreeContext.File) {
            PsiElement[] psiElementArray = new PsiElement[]{document};
            if (psiElementArray == null) {
                XmlStructuralSearchProfile.$$$reportNull$$$0(12);
            }
            return psiElementArray;
        }
        XmlTagChild[] xmlTagChildArray = document.getRootTag().getValue().getChildren();
        if (xmlTagChildArray == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(13);
        }
        return xmlTagChildArray;
    }

    @Override
    @NotNull
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        if (XmlContextType.class == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(14);
        }
        return XmlContextType.class;
    }

    @Override
    @NotNull
    public LanguageFileType detectFileType(@NotNull PsiElement context) {
        Language contextLanguage;
        if (context == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(15);
        }
        PsiFile file = context instanceof PsiFile ? (PsiFile)context : context.getContainingFile();
        Language language = contextLanguage = context instanceof PsiFile ? null : context.getLanguage();
        if (file.getLanguage() == StdLanguages.HTML || file.getFileType() == StdFileTypes.JSP && contextLanguage == StdLanguages.HTML) {
            LanguageFileType languageFileType = StdFileTypes.HTML;
            if (languageFileType == null) {
                XmlStructuralSearchProfile.$$$reportNull$$$0(16);
            }
            return languageFileType;
        }
        LanguageFileType languageFileType = StdFileTypes.XML;
        if (languageFileType == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(17);
        }
        return languageFileType;
    }

    @Override
    public void checkSearchPattern(CompiledPattern pattern) {
        ValidatingVisitor visitor = new ValidatingVisitor();
        NodeIterator nodes = pattern.getNodes();
        while (nodes.hasNext()) {
            nodes.current().accept((PsiElementVisitor)visitor);
            nodes.advance();
        }
        nodes.reset();
    }

    @Override
    public void checkReplacementPattern(Project project2, ReplaceOptions options) {
    }

    @Override
    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project2, @NotNull ReplaceOptions replaceOptions) {
        if (project2 == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(18);
        }
        if (replaceOptions == null) {
            XmlStructuralSearchProfile.$$$reportNull$$$0(19);
        }
        return new XmlReplaceHandler(project2, replaceOptions);
    }

    @Override
    public Configuration[] getPredefinedTemplates() {
        return XmlPredefinedConfigurations.createPredefinedTemplates();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/XmlStructuralSearchProfile";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/XmlStructuralSearchProfile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMatchingVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexicalNodesFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompiledPattern";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternTree";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateContextTypeClass";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createMatchingVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPatternTree";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "detectFileType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class XmlPredefinedConfigurations {
        private static final String HTML_XML = SSRBundle.message("xml_html.category", new Object[0]);

        private XmlPredefinedConfigurations() {
        }

        static Configuration[] createPredefinedTemplates() {
            return new Configuration[]{PredefinedConfigurationUtil.createSearchTemplateInfo("xml tag", "<'a/>", HTML_XML, StdFileTypes.XML), PredefinedConfigurationUtil.createSearchTemplateInfo("xml attribute", "<'_tag 'attribute=\"'_value\"/>", HTML_XML, StdFileTypes.XML), PredefinedConfigurationUtil.createSearchTemplateInfo("html attribute", "<'_tag 'attribute />", HTML_XML, StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("xml attribute value", "<'_tag '_attribute=\"'value\"/>", HTML_XML, StdFileTypes.XML), PredefinedConfigurationUtil.createSearchTemplateInfo("html attribute value", "<'_tag '_attribute='value />", HTML_XML, StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("xml/html tag value", "<table>'_content*</table>", HTML_XML, StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("<ul> or <ol>", "<'_tag:[regex( ul|ol )] />", HTML_XML, StdFileTypes.HTML), PredefinedConfigurationUtil.createSearchTemplateInfo("<li> not contained in <ul> or <ol>", "[!within( \"<ul> or <ol>\" )]<li />", HTML_XML, StdFileTypes.HTML)};
        }
    }

    private static class XmlReplaceHandler
    extends StructuralReplaceHandler {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ReplaceOptions myReplaceOptions;

        XmlReplaceHandler(@NotNull Project project2, @NotNull ReplaceOptions replaceOptions) {
            if (project2 == null) {
                XmlReplaceHandler.$$$reportNull$$$0(0);
            }
            if (replaceOptions == null) {
                XmlReplaceHandler.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myReplaceOptions = replaceOptions;
        }

        @Override
        public void replace(ReplacementInfo info, ReplaceOptions options) {
            PsiElement elementToReplace = StructuralSearchUtil.getPresentableElement(info.getMatch(0));
            assert (elementToReplace != null);
            String replacementToMake = info.getReplacement();
            PsiElement elementParent = elementToReplace.getParent();
            boolean listContext = elementParent instanceof XmlTag;
            if (listContext) {
                this.doReplaceInContext(info, elementToReplace, replacementToMake, elementParent);
            } else {
                PsiElement[] replacements = MatcherImplUtil.createTreeFromText(replacementToMake, PatternTreeContext.Block, this.myReplaceOptions.getMatchOptions().getFileType(), this.myProject);
                if (replacements.length > 0) {
                    PsiElement replacement = ReplacerUtil.copySpacesAndCommentsBefore(elementToReplace, replacements, replacementToMake, elementParent);
                    Replacer.handleComments(elementToReplace, replacement, info);
                    elementToReplace.replace(replacement);
                } else {
                    elementToReplace.delete();
                }
            }
        }

        private void doReplaceInContext(ReplacementInfo info, PsiElement elementToReplace, String replacementToMake, PsiElement elementParent) {
            PsiElement[] replacements = MatcherImplUtil.createTreeFromText(replacementToMake, PatternTreeContext.Block, this.myReplaceOptions.getMatchOptions().getFileType(), this.myProject);
            if (replacements.length > 1) {
                elementParent.addRangeBefore(replacements[0], replacements[replacements.length - 1], elementToReplace);
            } else if (replacements.length == 1) {
                Replacer.handleComments(elementToReplace, replacements[0], info);
                try {
                    elementParent.addBefore(replacements[0], elementToReplace);
                }
                catch (IncorrectOperationException e) {
                    elementToReplace.replace(replacements[0]);
                }
            }
            int matchSize = info.getMatchesCount();
            for (int i = 0; i < matchSize; ++i) {
                PsiElement element = StructuralSearchUtil.getPresentableElement(info.getMatch(i));
                PsiElement prevSibling = element.getPrevSibling();
                element.getParent().deleteChildRange(XmlReplaceHandler.isWhitespace(prevSibling) ? prevSibling : element, element);
            }
        }

        private static boolean isWhitespace(PsiElement element) {
            PsiElement lastChild;
            if (element instanceof PsiWhiteSpace) {
                return true;
            }
            if (!(element instanceof XmlText)) {
                return false;
            }
            PsiElement firstChild = element.getFirstChild();
            return firstChild == (lastChild = element.getLastChild()) && firstChild instanceof PsiWhiteSpace;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "replaceOptions";
                    break;
                }
            }
            objectArray[1] = "com/intellij/structuralsearch/XmlStructuralSearchProfile$XmlReplaceHandler";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ValidatingVisitor
    extends PsiRecursiveElementWalkingVisitor {
        ValidatingVisitor() {
        }

        public void visitErrorElement(PsiErrorElement element) {
            super.visitErrorElement(element);
            String errorDescription = element.getErrorDescription();
            PsiElement parent = element.getParent();
            if (parent instanceof XmlAttribute && "'=' expected".equals(errorDescription)) {
                return;
            }
            if (parent instanceof XmlTag && errorDescription.startsWith("Element") && errorDescription.endsWith(" is not closed")) {
                return;
            }
            throw new MalformedPatternException(errorDescription);
        }
    }
}

