/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ui.ColumnInfo;
import java.util.Comparator;

public class PercentageCoverageColumnInfo
extends ColumnInfo<NodeDescriptor, String> {
    private final int myColumnIdx;
    private final Comparator<NodeDescriptor> myComparator;
    private final CoverageSuitesBundle mySuitesBundle;
    private final CoverageViewManager.StateBean myStateBean;

    public PercentageCoverageColumnInfo(int columnIdx, String name, CoverageSuitesBundle suitesBundle, CoverageViewManager.StateBean stateBean) {
        super(name);
        this.myColumnIdx = columnIdx;
        this.myComparator = (o1, o2) -> {
            String val1 = this.valueOf((NodeDescriptor)o1);
            String val2 = this.valueOf((NodeDescriptor)o2);
            if (val1 != null && val2 != null) {
                int percentageIndex1 = val1.indexOf(37);
                int percentageIndex2 = val2.indexOf(37);
                if (percentageIndex1 > -1 && percentageIndex2 > -1) {
                    String percentage1 = val1.substring(0, percentageIndex1);
                    String percentage2 = val2.substring(0, percentageIndex2);
                    int compare = Comparing.compare((double)Double.parseDouble(percentage1), (double)Double.parseDouble(percentage2));
                    if (compare == 0) {
                        int total1 = val1.indexOf(47);
                        int total2 = val2.indexOf(47);
                        if (total1 > -1 && total2 > -1) {
                            int r1 = val1.indexOf(41, total1);
                            int r2 = val2.indexOf(41, total2);
                            if (r1 > -1 && r2 > -1) {
                                return Comparing.compare((double)Double.parseDouble(val1.substring(total1 + 1, r1)), (double)Double.parseDouble(val2.substring(total2 + 1, r2)));
                            }
                        }
                    }
                    return compare;
                }
                if (percentageIndex1 > -1) {
                    return 1;
                }
                if (percentageIndex2 > -1) {
                    return -1;
                }
            }
            return Comparing.compare((Comparable)((Object)val1), (Comparable)((Object)val2));
        };
        this.mySuitesBundle = suitesBundle;
        this.myStateBean = stateBean;
    }

    public String valueOf(NodeDescriptor node) {
        CoverageEngine coverageEngine = this.mySuitesBundle.getCoverageEngine();
        Project project2 = node.getProject();
        return coverageEngine.createCoverageViewExtension(project2, this.mySuitesBundle, this.myStateBean).getPercentage(this.myColumnIdx, (AbstractTreeNode)node);
    }

    public Comparator<NodeDescriptor> getComparator() {
        return this.myComparator;
    }
}

