/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.CommonBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageTableModel;
import com.intellij.coverage.view.CoverageViewBuilder;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewTreeStructure;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.impl.RunDialog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CoverageView
extends BorderLayoutPanel
implements DataProvider,
Disposable {
    @NonNls
    private static final String ACTION_DRILL_DOWN = "DrillDown";
    @NonNls
    private static final String ACTION_GO_UP = "GoUp";
    @NonNls
    public static final String HELP_ID = "reference.toolWindows.Coverage";
    private final CoverageTableModel myModel;
    private final JBTable myTable;
    private final CoverageViewBuilder myBuilder;
    private final Project myProject;
    private final CoverageViewManager.StateBean myStateBean;

    public CoverageView(final Project project2, CoverageDataManager dataManager, CoverageViewManager.StateBean stateBean) {
        this.myProject = project2;
        this.myStateBean = stateBean;
        JLabel titleLabel = new JLabel();
        titleLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        CoverageSuitesBundle suitesBundle = dataManager.getCurrentSuitesBundle();
        this.myModel = new CoverageTableModel(suitesBundle, stateBean, project2);
        this.myTable = new JBTable((TableModel)this.myModel);
        StatusText emptyText = this.myTable.getEmptyText();
        emptyText.setText("No coverage results.");
        final RunConfigurationBase configuration = suitesBundle.getRunConfiguration();
        if (configuration != null) {
            emptyText.appendText(" Click ");
            emptyText.appendText("Edit", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RunnerAndConfigurationSettings configurationSettings = RunManager.getInstance((Project)project2).findSettings((RunConfiguration)configuration);
                    if (configurationSettings != null) {
                        RunDialog.editConfiguration((Project)project2, (RunnerAndConfigurationSettings)configurationSettings, (String)"Edit Run Configuration");
                    } else {
                        Messages.showErrorDialog((Project)project2, (String)("Configuration '" + configuration.getName() + "' was not found"), (String)CommonBundle.getErrorTitle());
                    }
                }
            });
            emptyText.appendText(" to fix configuration settings.");
        }
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn nameColumn = columnModel.getColumn(0);
        nameColumn.setCellRenderer(new NodeDescriptorTableCellRenderer());
        nameColumn.setPreferredWidth(this.myStateBean.myElementSize);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        BorderLayoutPanel centerPanel = JBUI.Panels.simplePanel().addToCenter((Component)ScrollPaneFactory.createScrollPane((Component)this.myTable)).addToTop((Component)titleLabel);
        this.addToCenter((Component)centerPanel);
        final CoverageViewTreeStructure structure = new CoverageViewTreeStructure(project2, suitesBundle, stateBean);
        this.myBuilder = new CoverageViewBuilder(project2, (JList)new JBList(), this.myModel, structure, this.myTable);
        this.myBuilder.setParentTitle(titleLabel);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                CoverageView.this.drillDown(structure);
                return true;
            }
        }.installOn((Component)this.myTable);
        TableSpeedSearch speedSearch = new TableSpeedSearch((JTable)this.myTable);
        speedSearch.setClearSearchOnNavigateNoMatch(true);
        PopupHandler.installUnknownPopupHandler((JComponent)this.myTable, (ActionGroup)CoverageView.createPopupGroup(), (ActionManager)ActionManager.getInstance());
        ScrollingUtil.installActions((JTable)this.myTable);
        this.myTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CoverageView.this.myBuilder == null) {
                    return;
                }
                CoverageView.this.myBuilder.buildRoot();
            }
        }, KeyStroke.getKeyStroke(92, SystemInfo.isMac ? 4 : 2), 0);
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), ACTION_DRILL_DOWN);
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(34, SystemInfo.isMac ? 4 : 2), ACTION_DRILL_DOWN);
        this.myTable.getActionMap().put(ACTION_DRILL_DOWN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageView.this.drillDown(structure);
            }
        });
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(33, SystemInfo.isMac ? 4 : 2), ACTION_GO_UP);
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(8, 0), ACTION_GO_UP);
        this.myTable.getActionMap().put(ACTION_GO_UP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageView.this.goUp();
            }
        });
        JComponent component = ActionManager.getInstance().createActionToolbar("CoverageView", this.createToolbarActions(structure), false).getComponent();
        this.addToLeft(component);
    }

    public void dispose() {
        if (!this.myProject.isDisposed()) {
            CoverageDataManager.getInstance(this.myProject).chooseSuitesBundle(null);
        }
    }

    public void saveSize() {
        this.myStateBean.myElementSize = this.myTable.getColumnModel().getColumn(0).getWidth();
    }

    private static ActionGroup createPopupGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("EditSource"));
        return actionGroup;
    }

    private ActionGroup createToolbarActions(CoverageViewTreeStructure treeStructure) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new GoUpAction(treeStructure));
        if (treeStructure.supportFlattenPackages()) {
            actionGroup.add((AnAction)new FlattenPackagesAction());
        }
        this.installAutoScrollToSource(actionGroup);
        this.installAutoScrollFromSource(actionGroup);
        actionGroup.add(ActionManager.getInstance().getAction("GenerateCoverageReport"));
        return actionGroup;
    }

    private void installAutoScrollFromSource(DefaultActionGroup actionGroup) {
        MyAutoScrollFromSourceHandler handler = new MyAutoScrollFromSourceHandler();
        handler.install();
        actionGroup.add((AnAction)handler.createToggleAction());
    }

    private void installAutoScrollToSource(DefaultActionGroup actionGroup) {
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return ((CoverageView)CoverageView.this).myStateBean.myAutoScrollToSource;
            }

            protected void setAutoScrollMode(boolean state) {
                ((CoverageView)CoverageView.this).myStateBean.myAutoScrollToSource = state;
            }
        };
        autoScrollToSourceHandler.install((JTable)this.myTable);
        actionGroup.add((AnAction)autoScrollToSourceHandler.createToggleAction());
    }

    public void goUp() {
        if (this.myBuilder == null) {
            return;
        }
        this.myBuilder.goUp();
    }

    private void drillDown(CoverageViewTreeStructure treeStructure) {
        AbstractTreeNode element = this.getSelectedValue();
        if (element == null) {
            return;
        }
        if (treeStructure.getChildElements(element).length == 0) {
            if (element.canNavigate()) {
                element.navigate(true);
            }
            return;
        }
        this.myBuilder.drillDown();
    }

    public void updateParentTitle() {
        this.myBuilder.updateParentTitle();
    }

    private AbstractTreeNode getSelectedValue() {
        return (AbstractTreeNode)this.myBuilder.getSelectedValue();
    }

    private boolean topElementIsSelected(CoverageViewTreeStructure treeStructure) {
        if (this.myTable == null) {
            return false;
        }
        if (this.myModel.getSize() >= 1) {
            AbstractTreeNode rootElement = (AbstractTreeNode)treeStructure.getRootElement();
            AbstractTreeNode node = (AbstractTreeNode)this.myModel.getElementAt(0);
            if (node.getParent() == rootElement) {
                return true;
            }
        }
        return false;
    }

    public boolean canSelect(VirtualFile file) {
        return this.myBuilder.canSelect(file);
    }

    public void select(VirtualFile file) {
        this.myBuilder.select(file);
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            CoverageView.$$$reportNull$$$0(0);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.getSelectedValue();
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/coverage/view/CoverageView", "getData"));
    }

    private class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        MyAutoScrollFromSourceHandler() {
            super(CoverageView.this.myProject, (JComponent)((Object)CoverageView.this), (Disposable)CoverageView.this);
        }

        protected boolean isAutoScrollEnabled() {
            return ((CoverageView)CoverageView.this).myStateBean.myAutoScrollFromSource;
        }

        protected void setAutoScrollEnabled(boolean state) {
            ((CoverageView)CoverageView.this).myStateBean.myAutoScrollFromSource = state;
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            VirtualFile file;
            if (editor == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(0);
            }
            if (this.myProject.isDisposed() || !CoverageView.this.isShowing()) {
                return;
            }
            if (((CoverageView)CoverageView.this).myStateBean.myAutoScrollFromSource && (file = FileEditorManagerEx.getInstanceEx((Project)this.myProject).getFile(editor)) != null && CoverageView.this.canSelect(file)) {
                VirtualFile e = null;
                if (editor instanceof TextEditor) {
                    int offset = ((TextEditor)editor).getEditor().getCaretModel().getOffset();
                    PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                    PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
                    if (psiFile != null) {
                        e = psiFile.findElementAt(offset);
                    }
                }
                CoverageView.this.myBuilder.select(e != null ? e : file);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/coverage/view/CoverageView$MyAutoScrollFromSourceHandler", "selectElementFromEditor"));
        }
    }

    private class GoUpAction
    extends DumbAwareAction {
        private final CoverageViewTreeStructure myTreeStructure;

        GoUpAction(CoverageViewTreeStructure treeStructure) {
            super("Go Up", "Go to Upper Level", AllIcons.Nodes.UpLevel);
            this.myTreeStructure = treeStructure;
            this.registerCustomShortcutSet(8, 0, (JComponent)CoverageView.this.myTable);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GoUpAction.$$$reportNull$$$0(0);
            }
            CoverageView.this.goUp();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GoUpAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(!CoverageView.this.topElementIsSelected(this.myTreeStructure));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/view/CoverageView$GoUpAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class FlattenPackagesAction
    extends ToggleAction {
        private FlattenPackagesAction() {
            super("Flatten Packages", "Flatten Packages", AllIcons.ObjectBrowser.FlattenPackages);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                FlattenPackagesAction.$$$reportNull$$$0(0);
            }
            return ((CoverageView)CoverageView.this).myStateBean.myFlattenPackages;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                FlattenPackagesAction.$$$reportNull$$$0(1);
            }
            ((CoverageView)CoverageView.this).myStateBean.myFlattenPackages = state;
            Object selectedValue = CoverageView.this.myBuilder.getSelectedValue();
            CoverageView.this.myBuilder.buildRoot();
            if (selectedValue != null) {
                CoverageView.this.myBuilder.select(((CoverageListNode)((Object)selectedValue)).getValue());
            }
            CoverageView.this.myBuilder.ensureSelectionExist();
            CoverageView.this.myBuilder.updateParentTitle();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/view/CoverageView$FlattenPackagesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NodeDescriptorTableCellRenderer
    extends DefaultTableCellRenderer {
        private NodeDescriptorTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof NodeDescriptor) {
                NodeDescriptor descriptor = (NodeDescriptor)value;
                this.setIcon(descriptor.getIcon());
                this.setText(descriptor.toString());
                if (!isSelected) {
                    this.setForeground(((CoverageListNode)descriptor).getFileStatus().getColor());
                }
            }
            return component;
        }
    }
}

