/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import android.content.res.BridgeAssetManager;
import android.graphics.Bitmap;
import android.graphics.FontFamily_Delegate;
import android.graphics.Typeface;
import android.icu.util.ULocale;
import android.os.Looper;
import android.os.Looper_Accessor;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.android.ide.common.rendering.api.Capability;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.internal.R;
import com.android.layoutlib.bridge.BridgeRenderSession;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.bridge.impl.RenderDrawable;
import com.android.layoutlib.bridge.impl.RenderSessionImpl;
import com.android.layoutlib.bridge.util.DynamicIdMap;
import com.android.ninepatch.NinePatchChunk;
import com.android.resources.ResourceType;
import com.android.tools.layoutlib.create.MethodAdapter;
import com.android.tools.layoutlib.create.OverrideMethod;
import com.android.util.Pair;
import java.io.File;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import libcore.io.MemoryMappedFile_Delegate;

public final class Bridge
extends com.android.ide.common.rendering.api.Bridge {
    private static final String ICU_LOCALE_DIRECTION_RTL = "right-to-left";
    private static final ReentrantLock sLock = new ReentrantLock();
    private static final Map<Integer, Pair<ResourceType, String>> sRMap = new HashMap<Integer, Pair<ResourceType, String>>();
    private static final Map<ResourceType, Map<String, Integer>> sRevRMap = new EnumMap<ResourceType, Map<String, Integer>>(ResourceType.class);
    private static final int DYNAMIC_ID_SEED_START = 0x1FF0000;
    private static final DynamicIdMap sDynamicIds = new DynamicIdMap(0x1FF0000);
    private static final Map<Object, Map<String, SoftReference<Bitmap>>> sProjectBitmapCache = new WeakHashMap<Object, Map<String, SoftReference<Bitmap>>>();
    private static final Map<Object, Map<String, SoftReference<NinePatchChunk>>> sProject9PatchCache = new WeakHashMap<Object, Map<String, SoftReference<NinePatchChunk>>>();
    private static final Map<String, SoftReference<Bitmap>> sFrameworkBitmapCache = new HashMap<String, SoftReference<Bitmap>>();
    private static final Map<String, SoftReference<NinePatchChunk>> sFramework9PatchCache = new HashMap<String, SoftReference<NinePatchChunk>>();
    private static Map<String, Map<String, Integer>> sEnumValueMap;
    private static Map<String, String> sPlatformProperties;
    private static final LayoutLog sDefaultLog;
    private static LayoutLog sCurrentLog;
    private static final int LAST_SUPPORTED_FEATURE = 19;

    public int getApiLevel() {
        return 17;
    }

    @Deprecated
    public EnumSet<Capability> getCapabilities() {
        return EnumSet.allOf(Capability.class);
    }

    public boolean supports(int feature) {
        return feature <= 19;
    }

    public boolean init(Map<String, String> platformProperties, File fontLocation, Map<String, Map<String, Integer>> enumValueMap, LayoutLog log) {
        sPlatformProperties = platformProperties;
        sEnumValueMap = enumValueMap;
        BridgeAssetManager.initSystem();
        final String debug = System.getenv("DEBUG_LAYOUT");
        if (debug != null && !debug.equals("0") && !debug.equals("false")) {
            OverrideMethod.setDefaultListener(new MethodAdapter(){

                @Override
                public void onInvokeV(String signature, boolean isNative, Object caller) {
                    sDefaultLog.error(null, "Missing Stub: " + signature + (isNative ? " (native)" : ""), null);
                    if (debug.equalsIgnoreCase("throw")) {
                        throw new StaticMethodNotImplementedException(signature);
                    }
                }
            });
        }
        FontFamily_Delegate.setFontLocation(fontLocation.getAbsolutePath());
        MemoryMappedFile_Delegate.setDataDir(fontLocation.getAbsoluteFile().getParentFile());
        try {
            Class<R> r = R.class;
            Bridge.parseStyleable();
            for (Class<?> inner : r.getDeclaredClasses()) {
                String resTypeName;
                ResourceType resType;
                if (inner == R.styleable.class || (resType = ResourceType.getEnum((String)(resTypeName = inner.getSimpleName()))) == null) continue;
                Map<String, Integer> fullMap = null;
                switch (resType) {
                    case ATTR: {
                        fullMap = sRevRMap.get(ResourceType.ATTR);
                        break;
                    }
                    case STRING: 
                    case STYLE: {
                        fullMap = new HashMap<String, Integer>(1280);
                    }
                    default: {
                        if (fullMap == null) {
                            fullMap = new HashMap<String, Integer>();
                        }
                        sRevRMap.put(resType, fullMap);
                    }
                }
                for (Field f : inner.getDeclaredFields()) {
                    Class<?> type;
                    if (!Bridge.isValidRField(f) || (type = f.getType()).isArray()) continue;
                    Integer value = (Integer)f.get(null);
                    sRMap.put(value, (Pair<ResourceType, String>)Pair.of((Object)resType, (Object)f.getName()));
                    fullMap.put(f.getName(), value);
                }
            }
        }
        catch (Exception throwable) {
            if (log != null) {
                log.error("broken", "Failed to load com.android.internal.R from the layout library jar", (Throwable)throwable, null);
            }
            return false;
        }
        return true;
    }

    private static boolean isValidRField(Field field) {
        int modifiers = field.getModifiers();
        boolean isAcceptable = Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers);
        Class<?> type = field.getType();
        return isAcceptable && type == Integer.TYPE || type.isArray() && type.getComponentType() == Integer.TYPE;
    }

    private static void parseStyleable() throws Exception {
        HashMap<String, Integer> revRAttrMap = new HashMap<String, Integer>(2048);
        sRevRMap.put(ResourceType.ATTR, revRAttrMap);
        HashMap<String, Integer> revRStyleableMap = new HashMap<String, Integer>(3072);
        sRevRMap.put(ResourceType.STYLEABLE, revRStyleableMap);
        Class<R.styleable> c = R.styleable.class;
        Field[] fields = c.getDeclaredFields();
        Arrays.sort(fields, (o1, o2) -> {
            if (o1 == o2) {
                return 0;
            }
            Class<?> t1 = o1.getType();
            Class<?> t2 = o2.getType();
            if (t1.isArray() && !t2.isArray()) {
                return -1;
            }
            if (t2.isArray() && !t1.isArray()) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        });
        HashMap<String, int[]> styleables = new HashMap<String, int[]>();
        for (Field field : fields) {
            int index;
            if (!Bridge.isValidRField(field)) continue;
            String name = field.getName();
            if (field.getType().isArray()) {
                int[] styleableValue = (int[])field.get(null);
                styleables.put(name, styleableValue);
                continue;
            }
            String arrayName = name;
            int[] arrayValue = null;
            while ((index = arrayName.lastIndexOf(95)) >= 0 && (arrayValue = (int[])styleables.get(arrayName = arrayName.substring(0, index))) == null) {
            }
            index = (Integer)field.get(null);
            if (arrayValue != null) {
                String attrName = name.substring(arrayName.length() + 1);
                int attrValue = arrayValue[index];
                sRMap.put(attrValue, (Pair<ResourceType, String>)Pair.of((Object)ResourceType.ATTR, (Object)attrName));
                revRAttrMap.put(attrName, attrValue);
            }
            sRMap.put(index, (Pair<ResourceType, String>)Pair.of((Object)ResourceType.STYLEABLE, (Object)name));
            revRStyleableMap.put(name, index);
        }
    }

    public boolean dispose() {
        BridgeAssetManager.clearSystem();
        Typeface.sDynamicTypefaceCache.evictAll();
        sProject9PatchCache.clear();
        sProjectBitmapCache.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderSession createSession(SessionParams params) {
        try {
            Result lastResult;
            RenderSessionImpl scene = new RenderSessionImpl(params);
            try {
                Bridge.prepareThread();
                lastResult = scene.init(params.getTimeout());
                if (lastResult.isSuccess()) {
                    lastResult = scene.inflate();
                    boolean doNotRenderOnCreate = Boolean.TRUE.equals(params.getFlag(RenderParamsFlags.FLAG_DO_NOT_RENDER_ON_CREATE));
                    if (lastResult.isSuccess() && !doNotRenderOnCreate) {
                        lastResult = scene.render(true);
                    }
                }
            }
            finally {
                scene.release();
                Bridge.cleanupThread();
            }
            return new BridgeRenderSession(scene, lastResult);
        }
        catch (Throwable t) {
            Throwable t2 = t;
            while (t2.getCause() != null) {
                t2 = t2.getCause();
            }
            return new BridgeRenderSession(null, Result.Status.ERROR_UNKNOWN.createResult(t2.getMessage(), t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result renderDrawable(DrawableParams params) {
        try {
            Result lastResult;
            RenderDrawable action = new RenderDrawable(params);
            try {
                Bridge.prepareThread();
                lastResult = action.init(params.getTimeout());
                if (lastResult.isSuccess()) {
                    lastResult = action.render();
                }
            }
            finally {
                action.release();
                Bridge.cleanupThread();
            }
            return lastResult;
        }
        catch (Throwable t) {
            Throwable t2 = t;
            while (t2.getCause() != null) {
                t2 = t.getCause();
            }
            return Result.Status.ERROR_UNKNOWN.createResult(t2.getMessage(), t);
        }
    }

    public void clearCaches(Object projectKey) {
        if (projectKey != null) {
            sProjectBitmapCache.remove(projectKey);
            sProject9PatchCache.remove(projectKey);
        }
    }

    public Result getViewParent(Object viewObject) {
        if (viewObject instanceof View) {
            return Result.Status.SUCCESS.createResult((Object)((View)viewObject).getParent());
        }
        throw new IllegalArgumentException("viewObject is not a View");
    }

    public Result getViewIndex(Object viewObject) {
        if (viewObject instanceof View) {
            View view = (View)viewObject;
            ViewParent parentView = view.getParent();
            if (parentView instanceof ViewGroup) {
                Result.Status.SUCCESS.createResult((Object)((ViewGroup)parentView).indexOfChild(view));
            }
            return Result.Status.SUCCESS.createResult();
        }
        throw new IllegalArgumentException("viewObject is not a View");
    }

    public boolean isRtl(String locale) {
        return Bridge.isLocaleRtl(locale);
    }

    public static boolean isLocaleRtl(String locale) {
        if (locale == null) {
            locale = "";
        }
        ULocale uLocale = new ULocale(locale);
        return uLocale.getCharacterOrientation().equals(ICU_LOCALE_DIRECTION_RTL);
    }

    public static ReentrantLock getLock() {
        return sLock;
    }

    public static synchronized void prepareThread() {
        if (Looper.myLooper() == null) {
            Looper.prepareMainLooper();
        }
    }

    public static synchronized void cleanupThread() {
        Looper_Accessor.cleanupThread();
    }

    public static LayoutLog getLog() {
        return sCurrentLog;
    }

    public static void setLog(LayoutLog log) {
        if (!sLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("scene must be acquired first. see #acquire(long)");
        }
        sCurrentLog = log != null ? log : sDefaultLog;
    }

    public static ResourceReference resolveResourceId(int value) {
        Pair<ResourceType, String> pair = sRMap.get(value);
        if (pair == null) {
            pair = sDynamicIds.resolveId(value);
        }
        if (pair != null) {
            return new ResourceReference(ResourceNamespace.ANDROID, (ResourceType)pair.getFirst(), (String)pair.getSecond());
        }
        return null;
    }

    public static int getResourceId(ResourceType type, String name) {
        Map<String, Integer> map = sRevRMap.get(type);
        Integer value = map == null ? null : map.get(name);
        return value == null ? sDynamicIds.getId(type, name) : value;
    }

    public static Map<String, Integer> getEnumValues(String attributeName) {
        if (sEnumValueMap != null) {
            return sEnumValueMap.get(attributeName);
        }
        return null;
    }

    public static Map<String, String> getPlatformProperties() {
        return sPlatformProperties;
    }

    public static Bitmap getCachedBitmap(String value, Object projectKey) {
        if (projectKey != null) {
            SoftReference<Bitmap> ref;
            Map<String, SoftReference<Bitmap>> map = sProjectBitmapCache.get(projectKey);
            if (map != null && (ref = map.get(value)) != null) {
                return ref.get();
            }
        } else {
            SoftReference<Bitmap> ref = sFrameworkBitmapCache.get(value);
            if (ref != null) {
                return ref.get();
            }
        }
        return null;
    }

    public static void setCachedBitmap(String value, Bitmap bmp, Object projectKey) {
        if (projectKey != null) {
            Map map = sProjectBitmapCache.computeIfAbsent(projectKey, k -> new HashMap());
            map.put(value, new SoftReference<Bitmap>(bmp));
        } else {
            sFrameworkBitmapCache.put(value, new SoftReference<Bitmap>(bmp));
        }
    }

    public static NinePatchChunk getCached9Patch(String value, Object projectKey) {
        if (projectKey != null) {
            SoftReference<NinePatchChunk> ref;
            Map<String, SoftReference<NinePatchChunk>> map = sProject9PatchCache.get(projectKey);
            if (map != null && (ref = map.get(value)) != null) {
                return ref.get();
            }
        } else {
            SoftReference<NinePatchChunk> ref = sFramework9PatchCache.get(value);
            if (ref != null) {
                return ref.get();
            }
        }
        return null;
    }

    public static void setCached9Patch(String value, NinePatchChunk ninePatch, Object projectKey) {
        if (projectKey != null) {
            Map map = sProject9PatchCache.computeIfAbsent(projectKey, k -> new HashMap());
            map.put(value, new SoftReference<NinePatchChunk>(ninePatch));
        } else {
            sFramework9PatchCache.put(value, new SoftReference<NinePatchChunk>(ninePatch));
        }
    }

    static {
        sCurrentLog = sDefaultLog = new LayoutLog(){

            public void error(String tag, String message, Object data) {
                System.err.println(message);
            }

            public void error(String tag, String message, Throwable throwable, Object data) {
                System.err.println(message);
            }

            public void warning(String tag, String message, Object data) {
                System.out.println(message);
            }
        };
    }

    public static class StaticMethodNotImplementedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public StaticMethodNotImplementedException(String msg) {
            super(msg);
        }
    }
}

