/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.SystemClock;

public abstract class KernelUidCpuTimeReaderBase<T extends Callback> {
    protected static final boolean DEBUG = false;
    private static final long DEFAULT_THROTTLE_INTERVAL = 10000L;
    private final String TAG = this.getClass().getSimpleName();
    private long mLastTimeReadMs = Long.MIN_VALUE;
    private long mThrottleInterval = 10000L;

    public void readDelta(T cb) {
        if (SystemClock.elapsedRealtime() < this.mLastTimeReadMs + this.mThrottleInterval) {
            return;
        }
        this.readDeltaImpl(cb);
        this.mLastTimeReadMs = SystemClock.elapsedRealtime();
    }

    protected abstract void readDeltaImpl(T var1);

    public void setThrottleInterval(long throttleInterval) {
        if (throttleInterval >= 0L) {
            this.mThrottleInterval = throttleInterval;
        }
    }

    public static interface Callback {
    }
}

