/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManagerInternal;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os._Original_Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebViewFactory;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.LocalServices;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@VisibleForTesting
public class WebViewLibraryLoader {
    private static final String LOGTAG = WebViewLibraryLoader.class.getSimpleName();
    private static final String CHROMIUM_WEBVIEW_NATIVE_RELRO_32 = "/data/misc/shared_relro/libwebviewchromium32.relro";
    private static final String CHROMIUM_WEBVIEW_NATIVE_RELRO_64 = "/data/misc/shared_relro/libwebviewchromium64.relro";
    private static final long CHROMIUM_WEBVIEW_DEFAULT_VMSIZE_BYTES = 0x6400000L;
    private static final boolean DEBUG = false;
    private static boolean sAddressSpaceReserved = false;

    static void createRelroFile(boolean is64Bit, WebViewNativeLibrary nativeLib) {
        final String abi = is64Bit ? _Original_Build.SUPPORTED_64_BIT_ABIS[0] : _Original_Build.SUPPORTED_32_BIT_ABIS[0];
        Runnable crashHandler = new Runnable(){

            @Override
            public void run() {
                try {
                    Log.e(LOGTAG, "relro file creator for " + abi + " crashed. Proceeding without");
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted();
                }
                catch (RemoteException e) {
                    Log.e(LOGTAG, "Cannot reach WebViewUpdateService. " + e.getMessage());
                }
            }
        };
        try {
            if (nativeLib == null || nativeLib.path == null) {
                throw new IllegalArgumentException("Native library paths to the WebView RelRo process must not be null!");
            }
            boolean success = LocalServices.getService(ActivityManagerInternal.class).startIsolatedProcess(RelroFileCreator.class.getName(), new String[]{nativeLib.path}, "WebViewLoader-" + abi, abi, 1037, crashHandler);
            if (!success) {
                throw new Exception("Failed to start the relro file creator process");
            }
        }
        catch (Throwable t) {
            Log.e(LOGTAG, "error starting relro file creator for abi " + abi, t);
            crashHandler.run();
        }
    }

    static int prepareNativeLibraries(PackageInfo webviewPackageInfo) throws WebViewFactory.MissingWebViewPackageException {
        WebViewNativeLibrary nativeLib32bit = WebViewLibraryLoader.getWebViewNativeLibrary(webviewPackageInfo, false);
        WebViewNativeLibrary nativeLib64bit = WebViewLibraryLoader.getWebViewNativeLibrary(webviewPackageInfo, true);
        WebViewLibraryLoader.updateWebViewZygoteVmSize(nativeLib32bit, nativeLib64bit);
        return WebViewLibraryLoader.createRelros(nativeLib32bit, nativeLib64bit);
    }

    private static int createRelros(WebViewNativeLibrary nativeLib32bit, WebViewNativeLibrary nativeLib64bit) {
        int numRelros = 0;
        if (_Original_Build.SUPPORTED_32_BIT_ABIS.length > 0) {
            if (nativeLib32bit == null) {
                Log.e(LOGTAG, "No 32-bit WebView library path, skipping relro creation.");
            } else {
                WebViewLibraryLoader.createRelroFile(false, nativeLib32bit);
                ++numRelros;
            }
        }
        if (_Original_Build.SUPPORTED_64_BIT_ABIS.length > 0) {
            if (nativeLib64bit == null) {
                Log.e(LOGTAG, "No 64-bit WebView library path, skipping relro creation.");
            } else {
                WebViewLibraryLoader.createRelroFile(true, nativeLib64bit);
                ++numRelros;
            }
        }
        return numRelros;
    }

    private static void updateWebViewZygoteVmSize(WebViewNativeLibrary nativeLib32bit, WebViewNativeLibrary nativeLib64bit) throws WebViewFactory.MissingWebViewPackageException {
        long newVmSize = 0L;
        if (nativeLib32bit != null) {
            newVmSize = Math.max(newVmSize, nativeLib32bit.size);
        }
        if (nativeLib64bit != null) {
            newVmSize = Math.max(newVmSize, nativeLib64bit.size);
        }
        newVmSize = Math.max(2L * newVmSize, 0x6400000L);
        Log.d(LOGTAG, "Setting new address space to " + newVmSize);
        WebViewLibraryLoader.setWebViewZygoteVmSize(newVmSize);
    }

    static void reserveAddressSpaceInZygote() {
        System.loadLibrary("webviewchromium_loader");
        long addressSpaceToReserve = SystemProperties.getLong("persist.sys.webview.vmsize", 0x6400000L);
        sAddressSpaceReserved = WebViewLibraryLoader.nativeReserveAddressSpace(addressSpaceToReserve);
        if (!sAddressSpaceReserved) {
            Log.e(LOGTAG, "reserving " + addressSpaceToReserve + " bytes of address space failed");
        }
    }

    public static int loadNativeLibrary(ClassLoader clazzLoader, String libraryFileName) {
        if (!sAddressSpaceReserved) {
            Log.e(LOGTAG, "can't load with relro file; address space not reserved");
            return 2;
        }
        String relroPath = VMRuntime.getRuntime().is64Bit() ? CHROMIUM_WEBVIEW_NATIVE_RELRO_64 : CHROMIUM_WEBVIEW_NATIVE_RELRO_32;
        int result = WebViewLibraryLoader.nativeLoadWithRelroFile(libraryFileName, relroPath, clazzLoader);
        if (result != 0) {
            Log.w(LOGTAG, "failed to load with relro file, proceeding without");
        }
        return result;
    }

    @VisibleForTesting
    public static WebViewNativeLibrary getWebViewNativeLibrary(PackageInfo packageInfo, boolean is64bit) throws WebViewFactory.MissingWebViewPackageException {
        ApplicationInfo ai = packageInfo.applicationInfo;
        String nativeLibFileName = WebViewFactory.getWebViewLibrary(ai);
        String dir = WebViewLibraryLoader.getWebViewNativeLibraryDirectory(ai, is64bit);
        WebViewNativeLibrary lib = WebViewLibraryLoader.findNativeLibrary(ai, nativeLibFileName, is64bit ? _Original_Build.SUPPORTED_64_BIT_ABIS : _Original_Build.SUPPORTED_32_BIT_ABIS, dir);
        return lib;
    }

    @VisibleForTesting
    public static String getWebViewNativeLibraryDirectory(ApplicationInfo ai, boolean is64bit) {
        if (is64bit == VMRuntime.is64BitAbi(ai.primaryCpuAbi)) {
            return ai.nativeLibraryDir;
        }
        if (!TextUtils.isEmpty(ai.secondaryCpuAbi)) {
            return ai.secondaryNativeLibraryDir;
        }
        return "";
    }

    private static WebViewNativeLibrary findNativeLibrary(ApplicationInfo ai, String nativeLibFileName, String[] abiList, String libDirectory) throws WebViewFactory.MissingWebViewPackageException {
        if (TextUtils.isEmpty(libDirectory)) {
            return null;
        }
        String libPath = libDirectory + "/" + nativeLibFileName;
        File f = new File(libPath);
        if (f.exists()) {
            return new WebViewNativeLibrary(libPath, f.length());
        }
        return WebViewLibraryLoader.getLoadFromApkPath(ai.sourceDir, abiList, nativeLibFileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static WebViewNativeLibrary getLoadFromApkPath(String apkPath, String[] abiList, String nativeLibFileName) throws WebViewFactory.MissingWebViewPackageException {
        try (ZipFile z = new ZipFile(apkPath);){
            String[] stringArray = abiList;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String abi = stringArray[n2];
                String entry = "lib/" + abi + "/" + nativeLibFileName;
                ZipEntry e = z.getEntry(entry);
                if (e != null && e.getMethod() == 0) {
                    WebViewNativeLibrary webViewNativeLibrary = new WebViewNativeLibrary(apkPath + "!/" + entry, e.getSize());
                    return webViewNativeLibrary;
                }
                ++n2;
            }
            return null;
        }
        catch (IOException e) {
            throw new WebViewFactory.MissingWebViewPackageException(e);
        }
    }

    private static void setWebViewZygoteVmSize(long vmSize) {
        SystemProperties.set("persist.sys.webview.vmsize", Long.toString(vmSize));
    }

    static boolean nativeReserveAddressSpace(long l) {
        return OverrideMethod.invokeI("android.webkit.WebViewLibraryLoader#nativeReserveAddressSpace(J)Z", true, null) != 0;
    }

    static boolean nativeCreateRelroFile(String string2, String string3) {
        return OverrideMethod.invokeI("android.webkit.WebViewLibraryLoader#nativeCreateRelroFile(Ljava/lang/String;Ljava/lang/String;)Z", true, null) != 0;
    }

    static int nativeLoadWithRelroFile(String string2, String string3, ClassLoader classLoader) {
        return OverrideMethod.invokeI("android.webkit.WebViewLibraryLoader#nativeLoadWithRelroFile(Ljava/lang/String;Ljava/lang/String;Ljava/lang/ClassLoader;)I", true, null);
    }

    @VisibleForTesting
    public static class WebViewNativeLibrary {
        public final String path;
        public final long size;

        WebViewNativeLibrary(String path, long size) {
            this.path = path;
            this.size = size;
        }
    }

    private static class RelroFileCreator {
        private RelroFileCreator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            boolean result = false;
            boolean is64Bit = VMRuntime.getRuntime().is64Bit();
            try {
                if (args.length != 1 || args[0] == null) {
                    Log.e(LOGTAG, "Invalid RelroFileCreator args: " + Arrays.toString(args));
                    return;
                }
                Log.v(LOGTAG, "RelroFileCreator (64bit = " + is64Bit + "), lib: " + args[0]);
                if (!sAddressSpaceReserved) {
                    Log.e(LOGTAG, "can't create relro file; address space not reserved");
                    return;
                }
                result = WebViewLibraryLoader.nativeCreateRelroFile(args[0], is64Bit ? WebViewLibraryLoader.CHROMIUM_WEBVIEW_NATIVE_RELRO_64 : WebViewLibraryLoader.CHROMIUM_WEBVIEW_NATIVE_RELRO_32);
                if (result) {
                    // empty if block
                }
            }
            finally {
                try {
                    WebViewFactory.getUpdateServiceUnchecked().notifyRelroCreationCompleted();
                }
                catch (RemoteException e) {
                    Log.e(LOGTAG, "error notifying update service", e);
                }
                if (!result) {
                    Log.e(LOGTAG, "failed to create relro file");
                }
                System.exit(0);
            }
        }
    }
}

