/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

class AmbientShadowConfig {
    private final int mWidth;
    private final int mHeight;
    private final float mEdgeScale;
    private final float mShadowBoundRatio;
    private final float mShadowStrength;
    private final float[] mPolygon;
    private final int mRays;
    private final int mLayers;

    private AmbientShadowConfig(Builder builder) {
        this.mEdgeScale = builder.mEdgeScale;
        this.mShadowBoundRatio = builder.mShadowBoundRatio;
        this.mShadowStrength = builder.mShadowStrength;
        this.mRays = builder.mRays;
        this.mLayers = builder.mLayers;
        this.mWidth = builder.mWidth;
        this.mHeight = builder.mHeight;
        this.mPolygon = builder.mPolygon;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public float getEdgeScale() {
        return this.mEdgeScale;
    }

    public float getShadowBoundRatio() {
        return this.mShadowBoundRatio;
    }

    public float getShadowStrength() {
        return this.mShadowStrength;
    }

    public float[] getPolygon() {
        return this.mPolygon;
    }

    public int getRays() {
        return this.mRays;
    }

    public int getLayers() {
        return this.mLayers;
    }

    public static class Builder {
        private float mEdgeScale;
        private float mShadowBoundRatio;
        private float mShadowStrength;
        private int mRays;
        private int mLayers;
        private float[] mPolygon;
        private int mWidth;
        private int mHeight;

        public Builder setEdgeScale(float edgeScale) {
            this.mEdgeScale = edgeScale;
            return this;
        }

        public Builder setShadowBoundRatio(float shadowBoundRatio) {
            this.mShadowBoundRatio = shadowBoundRatio;
            return this;
        }

        public Builder setShadowStrength(float shadowStrength) {
            this.mShadowStrength = shadowStrength;
            return this;
        }

        public Builder setRays(int rays) {
            this.mRays = rays;
            return this;
        }

        public Builder setLayers(int layers) {
            this.mLayers = layers;
            return this;
        }

        public Builder setSize(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
            return this;
        }

        public Builder setPolygon(float[] polygon) {
            this.mPolygon = polygon;
            return this;
        }

        public AmbientShadowConfig build() {
            return new AmbientShadowConfig(this);
        }
    }
}

