/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.view.DisplayListCanvas;
import android.view.RenderNodeAnimator;
import android.view.RenderNode_Delegate;
import android.view.SurfaceView;
import android.view.View;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import libcore.util.NativeAllocationRegistry;

public class RenderNode {
    final long mNativeRenderNode;
    private final View mOwningView;

    private RenderNode(String name, View owningView) {
        this.mNativeRenderNode = RenderNode.nCreate(name);
        NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativeRenderNode);
        this.mOwningView = owningView;
    }

    private RenderNode(long nativePtr) {
        this.mNativeRenderNode = nativePtr;
        NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativeRenderNode);
        this.mOwningView = null;
    }

    public void destroy() {
    }

    public static RenderNode create(String name, View owningView) {
        return new RenderNode(name, owningView);
    }

    public static RenderNode adopt(long nativePtr) {
        return new RenderNode(nativePtr);
    }

    public void requestPositionUpdates(SurfaceView view) {
        RenderNode.nRequestPositionUpdates(this.mNativeRenderNode, view);
    }

    public DisplayListCanvas start(int width, int height) {
        return DisplayListCanvas.obtain(this, width, height);
    }

    public void end(DisplayListCanvas canvas) {
        long displayList = canvas.finishRecording();
        RenderNode.nSetDisplayList(this.mNativeRenderNode, displayList);
        canvas.recycle();
    }

    public void discardDisplayList() {
        RenderNode.nSetDisplayList(this.mNativeRenderNode, 0L);
    }

    public boolean isValid() {
        return RenderNode.nIsValid(this.mNativeRenderNode);
    }

    long getNativeDisplayList() {
        if (!this.isValid()) {
            throw new IllegalStateException("The display list is not valid.");
        }
        return this.mNativeRenderNode;
    }

    public boolean hasIdentityMatrix() {
        return RenderNode.nHasIdentityMatrix(this.mNativeRenderNode);
    }

    public void getMatrix_Original(Matrix outMatrix) {
        RenderNode.nGetTransformMatrix(this.mNativeRenderNode, outMatrix.native_instance);
    }

    @LayoutlibDelegate
    public void getMatrix(Matrix matrix) {
        RenderNode_Delegate.getMatrix(this, matrix);
    }

    public void getInverseMatrix(Matrix outMatrix) {
        RenderNode.nGetInverseTransformMatrix(this.mNativeRenderNode, outMatrix.native_instance);
    }

    public boolean setLayerType(int layerType) {
        return RenderNode.nSetLayerType(this.mNativeRenderNode, layerType);
    }

    public boolean setLayerPaint(Paint paint) {
        return RenderNode.nSetLayerPaint(this.mNativeRenderNode, paint != null ? paint.getNativeInstance() : 0L);
    }

    public boolean setClipBounds(Rect rect) {
        if (rect == null) {
            return RenderNode.nSetClipBoundsEmpty(this.mNativeRenderNode);
        }
        return RenderNode.nSetClipBounds(this.mNativeRenderNode, rect.left, rect.top, rect.right, rect.bottom);
    }

    public boolean setClipToBounds(boolean clipToBounds) {
        return RenderNode.nSetClipToBounds(this.mNativeRenderNode, clipToBounds);
    }

    public boolean setProjectBackwards(boolean shouldProject) {
        return RenderNode.nSetProjectBackwards(this.mNativeRenderNode, shouldProject);
    }

    public boolean setProjectionReceiver(boolean shouldRecieve) {
        return RenderNode.nSetProjectionReceiver(this.mNativeRenderNode, shouldRecieve);
    }

    public boolean setOutline(Outline outline) {
        if (outline == null) {
            return RenderNode.nSetOutlineNone(this.mNativeRenderNode);
        }
        switch (outline.mMode) {
            case 0: {
                return RenderNode.nSetOutlineEmpty(this.mNativeRenderNode);
            }
            case 1: {
                return RenderNode.nSetOutlineRoundRect(this.mNativeRenderNode, outline.mRect.left, outline.mRect.top, outline.mRect.right, outline.mRect.bottom, outline.mRadius, outline.mAlpha);
            }
            case 2: {
                return RenderNode.nSetOutlineConvexPath(this.mNativeRenderNode, outline.mPath.mNativePath, outline.mAlpha);
            }
        }
        throw new IllegalArgumentException("Unrecognized outline?");
    }

    public boolean hasShadow() {
        return RenderNode.nHasShadow(this.mNativeRenderNode);
    }

    public boolean setSpotShadowColor(int color2) {
        return RenderNode.nSetSpotShadowColor(this.mNativeRenderNode, color2);
    }

    public boolean setAmbientShadowColor(int color2) {
        return RenderNode.nSetAmbientShadowColor(this.mNativeRenderNode, color2);
    }

    public int getSpotShadowColor() {
        return RenderNode.nGetSpotShadowColor(this.mNativeRenderNode);
    }

    public int getAmbientShadowColor() {
        return RenderNode.nGetAmbientShadowColor(this.mNativeRenderNode);
    }

    public boolean setClipToOutline(boolean clipToOutline) {
        return RenderNode.nSetClipToOutline(this.mNativeRenderNode, clipToOutline);
    }

    public boolean getClipToOutline() {
        return RenderNode.nGetClipToOutline(this.mNativeRenderNode);
    }

    public boolean setRevealClip(boolean shouldClip, float x, float y, float radius) {
        return RenderNode.nSetRevealClip(this.mNativeRenderNode, shouldClip, x, y, radius);
    }

    public boolean setStaticMatrix(Matrix matrix) {
        return RenderNode.nSetStaticMatrix(this.mNativeRenderNode, matrix.native_instance);
    }

    public boolean setAnimationMatrix(Matrix matrix) {
        return RenderNode.nSetAnimationMatrix(this.mNativeRenderNode, matrix != null ? matrix.native_instance : 0L);
    }

    public boolean setAlpha(float alpha) {
        return RenderNode.nSetAlpha(this.mNativeRenderNode, alpha);
    }

    public float getAlpha() {
        return RenderNode.nGetAlpha(this.mNativeRenderNode);
    }

    public boolean setHasOverlappingRendering(boolean hasOverlappingRendering) {
        return RenderNode.nSetHasOverlappingRendering(this.mNativeRenderNode, hasOverlappingRendering);
    }

    public boolean hasOverlappingRendering() {
        return RenderNode.nHasOverlappingRendering(this.mNativeRenderNode);
    }

    public boolean setElevation(float lift) {
        return RenderNode.nSetElevation(this.mNativeRenderNode, lift);
    }

    public float getElevation() {
        return RenderNode.nGetElevation(this.mNativeRenderNode);
    }

    public boolean setTranslationX(float translationX) {
        return RenderNode.nSetTranslationX(this.mNativeRenderNode, translationX);
    }

    public float getTranslationX() {
        return RenderNode.nGetTranslationX(this.mNativeRenderNode);
    }

    public boolean setTranslationY(float translationY) {
        return RenderNode.nSetTranslationY(this.mNativeRenderNode, translationY);
    }

    public float getTranslationY() {
        return RenderNode.nGetTranslationY(this.mNativeRenderNode);
    }

    public boolean setTranslationZ(float translationZ) {
        return RenderNode.nSetTranslationZ(this.mNativeRenderNode, translationZ);
    }

    public float getTranslationZ() {
        return RenderNode.nGetTranslationZ(this.mNativeRenderNode);
    }

    public boolean setRotation(float rotation) {
        return RenderNode.nSetRotation(this.mNativeRenderNode, rotation);
    }

    public float getRotation() {
        return RenderNode.nGetRotation(this.mNativeRenderNode);
    }

    public boolean setRotationX(float rotationX) {
        return RenderNode.nSetRotationX(this.mNativeRenderNode, rotationX);
    }

    public float getRotationX() {
        return RenderNode.nGetRotationX(this.mNativeRenderNode);
    }

    public boolean setRotationY(float rotationY) {
        return RenderNode.nSetRotationY(this.mNativeRenderNode, rotationY);
    }

    public float getRotationY() {
        return RenderNode.nGetRotationY(this.mNativeRenderNode);
    }

    public boolean setScaleX(float scaleX) {
        return RenderNode.nSetScaleX(this.mNativeRenderNode, scaleX);
    }

    public float getScaleX() {
        return RenderNode.nGetScaleX(this.mNativeRenderNode);
    }

    public boolean setScaleY(float scaleY) {
        return RenderNode.nSetScaleY(this.mNativeRenderNode, scaleY);
    }

    public float getScaleY() {
        return RenderNode.nGetScaleY(this.mNativeRenderNode);
    }

    public boolean setPivotX(float pivotX) {
        return RenderNode.nSetPivotX(this.mNativeRenderNode, pivotX);
    }

    public float getPivotX() {
        return RenderNode.nGetPivotX(this.mNativeRenderNode);
    }

    public boolean setPivotY(float pivotY) {
        return RenderNode.nSetPivotY(this.mNativeRenderNode, pivotY);
    }

    public float getPivotY() {
        return RenderNode.nGetPivotY(this.mNativeRenderNode);
    }

    public boolean isPivotExplicitlySet() {
        return RenderNode.nIsPivotExplicitlySet(this.mNativeRenderNode);
    }

    public boolean resetPivot() {
        return RenderNode.nResetPivot(this.mNativeRenderNode);
    }

    public boolean setCameraDistance(float distance) {
        return RenderNode.nSetCameraDistance(this.mNativeRenderNode, distance);
    }

    public float getCameraDistance() {
        return RenderNode.nGetCameraDistance(this.mNativeRenderNode);
    }

    public boolean setLeft(int left) {
        return RenderNode.nSetLeft(this.mNativeRenderNode, left);
    }

    public boolean setTop(int top) {
        return RenderNode.nSetTop(this.mNativeRenderNode, top);
    }

    public boolean setRight(int right) {
        return RenderNode.nSetRight(this.mNativeRenderNode, right);
    }

    public boolean setBottom(int bottom) {
        return RenderNode.nSetBottom(this.mNativeRenderNode, bottom);
    }

    public boolean setLeftTopRightBottom(int left, int top, int right, int bottom) {
        return RenderNode.nSetLeftTopRightBottom(this.mNativeRenderNode, left, top, right, bottom);
    }

    public boolean offsetLeftAndRight(int offset) {
        return RenderNode.nOffsetLeftAndRight(this.mNativeRenderNode, offset);
    }

    public boolean offsetTopAndBottom(int offset) {
        return RenderNode.nOffsetTopAndBottom(this.mNativeRenderNode, offset);
    }

    public void output() {
        RenderNode.nOutput(this.mNativeRenderNode);
    }

    public int getDebugSize() {
        return RenderNode.nGetDebugSize(this.mNativeRenderNode);
    }

    public void addAnimator(RenderNodeAnimator animator2) {
        if (this.mOwningView == null || this.mOwningView.mAttachInfo == null) {
            throw new IllegalStateException("Cannot start this animator on a detached view!");
        }
        RenderNode.nAddAnimator(this.mNativeRenderNode, animator2.getNativeAnimator());
        this.mOwningView.mAttachInfo.mViewRootImpl.registerAnimatingRenderNode(this);
    }

    public boolean isAttached() {
        return this.mOwningView != null && this.mOwningView.mAttachInfo != null;
    }

    public void registerVectorDrawableAnimator(AnimatedVectorDrawable.VectorDrawableAnimatorRT animatorSet) {
        if (this.mOwningView == null || this.mOwningView.mAttachInfo == null) {
            throw new IllegalStateException("Cannot start this animator on a detached view!");
        }
        this.mOwningView.mAttachInfo.mViewRootImpl.registerVectorDrawableAnimator(animatorSet);
    }

    public void endAllAnimators() {
        RenderNode.nEndAllAnimators(this.mNativeRenderNode);
    }

    @LayoutlibDelegate
    private static long nCreate(String string2) {
        return RenderNode_Delegate.nCreate(string2);
    }

    @LayoutlibDelegate
    private static long nGetNativeFinalizer() {
        return RenderNode_Delegate.nGetNativeFinalizer();
    }

    private static void nOutput(long l) {
        OverrideMethod.invokeV("android.view.RenderNode#nOutput(J)V", true, null);
    }

    private static int nGetDebugSize(long l) {
        return OverrideMethod.invokeI("android.view.RenderNode#nGetDebugSize(J)I", true, null);
    }

    private static void nRequestPositionUpdates(long l, SurfaceView surfaceView) {
        OverrideMethod.invokeV("android.view.RenderNode#nRequestPositionUpdates(JLandroid/view/SurfaceView;)V", true, null);
    }

    private static void nAddAnimator(long l, long l2) {
        OverrideMethod.invokeV("android.view.RenderNode#nAddAnimator(JJ)V", true, null);
    }

    private static void nEndAllAnimators(long l) {
        OverrideMethod.invokeV("android.view.RenderNode#nEndAllAnimators(J)V", true, null);
    }

    @FastNative
    private static void nSetDisplayList(long l, long l2) {
        OverrideMethod.invokeV("android.view.RenderNode#nSetDisplayList(JJ)V", true, null);
    }

    @CriticalNative
    private static boolean nIsValid(long l) {
        return OverrideMethod.invokeI("android.view.RenderNode#nIsValid(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static void nGetTransformMatrix(long l, long l2) {
        OverrideMethod.invokeV("android.view.RenderNode#nGetTransformMatrix(JJ)V", true, null);
    }

    @CriticalNative
    private static void nGetInverseTransformMatrix(long l, long l2) {
        OverrideMethod.invokeV("android.view.RenderNode#nGetInverseTransformMatrix(JJ)V", true, null);
    }

    @CriticalNative
    private static boolean nHasIdentityMatrix(long l) {
        return OverrideMethod.invokeI("android.view.RenderNode#nHasIdentityMatrix(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nOffsetTopAndBottom(long l, int n) {
        return OverrideMethod.invokeI("android.view.RenderNode#nOffsetTopAndBottom(JI)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nOffsetLeftAndRight(long l, int n) {
        return OverrideMethod.invokeI("android.view.RenderNode#nOffsetLeftAndRight(JI)Z", true, null) != 0;
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetLeftTopRightBottom(long l, int n, int n2, int n3, int n4) {
        return RenderNode_Delegate.nSetLeftTopRightBottom(l, n, n2, n3, n4);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetBottom(long l, int n) {
        return RenderNode_Delegate.nSetBottom(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetRight(long l, int n) {
        return RenderNode_Delegate.nSetRight(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetTop(long l, int n) {
        return RenderNode_Delegate.nSetTop(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetLeft(long l, int n) {
        return RenderNode_Delegate.nSetLeft(l, n);
    }

    @CriticalNative
    private static boolean nSetCameraDistance(long l, float f) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetCameraDistance(JF)Z", true, null) != 0;
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetPivotY(long l, float f) {
        return RenderNode_Delegate.nSetPivotY(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetPivotX(long l, float f) {
        return RenderNode_Delegate.nSetPivotX(l, f);
    }

    @CriticalNative
    private static boolean nResetPivot(long l) {
        return OverrideMethod.invokeI("android.view.RenderNode#nResetPivot(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetLayerType(long l, int n) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetLayerType(JI)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetLayerPaint(long l, long l2) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetLayerPaint(JJ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetClipToBounds(long l, boolean bl) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetClipToBounds(JZ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetClipBounds(long l, int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetClipBounds(JIIII)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetClipBoundsEmpty(long l) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetClipBoundsEmpty(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetProjectBackwards(long l, boolean bl) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetProjectBackwards(JZ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetProjectionReceiver(long l, boolean bl) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetProjectionReceiver(JZ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetOutlineRoundRect(long l, int n, int n2, int n3, int n4, float f, float f2) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetOutlineRoundRect(JIIIIFF)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetOutlineConvexPath(long l, long l2, float f) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetOutlineConvexPath(JJF)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetOutlineEmpty(long l) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetOutlineEmpty(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetOutlineNone(long l) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetOutlineNone(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nHasShadow(long l) {
        return OverrideMethod.invokeI("android.view.RenderNode#nHasShadow(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetSpotShadowColor(long l, int n) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetSpotShadowColor(JI)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetAmbientShadowColor(long l, int n) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetAmbientShadowColor(JI)Z", true, null) != 0;
    }

    @CriticalNative
    private static int nGetSpotShadowColor(long l) {
        return OverrideMethod.invokeI("android.view.RenderNode#nGetSpotShadowColor(J)I", true, null);
    }

    @CriticalNative
    private static int nGetAmbientShadowColor(long l) {
        return OverrideMethod.invokeI("android.view.RenderNode#nGetAmbientShadowColor(J)I", true, null);
    }

    @CriticalNative
    private static boolean nSetClipToOutline(long l, boolean bl) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetClipToOutline(JZ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetRevealClip(long l, boolean bl, float f, float f2, float f3) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetRevealClip(JZFFF)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetAlpha(long l, float f) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetAlpha(JF)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetHasOverlappingRendering(long l, boolean bl) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetHasOverlappingRendering(JZ)Z", true, null) != 0;
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetElevation(long l, float f) {
        return RenderNode_Delegate.nSetElevation(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetTranslationX(long l, float f) {
        return RenderNode_Delegate.nSetTranslationX(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetTranslationY(long l, float f) {
        return RenderNode_Delegate.nSetTranslationY(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetTranslationZ(long l, float f) {
        return RenderNode_Delegate.nSetTranslationZ(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetRotation(long l, float f) {
        return RenderNode_Delegate.nSetRotation(l, f);
    }

    @CriticalNative
    private static boolean nSetRotationX(long l, float f) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetRotationX(JF)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetRotationY(long l, float f) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetRotationY(JF)Z", true, null) != 0;
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetScaleX(long l, float f) {
        return RenderNode_Delegate.nSetScaleX(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetScaleY(long l, float f) {
        return RenderNode_Delegate.nSetScaleY(l, f);
    }

    @CriticalNative
    private static boolean nSetStaticMatrix(long l, long l2) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetStaticMatrix(JJ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetAnimationMatrix(long l, long l2) {
        return OverrideMethod.invokeI("android.view.RenderNode#nSetAnimationMatrix(JJ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nHasOverlappingRendering(long l) {
        return OverrideMethod.invokeI("android.view.RenderNode#nHasOverlappingRendering(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nGetClipToOutline(long l) {
        return OverrideMethod.invokeI("android.view.RenderNode#nGetClipToOutline(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static float nGetAlpha(long l) {
        return OverrideMethod.invokeF("android.view.RenderNode#nGetAlpha(J)F", true, null);
    }

    @CriticalNative
    private static float nGetCameraDistance(long l) {
        return OverrideMethod.invokeF("android.view.RenderNode#nGetCameraDistance(J)F", true, null);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetScaleX(long l) {
        return RenderNode_Delegate.nGetScaleX(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetScaleY(long l) {
        return RenderNode_Delegate.nGetScaleY(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetElevation(long l) {
        return RenderNode_Delegate.nGetElevation(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetTranslationX(long l) {
        return RenderNode_Delegate.nGetTranslationX(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetTranslationY(long l) {
        return RenderNode_Delegate.nGetTranslationY(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetTranslationZ(long l) {
        return RenderNode_Delegate.nGetTranslationZ(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetRotation(long l) {
        return RenderNode_Delegate.nGetRotation(l);
    }

    @CriticalNative
    private static float nGetRotationX(long l) {
        return OverrideMethod.invokeF("android.view.RenderNode#nGetRotationX(J)F", true, null);
    }

    @CriticalNative
    private static float nGetRotationY(long l) {
        return OverrideMethod.invokeF("android.view.RenderNode#nGetRotationY(J)F", true, null);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nIsPivotExplicitlySet(long l) {
        return RenderNode_Delegate.nIsPivotExplicitlySet(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetPivotX(long l) {
        return RenderNode_Delegate.nGetPivotX(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetPivotY(long l) {
        return RenderNode_Delegate.nGetPivotY(l);
    }

    static /* synthetic */ long access$000() {
        return RenderNode.nGetNativeFinalizer();
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = new NativeAllocationRegistry(RenderNode.class.getClassLoader(), RenderNode.access$000(), 1024L);

        private NoImagePreloadHolder() {
        }
    }
}

