/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.MarshalRegistry;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.util.Range;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public class MarshalQueryableRange<T extends Comparable<? super T>>
implements MarshalQueryable<Range<T>> {
    private static final int RANGE_COUNT = 2;

    @Override
    public Marshaler<Range<T>> createMarshaler(TypeReference<Range<T>> managedType, int nativeType) {
        return new MarshalerRange(managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<Range<T>> managedType, int nativeType) {
        return Range.class.equals(managedType.getRawType());
    }

    private class MarshalerRange
    extends Marshaler<Range<T>> {
        private final Class<? super Range<T>> mClass;
        private final Constructor<Range<T>> mConstructor;
        private final Marshaler<T> mNestedTypeMarshaler;

        protected MarshalerRange(TypeReference<Range<T>> typeReference, int nativeType) {
            ParameterizedType paramType;
            super(MarshalQueryableRange.this, typeReference, nativeType);
            this.mClass = typeReference.getRawType();
            try {
                paramType = (ParameterizedType)typeReference.getType();
            }
            catch (ClassCastException e) {
                throw new AssertionError("Raw use of Range is not supported", e);
            }
            Type actualTypeArgument = paramType.getActualTypeArguments()[0];
            TypeReference<?> actualTypeArgToken = TypeReference.createSpecializedTypeReference(actualTypeArgument);
            this.mNestedTypeMarshaler = MarshalRegistry.getMarshaler(actualTypeArgToken, this.mNativeType);
            try {
                this.mConstructor = this.mClass.getConstructor(Comparable.class, Comparable.class);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void marshal(Range<T> value, ByteBuffer buffer) {
            this.mNestedTypeMarshaler.marshal(value.getLower(), buffer);
            this.mNestedTypeMarshaler.marshal(value.getUpper(), buffer);
        }

        @Override
        public Range<T> unmarshal(ByteBuffer buffer) {
            Comparable lower = (Comparable)this.mNestedTypeMarshaler.unmarshal(buffer);
            Comparable upper = (Comparable)this.mNestedTypeMarshaler.unmarshal(buffer);
            try {
                return this.mConstructor.newInstance(lower, upper);
            }
            catch (InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public int getNativeSize() {
            int nestedSize = this.mNestedTypeMarshaler.getNativeSize();
            if (nestedSize != NATIVE_SIZE_DYNAMIC) {
                return nestedSize * 2;
            }
            return NATIVE_SIZE_DYNAMIC;
        }

        @Override
        public int calculateMarshalSize(Range<T> value) {
            int nativeSize = this.getNativeSize();
            if (nativeSize != NATIVE_SIZE_DYNAMIC) {
                return nativeSize;
            }
            int lowerSize = this.mNestedTypeMarshaler.calculateMarshalSize(value.getLower());
            int upperSize = this.mNestedTypeMarshaler.calculateMarshalSize(value.getUpper());
            return lowerSize + upperSize;
        }
    }
}

