/*
 * Decompiled with CFR 0.152.
 */
package android.app.slice;

import android.app.slice.ISliceManager;
import android.app.slice.Slice;
import android.app.slice.SliceSpec;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SliceManager {
    private static final String TAG = "SliceManager";
    public static final String ACTION_REQUEST_SLICE_PERMISSION = "com.android.intent.action.REQUEST_SLICE_PERMISSION";
    public static final String CATEGORY_SLICE = "android.app.slice.category.SLICE";
    public static final String SLICE_METADATA_KEY = "android.metadata.SLICE_URI";
    private final ISliceManager mService;
    private final Context mContext;
    private final IBinder mToken = new Binder();

    public SliceManager(Context context, Handler handler) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mService = ISliceManager.Stub.asInterface(ServiceManager.getServiceOrThrow("slice"));
    }

    public void pinSlice(Uri uri, Set<SliceSpec> specs) {
        try {
            this.mService.pinSlice(this.mContext.getPackageName(), uri, specs.toArray(new SliceSpec[specs.size()]), this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void pinSlice(Uri uri, List<SliceSpec> specs) {
        this.pinSlice(uri, new ArraySet<SliceSpec>(specs));
    }

    public void unpinSlice(Uri uri) {
        try {
            this.mService.unpinSlice(this.mContext.getPackageName(), uri, this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean hasSliceAccess() {
        try {
            return this.mService.hasSliceAccess(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Set<SliceSpec> getPinnedSpecs(Uri uri) {
        try {
            return new ArraySet<SliceSpec>(Arrays.asList(this.mService.getPinnedSpecs(uri, this.mContext.getPackageName())));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<Uri> getPinnedSlices() {
        try {
            return Arrays.asList(this.mService.getPinnedSlices(this.mContext.getPackageName()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Collection<Uri> getSliceDescendants(Uri uri) {
        ArrayList<Uri> arrayList;
        block8: {
            ContentResolver resolver = this.mContext.getContentResolver();
            ContentProviderClient provider = resolver.acquireUnstableContentProviderClient(uri);
            Throwable throwable = null;
            try {
                Bundle extras = new Bundle();
                extras.putParcelable("slice_uri", uri);
                Bundle res = provider.call("get_descendants", null, extras);
                arrayList = res.getParcelableArrayList("slice_descendants");
                if (provider == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (provider != null) {
                            SliceManager.$closeResource(throwable, provider);
                        }
                        throw throwable3;
                    }
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Unable to get slice descendants", e);
                    return Collections.emptyList();
                }
            }
            SliceManager.$closeResource(throwable, provider);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Slice bindSlice(Uri uri, Set<SliceSpec> supportedSpecs) {
        Preconditions.checkNotNull(uri, "uri");
        ContentResolver resolver = this.mContext.getContentResolver();
        try (ContentProviderClient provider = resolver.acquireUnstableContentProviderClient(uri);){
            if (provider == null) {
                Log.w(TAG, String.format("Unknown URI: %s", uri));
                Slice slice = null;
                return slice;
            }
            Bundle extras = new Bundle();
            extras.putParcelable("slice_uri", uri);
            extras.putParcelableArrayList("supported_specs", new ArrayList<SliceSpec>(supportedSpecs));
            Bundle res = provider.call("bind_slice", null, extras);
            Bundle.setDefusable(res, true);
            if (res == null) {
                Slice slice = null;
                return slice;
            }
            Slice slice = (Slice)res.getParcelable("slice");
            return slice;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Deprecated
    public Slice bindSlice(Uri uri, List<SliceSpec> supportedSpecs) {
        return this.bindSlice(uri, new ArraySet<SliceSpec>(supportedSpecs));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Uri mapIntentToUri(Intent intent) {
        ContentResolver resolver = this.mContext.getContentResolver();
        Uri staticUri = this.resolveStatic(intent, resolver);
        if (staticUri != null) {
            return staticUri;
        }
        String authority = this.getAuthority(intent);
        if (authority == null) {
            return null;
        }
        Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
        try (ContentProviderClient provider = resolver.acquireUnstableContentProviderClient(uri);){
            if (provider == null) {
                Log.w(TAG, String.format("Unknown URI: %s", uri));
                Uri uri2 = null;
                return uri2;
            }
            Bundle extras = new Bundle();
            extras.putParcelable("slice_intent", intent);
            Bundle res = provider.call("map_only", null, extras);
            if (res == null) {
                Uri uri3 = null;
                return uri3;
            }
            Uri uri4 = (Uri)res.getParcelable("slice");
            return uri4;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private String getAuthority(Intent intent) {
        List<ResolveInfo> providers;
        Intent queryIntent = new Intent(intent);
        if (!queryIntent.hasCategory(CATEGORY_SLICE)) {
            queryIntent.addCategory(CATEGORY_SLICE);
        }
        return (providers = this.mContext.getPackageManager().queryIntentContentProviders(queryIntent, 0)) != null && !providers.isEmpty() ? providers.get((int)0).providerInfo.authority : null;
    }

    private Uri resolveStatic(Intent intent, ContentResolver resolver) {
        Preconditions.checkNotNull(intent, "intent");
        Preconditions.checkArgument(intent.getComponent() != null || intent.getPackage() != null || intent.getData() != null, "Slice intent must be explicit %s", intent);
        Uri intentData = intent.getData();
        if (intentData != null && "vnd.android.slice".equals(resolver.getType(intentData))) {
            return intentData;
        }
        ResolveInfo resolve = this.mContext.getPackageManager().resolveActivity(intent, 128);
        if (resolve != null && resolve.activityInfo != null && resolve.activityInfo.metaData != null && resolve.activityInfo.metaData.containsKey(SLICE_METADATA_KEY)) {
            return Uri.parse(resolve.activityInfo.metaData.getString(SLICE_METADATA_KEY));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Slice bindSlice(Intent intent, Set<SliceSpec> supportedSpecs) {
        Preconditions.checkNotNull(intent, "intent");
        Preconditions.checkArgument(intent.getComponent() != null || intent.getPackage() != null || intent.getData() != null, "Slice intent must be explicit %s", intent);
        ContentResolver resolver = this.mContext.getContentResolver();
        Uri staticUri = this.resolveStatic(intent, resolver);
        if (staticUri != null) {
            return this.bindSlice(staticUri, supportedSpecs);
        }
        String authority = this.getAuthority(intent);
        if (authority == null) {
            return null;
        }
        Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
        try (ContentProviderClient provider = resolver.acquireUnstableContentProviderClient(uri);){
            if (provider == null) {
                Log.w(TAG, String.format("Unknown URI: %s", uri));
                Slice slice = null;
                return slice;
            }
            Bundle extras = new Bundle();
            extras.putParcelable("slice_intent", intent);
            Bundle res = provider.call("map_slice", null, extras);
            if (res == null) {
                Slice slice = null;
                return slice;
            }
            Slice slice = (Slice)res.getParcelable("slice");
            return slice;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Deprecated
    public Slice bindSlice(Intent intent, List<SliceSpec> supportedSpecs) {
        return this.bindSlice(intent, new ArraySet<SliceSpec>(supportedSpecs));
    }

    public int checkSlicePermission(Uri uri, int pid, int uid) {
        try {
            return this.mService.checkSlicePermission(uri, null, pid, uid, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void grantSlicePermission(String toPackage, Uri uri) {
        try {
            this.mService.grantSlicePermission(this.mContext.getPackageName(), toPackage, uri);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void revokeSlicePermission(String toPackage, Uri uri) {
        try {
            this.mService.revokeSlicePermission(this.mContext.getPackageName(), toPackage, uri);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void enforceSlicePermission(Uri uri, String pkg, int pid, int uid, String[] autoGrantPermissions) {
        try {
            if (UserHandle.isSameApp(uid, Process.myUid())) {
                return;
            }
            if (pkg == null) {
                throw new SecurityException("No pkg specified");
            }
            int result = this.mService.checkSlicePermission(uri, pkg, pid, uid, autoGrantPermissions);
            if (result == -1) {
                throw new SecurityException("User " + uid + " does not have slice permission for " + uri + ".");
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void grantPermissionFromUser(Uri uri, String pkg, boolean allSlices) {
        try {
            this.mService.grantPermissionFromUser(uri, pkg, this.mContext.getPackageName(), allSlices);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

