/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.animation;

import android.graphics.Path;
import android.util.MathUtils;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.BaseInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.CycleInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.PathInterpolator;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class NativeInterpolatorFactoryHelper_Delegate {
    private static final DelegateManager<Interpolator> sManager = new DelegateManager<Interpolator>(Interpolator.class);

    public static Interpolator getDelegate(long nativePtr) {
        return sManager.getDelegate(nativePtr);
    }

    @LayoutlibDelegate
    static long createAccelerateDecelerateInterpolator() {
        return sManager.addNewDelegate(new AccelerateDecelerateInterpolator());
    }

    @LayoutlibDelegate
    static long createAccelerateInterpolator(float factor) {
        return sManager.addNewDelegate(new AccelerateInterpolator(factor));
    }

    @LayoutlibDelegate
    static long createAnticipateInterpolator(float tension) {
        return sManager.addNewDelegate(new AnticipateInterpolator(tension));
    }

    @LayoutlibDelegate
    static long createAnticipateOvershootInterpolator(float tension) {
        return sManager.addNewDelegate(new AnticipateOvershootInterpolator(tension));
    }

    @LayoutlibDelegate
    static long createBounceInterpolator() {
        return sManager.addNewDelegate(new BounceInterpolator());
    }

    @LayoutlibDelegate
    static long createCycleInterpolator(float cycles) {
        return sManager.addNewDelegate(new CycleInterpolator(cycles));
    }

    @LayoutlibDelegate
    static long createDecelerateInterpolator(float factor) {
        return sManager.addNewDelegate(new DecelerateInterpolator(factor));
    }

    @LayoutlibDelegate
    static long createLinearInterpolator() {
        return sManager.addNewDelegate(new LinearInterpolator());
    }

    @LayoutlibDelegate
    static long createOvershootInterpolator(float tension) {
        return sManager.addNewDelegate(new OvershootInterpolator(tension));
    }

    @LayoutlibDelegate
    static long createPathInterpolator(float[] x, float[] y) {
        Path path = new Path();
        path.moveTo(x[0], y[0]);
        for (int i = 1; i < x.length; ++i) {
            path.lineTo(x[i], y[i]);
        }
        return sManager.addNewDelegate(new PathInterpolator(path));
    }

    @LayoutlibDelegate
    static long createLutInterpolator(float[] values) {
        return sManager.addNewDelegate(new LutInterpolator(values));
    }

    private static class LutInterpolator
    extends BaseInterpolator {
        private final float[] mValues;
        private final int mSize;

        private LutInterpolator(float[] values) {
            this.mValues = values;
            this.mSize = this.mValues.length;
        }

        @Override
        public float getInterpolation(float input) {
            float lutpos = input * (float)(this.mSize - 1);
            if (lutpos >= (float)(this.mSize - 1)) {
                return this.mValues[this.mSize - 1];
            }
            int ipart = (int)lutpos;
            float weight = lutpos - (float)ipart;
            int i1 = ipart;
            int i2 = Math.min(i1 + 1, this.mSize - 1);
            assert (i1 >= 0 && i2 >= 0) : "Negatives in the interpolation";
            return MathUtils.lerp(this.mValues[i1], this.mValues[i2], weight);
        }
    }
}

