/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

import android.graphics.Bitmap;
import android.view.math.Math3DHelper;
import android.view.shadow.SpotShadowConfig;
import android.view.shadow.SpotShadowVertexCalculator;
import android.view.shadow.TriangleBuffer;
import com.android.layoutlib.bridge.Bridge;

class SpotShadowBitmapGenerator {
    private final SpotShadowConfig mShadowConfig;
    private final TriangleBuffer mTriangle = new TriangleBuffer();
    private float[] mStrips;
    private float[] mLightSources;
    private float mTranslateX;
    private float mTranslateY;

    public SpotShadowBitmapGenerator(SpotShadowConfig config) {
        this.mShadowConfig = config;
        this.mTriangle.setSize(config.getWidth(), config.getHeight(), 0);
    }

    public void populateShadow() {
        try {
            this.mLightSources = SpotShadowVertexCalculator.calculateLight(this.mShadowConfig.getLightRadius(), this.mShadowConfig.getLightSourcePoints(), this.mShadowConfig.getLightCoord()[0], this.mShadowConfig.getLightCoord()[1], this.mShadowConfig.getLightCoord()[2]);
            this.mStrips = new float[3 * SpotShadowVertexCalculator.getStripSize(this.mShadowConfig.getRays(), this.mShadowConfig.getLayers())];
            if (SpotShadowVertexCalculator.calculateShadow(this.mLightSources, this.mShadowConfig.getLightSourcePoints(), this.mShadowConfig.getPoly(), this.mShadowConfig.getPolyLength(), this.mShadowConfig.getRays(), this.mShadowConfig.getLayers(), this.mShadowConfig.getShadowStrength(), this.mStrips) != 1) {
                return;
            }
            float[] shadowBounds = Math3DHelper.flatBound(this.mStrips, 3);
            if (shadowBounds[2] - shadowBounds[0] > (float)this.mShadowConfig.getWidth() || shadowBounds[3] - shadowBounds[1] > (float)this.mShadowConfig.getHeight()) {
                return;
            }
            this.mTranslateX = 0.0f;
            this.mTranslateY = 0.0f;
            if (shadowBounds[0] < 0.0f) {
                this.mTranslateX = shadowBounds[0] * -1.0f;
            } else if (shadowBounds[2] > (float)this.mShadowConfig.getWidth()) {
                this.mTranslateX = shadowBounds[2] - (float)this.mShadowConfig.getWidth();
            }
            if (shadowBounds[1] < 0.0f) {
                this.mTranslateY = shadowBounds[1] * -1.0f;
            } else if (shadowBounds[3] > (float)this.mShadowConfig.getHeight()) {
                this.mTranslateY = shadowBounds[3] - (float)this.mShadowConfig.getHeight();
            }
            Math3DHelper.translate(this.mStrips, this.mTranslateX, this.mTranslateY, 3);
            this.mTriangle.drawTriangles(this.mStrips, this.mShadowConfig.getShadowStrength());
        }
        catch (ArithmeticException | IndexOutOfBoundsException mathError) {
            Bridge.getLog().warning("info", "Arithmetic error while drawing spot shadow", (Object)mathError);
        }
        catch (Exception ex) {
            Bridge.getLog().warning("info", "Error while drawing shadow", (Object)ex);
        }
    }

    public float getTranslateX() {
        return this.mTranslateX;
    }

    public float getTranslateY() {
        return this.mTranslateY;
    }

    public void clear() {
        this.mTriangle.clear();
    }

    public boolean validate() {
        return this.mStrips != null && this.mStrips.length >= 9;
    }

    public Bitmap getBitmap() {
        return this.mTriangle.getImage();
    }

    public float[] getStrips() {
        return this.mStrips;
    }

    public void updateLightSource(float x, float y) {
        this.mShadowConfig.setLightCoord(x, y);
    }
}

