/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.app.ActivityManager;
import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.biometrics.BiometricFingerprintConstants;
import android.hardware.biometrics.IBiometricPromptReceiver;
import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.fingerprint.IFingerprintServiceLockoutResetCallback;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.util.Slog;
import java.security.Signature;
import java.util.List;
import java.util.concurrent.Executor;
import javax.crypto.Cipher;
import javax.crypto.Mac;

@Deprecated
public class FingerprintManager
implements BiometricFingerprintConstants {
    private static final String TAG = "FingerprintManager";
    private static final boolean DEBUG = true;
    private static final int MSG_ENROLL_RESULT = 100;
    private static final int MSG_ACQUIRED = 101;
    private static final int MSG_AUTHENTICATION_SUCCEEDED = 102;
    private static final int MSG_AUTHENTICATION_FAILED = 103;
    private static final int MSG_ERROR = 104;
    private static final int MSG_REMOVED = 105;
    private static final int MSG_ENUMERATED = 106;
    private IFingerprintService mService;
    private Context mContext;
    private IBinder mToken = new Binder();
    private BiometricAuthenticator.AuthenticationCallback mAuthenticationCallback;
    private EnrollmentCallback mEnrollmentCallback;
    private RemovalCallback mRemovalCallback;
    private EnumerateCallback mEnumerateCallback;
    private android.hardware.biometrics.CryptoObject mCryptoObject;
    private Fingerprint mRemovalFingerprint;
    private Handler mHandler;
    private Executor mExecutor;
    private IFingerprintServiceReceiver mServiceReceiver = new IFingerprintServiceReceiver.Stub(){

        @Override
        public void onEnrollResult(long deviceId, int fingerId, int groupId, int remaining) {
            FingerprintManager.this.mHandler.obtainMessage(100, remaining, 0, new Fingerprint(null, groupId, fingerId, deviceId)).sendToTarget();
        }

        @Override
        public void onAcquired(long deviceId, int acquireInfo, int vendorCode) {
            if (FingerprintManager.this.mExecutor != null) {
                FingerprintManager.this.mExecutor.execute(() -> FingerprintManager.this.sendAcquiredResult(deviceId, acquireInfo, vendorCode));
            } else {
                FingerprintManager.this.mHandler.obtainMessage(101, acquireInfo, vendorCode, deviceId).sendToTarget();
            }
        }

        @Override
        public void onAuthenticationSucceeded(long deviceId, Fingerprint fp, int userId) {
            if (FingerprintManager.this.mExecutor != null) {
                FingerprintManager.this.mExecutor.execute(() -> FingerprintManager.this.sendAuthenticatedSucceeded(fp, userId));
            } else {
                FingerprintManager.this.mHandler.obtainMessage(102, userId, 0, fp).sendToTarget();
            }
        }

        @Override
        public void onAuthenticationFailed(long deviceId) {
            if (FingerprintManager.this.mExecutor != null) {
                FingerprintManager.this.mExecutor.execute(() -> FingerprintManager.this.sendAuthenticatedFailed());
            } else {
                FingerprintManager.this.mHandler.obtainMessage(103).sendToTarget();
            }
        }

        @Override
        public void onError(long deviceId, int error, int vendorCode) {
            if (FingerprintManager.this.mExecutor != null) {
                if (error == 10 || error == 5) {
                    FingerprintManager.this.mExecutor.execute(() -> FingerprintManager.this.sendErrorResult(deviceId, error, vendorCode));
                } else {
                    FingerprintManager.this.mHandler.postDelayed(() -> FingerprintManager.this.mExecutor.execute(() -> FingerprintManager.this.sendErrorResult(deviceId, error, vendorCode)), 2000L);
                }
            } else {
                FingerprintManager.this.mHandler.obtainMessage(104, error, vendorCode, deviceId).sendToTarget();
            }
        }

        @Override
        public void onRemoved(long deviceId, int fingerId, int groupId, int remaining) {
            FingerprintManager.this.mHandler.obtainMessage(105, remaining, 0, new Fingerprint(null, groupId, fingerId, deviceId)).sendToTarget();
        }

        @Override
        public void onEnumerated(long deviceId, int fingerId, int groupId, int remaining) {
            FingerprintManager.this.mHandler.obtainMessage(106, fingerId, groupId, deviceId).sendToTarget();
        }
    };

    @Deprecated
    public void authenticate(CryptoObject crypto, CancellationSignal cancel, int flags, AuthenticationCallback callback, Handler handler) {
        this.authenticate(crypto, cancel, flags, callback, handler, this.mContext.getUserId());
    }

    private void useHandler(Handler handler) {
        if (handler != null) {
            this.mHandler = new MyHandler(handler.getLooper());
        } else if (this.mHandler.getLooper() != this.mContext.getMainLooper()) {
            this.mHandler = new MyHandler(this.mContext.getMainLooper());
        }
    }

    public void authenticate(CryptoObject crypto, CancellationSignal cancel, int flags, AuthenticationCallback callback, Handler handler, int userId) {
        block6: {
            if (callback == null) {
                throw new IllegalArgumentException("Must supply an authentication callback");
            }
            if (cancel != null) {
                if (cancel.isCanceled()) {
                    Slog.w(TAG, "authentication already canceled");
                    return;
                }
                cancel.setOnCancelListener(new OnAuthenticationCancelListener(crypto));
            }
            if (this.mService != null) {
                try {
                    this.useHandler(handler);
                    this.mAuthenticationCallback = callback;
                    this.mCryptoObject = crypto;
                    long sessionId = crypto != null ? crypto.getOpId() : 0L;
                    this.mService.authenticate(this.mToken, sessionId, userId, this.mServiceReceiver, flags, this.mContext.getOpPackageName(), null, null);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Remote exception while authenticating: ", e);
                    if (callback == null) break block6;
                    callback.onAuthenticationError(1, this.getErrorString(1, 0));
                }
            }
        }
    }

    private void authenticate(int userId, android.hardware.biometrics.CryptoObject crypto, CancellationSignal cancel, Bundle bundle, Executor executor, IBiometricPromptReceiver receiver, BiometricAuthenticator.AuthenticationCallback callback) {
        this.mCryptoObject = crypto;
        if (cancel.isCanceled()) {
            Slog.w(TAG, "authentication already canceled");
            return;
        }
        cancel.setOnCancelListener(new OnAuthenticationCancelListener(crypto));
        if (this.mService != null) {
            try {
                this.mExecutor = executor;
                this.mAuthenticationCallback = callback;
                long sessionId = crypto != null ? crypto.getOpId() : 0L;
                this.mService.authenticate(this.mToken, sessionId, userId, this.mServiceReceiver, 0, this.mContext.getOpPackageName(), bundle, receiver);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Remote exception while authenticating", e);
                this.mExecutor.execute(() -> callback.onAuthenticationError(1, this.getErrorString(1, 0)));
            }
        }
    }

    public void authenticate(CancellationSignal cancel, Bundle bundle, Executor executor, IBiometricPromptReceiver receiver, BiometricAuthenticator.AuthenticationCallback callback) {
        if (cancel == null) {
            throw new IllegalArgumentException("Must supply a cancellation signal");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("Must supply a bundle");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must supply an executor");
        }
        if (receiver == null) {
            throw new IllegalArgumentException("Must supply a receiver");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Must supply a calback");
        }
        this.authenticate(this.mContext.getUserId(), null, cancel, bundle, executor, receiver, callback);
    }

    public void authenticate(android.hardware.biometrics.CryptoObject crypto, CancellationSignal cancel, Bundle bundle, Executor executor, IBiometricPromptReceiver receiver, BiometricAuthenticator.AuthenticationCallback callback) {
        if (crypto == null) {
            throw new IllegalArgumentException("Must supply a crypto object");
        }
        if (cancel == null) {
            throw new IllegalArgumentException("Must supply a cancellation signal");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("Must supply a bundle");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must supply an executor");
        }
        if (receiver == null) {
            throw new IllegalArgumentException("Must supply a receiver");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Must supply a callback");
        }
        this.authenticate(this.mContext.getUserId(), crypto, cancel, bundle, executor, receiver, callback);
    }

    public void enroll(byte[] token, CancellationSignal cancel, int flags, int userId, EnrollmentCallback callback) {
        block7: {
            if (userId == -2) {
                userId = this.getCurrentUserId();
            }
            if (callback == null) {
                throw new IllegalArgumentException("Must supply an enrollment callback");
            }
            if (cancel != null) {
                if (cancel.isCanceled()) {
                    Slog.w(TAG, "enrollment already canceled");
                    return;
                }
                cancel.setOnCancelListener(new OnEnrollCancelListener());
            }
            if (this.mService != null) {
                try {
                    this.mEnrollmentCallback = callback;
                    this.mService.enroll(this.mToken, token, userId, this.mServiceReceiver, flags, this.mContext.getOpPackageName());
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Remote exception in enroll: ", e);
                    if (callback == null) break block7;
                    callback.onEnrollmentError(1, this.getErrorString(1, 0));
                }
            }
        }
    }

    public long preEnroll() {
        long result = 0L;
        if (this.mService != null) {
            try {
                result = this.mService.preEnroll(this.mToken);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result;
    }

    public int postEnroll() {
        int result = 0;
        if (this.mService != null) {
            try {
                result = this.mService.postEnroll(this.mToken);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result;
    }

    public void setActiveUser(int userId) {
        if (this.mService != null) {
            try {
                this.mService.setActiveUser(userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void remove(Fingerprint fp, int userId, RemovalCallback callback) {
        block3: {
            if (this.mService != null) {
                try {
                    this.mRemovalCallback = callback;
                    this.mRemovalFingerprint = fp;
                    this.mService.remove(this.mToken, fp.getFingerId(), fp.getGroupId(), userId, this.mServiceReceiver);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Remote exception in remove: ", e);
                    if (callback == null) break block3;
                    callback.onRemovalError(fp, 1, this.getErrorString(1, 0));
                }
            }
        }
    }

    public void enumerate(int userId, EnumerateCallback callback) {
        block3: {
            if (this.mService != null) {
                try {
                    this.mEnumerateCallback = callback;
                    this.mService.enumerate(this.mToken, userId, this.mServiceReceiver);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Remote exception in enumerate: ", e);
                    if (callback == null) break block3;
                    callback.onEnumerateError(1, this.getErrorString(1, 0));
                }
            }
        }
    }

    public void rename(int fpId, int userId, String newName) {
        if (this.mService != null) {
            try {
                this.mService.rename(fpId, userId, newName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "rename(): Service not connected!");
        }
    }

    public List<Fingerprint> getEnrolledFingerprints(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getEnrolledFingerprints(userId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public List<Fingerprint> getEnrolledFingerprints() {
        return this.getEnrolledFingerprints(this.mContext.getUserId());
    }

    @Deprecated
    public boolean hasEnrolledFingerprints() {
        if (this.mService != null) {
            try {
                return this.mService.hasEnrolledFingerprints(this.mContext.getUserId(), this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean hasEnrolledFingerprints(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.hasEnrolledFingerprints(userId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @Deprecated
    public boolean isHardwareDetected() {
        if (this.mService != null) {
            try {
                long deviceId = 0L;
                return this.mService.isHardwareDetected(deviceId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        Slog.w(TAG, "isFingerprintHardwareDetected(): Service not connected!");
        return false;
    }

    public long getAuthenticatorId() {
        if (this.mService != null) {
            try {
                return this.mService.getAuthenticatorId(this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        Slog.w(TAG, "getAuthenticatorId(): Service not connected!");
        return 0L;
    }

    public void resetTimeout(byte[] token) {
        if (this.mService != null) {
            try {
                this.mService.resetTimeout(token);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "resetTimeout(): Service not connected!");
        }
    }

    public void addLockoutResetCallback(final LockoutResetCallback callback) {
        if (this.mService != null) {
            try {
                final PowerManager powerManager = this.mContext.getSystemService(PowerManager.class);
                this.mService.addLockoutResetCallback(new IFingerprintServiceLockoutResetCallback.Stub(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onLockoutReset(long deviceId, IRemoteCallback serverCallback) throws RemoteException {
                        try {
                            PowerManager.WakeLock wakeLock = powerManager.newWakeLock(1, "lockoutResetCallback");
                            wakeLock.acquire();
                            FingerprintManager.this.mHandler.post(() -> {
                                try {
                                    callback.onLockoutReset();
                                }
                                finally {
                                    wakeLock.release();
                                }
                            });
                        }
                        finally {
                            serverCallback.sendResult(null);
                        }
                    }
                });
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "addLockoutResetCallback(): Service not connected!");
        }
    }

    private void sendAuthenticatedSucceeded(Fingerprint fp, int userId) {
        if (this.mAuthenticationCallback != null) {
            BiometricAuthenticator.AuthenticationResult result = new BiometricAuthenticator.AuthenticationResult(this.mCryptoObject, fp, userId);
            this.mAuthenticationCallback.onAuthenticationSucceeded(result);
        }
    }

    private void sendAuthenticatedFailed() {
        if (this.mAuthenticationCallback != null) {
            this.mAuthenticationCallback.onAuthenticationFailed();
        }
    }

    private void sendAcquiredResult(long deviceId, int acquireInfo, int vendorCode) {
        int clientInfo;
        String msg;
        if (this.mAuthenticationCallback != null) {
            this.mAuthenticationCallback.onAuthenticationAcquired(acquireInfo);
        }
        if ((msg = this.getAcquiredString(acquireInfo, vendorCode)) == null) {
            return;
        }
        int n = clientInfo = acquireInfo == 6 ? vendorCode + 1000 : acquireInfo;
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onEnrollmentHelp(clientInfo, msg);
        } else if (this.mAuthenticationCallback != null) {
            this.mAuthenticationCallback.onAuthenticationHelp(clientInfo, msg);
        }
    }

    private void sendErrorResult(long deviceId, int errMsgId, int vendorCode) {
        int clientErrMsgId;
        int n = clientErrMsgId = errMsgId == 8 ? vendorCode + 1000 : errMsgId;
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onEnrollmentError(clientErrMsgId, this.getErrorString(errMsgId, vendorCode));
        } else if (this.mAuthenticationCallback != null) {
            this.mAuthenticationCallback.onAuthenticationError(clientErrMsgId, this.getErrorString(errMsgId, vendorCode));
        } else if (this.mRemovalCallback != null) {
            this.mRemovalCallback.onRemovalError(this.mRemovalFingerprint, clientErrMsgId, this.getErrorString(errMsgId, vendorCode));
        } else if (this.mEnumerateCallback != null) {
            this.mEnumerateCallback.onEnumerateError(clientErrMsgId, this.getErrorString(errMsgId, vendorCode));
        }
    }

    public FingerprintManager(Context context, IFingerprintService service) {
        this.mContext = context;
        this.mService = service;
        if (this.mService == null) {
            Slog.v(TAG, "FingerprintManagerService was null");
        }
        this.mHandler = new MyHandler(context);
    }

    private int getCurrentUserId() {
        try {
            return ActivityManager.getService().getCurrentUser().id;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void cancelEnrollment() {
        if (this.mService != null) {
            try {
                this.mService.cancelEnrollment(this.mToken);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private void cancelAuthentication(android.hardware.biometrics.CryptoObject cryptoObject) {
        if (this.mService != null) {
            try {
                this.mService.cancelAuthentication(this.mToken, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public String getErrorString(int errMsg, int vendorCode) {
        switch (errMsg) {
            case 2: {
                return this.mContext.getString(17039915);
            }
            case 1: {
                return this.mContext.getString(17039908);
            }
            case 4: {
                return this.mContext.getString(17039913);
            }
            case 3: {
                return this.mContext.getString(17039914);
            }
            case 5: {
                return this.mContext.getString(17039907);
            }
            case 7: {
                return this.mContext.getString(17039910);
            }
            case 9: {
                return this.mContext.getString(17039911);
            }
            case 10: {
                return this.mContext.getString(17039916);
            }
            case 11: {
                return this.mContext.getString(17039912);
            }
            case 12: {
                return this.mContext.getString(17039909);
            }
            case 8: {
                String[] msgArray = this.mContext.getResources().getStringArray(17236061);
                if (vendorCode >= msgArray.length) break;
                return msgArray[vendorCode];
            }
        }
        Slog.w(TAG, "Invalid error message: " + errMsg + ", " + vendorCode);
        return null;
    }

    public String getAcquiredString(int acquireInfo, int vendorCode) {
        switch (acquireInfo) {
            case 0: {
                return null;
            }
            case 1: {
                return this.mContext.getString(17039903);
            }
            case 2: {
                return this.mContext.getString(17039902);
            }
            case 3: {
                return this.mContext.getString(17039901);
            }
            case 4: {
                return this.mContext.getString(17039905);
            }
            case 5: {
                return this.mContext.getString(17039904);
            }
            case 6: {
                String[] msgArray = this.mContext.getResources().getStringArray(17236060);
                if (vendorCode >= msgArray.length) break;
                return msgArray[vendorCode];
            }
        }
        Slog.w(TAG, "Invalid acquired message: " + acquireInfo + ", " + vendorCode);
        return null;
    }

    private class MyHandler
    extends Handler {
        private MyHandler(Context context) {
            super(context.getMainLooper());
        }

        private MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    this.sendEnrollResult((Fingerprint)msg.obj, msg.arg1);
                    break;
                }
                case 101: {
                    FingerprintManager.this.sendAcquiredResult((Long)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 102: {
                    FingerprintManager.this.sendAuthenticatedSucceeded((Fingerprint)msg.obj, msg.arg1);
                    break;
                }
                case 103: {
                    FingerprintManager.this.sendAuthenticatedFailed();
                    break;
                }
                case 104: {
                    FingerprintManager.this.sendErrorResult((Long)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 105: {
                    this.sendRemovedResult((Fingerprint)msg.obj, msg.arg1);
                    break;
                }
                case 106: {
                    this.sendEnumeratedResult((Long)msg.obj, msg.arg1, msg.arg2);
                }
            }
        }

        private void sendRemovedResult(Fingerprint fingerprint, int remaining) {
            int reqGroupId;
            if (FingerprintManager.this.mRemovalCallback == null) {
                return;
            }
            if (fingerprint == null) {
                Slog.e(FingerprintManager.TAG, "Received MSG_REMOVED, but fingerprint is null");
                return;
            }
            int fingerId = fingerprint.getFingerId();
            int reqFingerId = FingerprintManager.this.mRemovalFingerprint.getFingerId();
            if (reqFingerId != 0 && fingerId != 0 && fingerId != reqFingerId) {
                Slog.w(FingerprintManager.TAG, "Finger id didn't match: " + fingerId + " != " + reqFingerId);
                return;
            }
            int groupId = fingerprint.getGroupId();
            if (groupId != (reqGroupId = FingerprintManager.this.mRemovalFingerprint.getGroupId())) {
                Slog.w(FingerprintManager.TAG, "Group id didn't match: " + groupId + " != " + reqGroupId);
                return;
            }
            FingerprintManager.this.mRemovalCallback.onRemovalSucceeded(fingerprint, remaining);
        }

        private void sendEnumeratedResult(long deviceId, int fingerId, int groupId) {
            if (FingerprintManager.this.mEnumerateCallback != null) {
                FingerprintManager.this.mEnumerateCallback.onEnumerate(new Fingerprint(null, groupId, fingerId, deviceId));
            }
        }

        private void sendEnrollResult(Fingerprint fp, int remaining) {
            if (FingerprintManager.this.mEnrollmentCallback != null) {
                FingerprintManager.this.mEnrollmentCallback.onEnrollmentProgress(remaining);
            }
        }
    }

    public static abstract class LockoutResetCallback {
        public void onLockoutReset() {
        }
    }

    public static abstract class EnumerateCallback {
        public void onEnumerateError(int errMsgId, CharSequence errString) {
        }

        public void onEnumerate(Fingerprint fingerprint) {
        }
    }

    public static abstract class RemovalCallback {
        public void onRemovalError(Fingerprint fp, int errMsgId, CharSequence errString) {
        }

        public void onRemovalSucceeded(Fingerprint fp, int remaining) {
        }
    }

    public static abstract class EnrollmentCallback {
        public void onEnrollmentError(int errMsgId, CharSequence errString) {
        }

        public void onEnrollmentHelp(int helpMsgId, CharSequence helpString) {
        }

        public void onEnrollmentProgress(int remaining) {
        }
    }

    @Deprecated
    public static abstract class AuthenticationCallback
    extends BiometricAuthenticator.AuthenticationCallback {
        @Override
        public void onAuthenticationError(int errorCode, CharSequence errString) {
        }

        @Override
        public void onAuthenticationHelp(int helpCode, CharSequence helpString) {
        }

        public void onAuthenticationSucceeded(AuthenticationResult result) {
        }

        @Override
        public void onAuthenticationFailed() {
        }

        @Override
        public void onAuthenticationAcquired(int acquireInfo) {
        }

        @Override
        public void onAuthenticationSucceeded(BiometricAuthenticator.AuthenticationResult result) {
            this.onAuthenticationSucceeded(new AuthenticationResult((CryptoObject)result.getCryptoObject(), (Fingerprint)result.getId(), result.getUserId()));
        }
    }

    @Deprecated
    public static class AuthenticationResult {
        private Fingerprint mFingerprint;
        private CryptoObject mCryptoObject;
        private int mUserId;

        public AuthenticationResult(CryptoObject crypto, Fingerprint fingerprint, int userId) {
            this.mCryptoObject = crypto;
            this.mFingerprint = fingerprint;
            this.mUserId = userId;
        }

        public CryptoObject getCryptoObject() {
            return this.mCryptoObject;
        }

        public Fingerprint getFingerprint() {
            return this.mFingerprint;
        }

        public int getUserId() {
            return this.mUserId;
        }
    }

    @Deprecated
    public static class CryptoObject
    extends android.hardware.biometrics.CryptoObject {
        public CryptoObject(Signature signature) {
            super(signature);
        }

        public CryptoObject(Cipher cipher) {
            super(cipher);
        }

        public CryptoObject(Mac mac) {
            super(mac);
        }

        @Override
        public Signature getSignature() {
            return super.getSignature();
        }

        @Override
        public Cipher getCipher() {
            return super.getCipher();
        }

        @Override
        public Mac getMac() {
            return super.getMac();
        }
    }

    private class OnAuthenticationCancelListener
    implements CancellationSignal.OnCancelListener {
        private android.hardware.biometrics.CryptoObject mCrypto;

        public OnAuthenticationCancelListener(android.hardware.biometrics.CryptoObject crypto) {
            this.mCrypto = crypto;
        }

        @Override
        public void onCancel() {
            FingerprintManager.this.cancelAuthentication(this.mCrypto);
        }
    }

    private class OnEnrollCancelListener
    implements CancellationSignal.OnCancelListener {
        private OnEnrollCancelListener() {
        }

        @Override
        public void onCancel() {
            FingerprintManager.this.cancelEnrollment();
        }
    }
}

